/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class IndexingThreads {
    private static ExecutorService executor;

    public static synchronized void initialize() {
        if (executor == null) {
            IndexingThreads.initializeExecutor();
        }
    }

    public static synchronized void shutdown() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    private static ExecutorService initializeExecutor() {
        if (executor == null) {
            final ThreadGroup tg = new ThreadGroup("Indexing-Worker-Group");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "Indexing-Worker-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            executor = Executors.newSingleThreadExecutor(tf);
        }
        return executor;
    }

    public static ExecutorService getExecutor() {
        ExecutorService service = executor;
        if (service == null) {
            throw new IllegalStateException("executor not initialized");
        }
        return service;
    }
}

