/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation.combinators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;

public class Union
extends AbstractRelation {
    Collection<GenericRelation> relations;

    public Union(Collection<GenericRelation> relations) {
        this.relations = relations;
    }

    @Override
    public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
        for (GenericRelation relation : this.relations) {
            if (!relation.contains(g, tuple)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRealizable() {
        for (GenericRelation relation : this.relations) {
            if (relation.isRealizable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Object[]> realize(ReadGraph g) throws DatabaseException {
        ArrayList<List<Object[]>> results = new ArrayList<List<Object[]>>(this.relations.size());
        for (GenericRelation relation : this.relations) {
            results.add(relation.realize(g));
        }
        int size = 0;
        for (List list : results) {
            size += list.size();
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(size);
        for (List list : results) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public GenericRelation selectByRelation(String bindingPattern, GenericRelation constraint) {
        ArrayList<GenericRelation> semijoinRelations = new ArrayList<GenericRelation>(this.relations.size());
        for (GenericRelation relation : this.relations) {
            semijoinRelations.add(relation.selectByRelation(bindingPattern, constraint));
        }
        return new Union(semijoinRelations);
    }

    @Override
    public GenericRelation select(String bindingPattern, Object[] constants) {
        ArrayList<GenericRelation> selectedRelations = new ArrayList<GenericRelation>(this.relations.size());
        for (GenericRelation relation : this.relations) {
            selectedRelations.add(relation.select(bindingPattern, constants));
        }
        return new Union(selectedRelations);
    }

    @Override
    public Pair<String, Class<?>>[] getFields() {
        Iterator<GenericRelation> iterator = this.relations.iterator();
        if (iterator.hasNext()) {
            GenericRelation relation = iterator.next();
            return relation.getFields();
        }
        return null;
    }
}

