/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.genericrelation.IndexRoots;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class DependencyChangesWriter {
    ReadGraph g;
    Layer0 l0;
    THashMap<Resource, DependencyChanges.Change> changesByResource = new THashMap();
    ArrayList<DependencyChanges.ComponentRemoval> removals = new ArrayList();

    public DependencyChangesWriter(ReadGraph g) {
        this.g = g;
        this.l0 = Layer0.getInstance((ReadGraph)g);
    }

    public void addComponentModification(Resource component) throws DatabaseException {
        if (!this.changesByResource.contains((Object)component)) {
            this.changesByResource.put((Object)component, (Object)new DependencyChanges.ComponentModification(component));
        }
    }

    public void addLinkChange(Resource component) throws DatabaseException {
        this.changesByResource.put((Object)component, (Object)new DependencyChanges.LinkChange(component));
    }

    public void addComponentAddition(Resource parent, Resource component) throws DatabaseException {
        this.changesByResource.put((Object)component, (Object)new DependencyChanges.ComponentAddition(component, parent));
    }

    public void addComponentRemoval(Resource parent, Resource component) throws DatabaseException {
        this.removals.add(new DependencyChanges.ComponentRemoval(component, parent));
    }

    public DependencyChanges getResult() throws DatabaseException {
        ArrayList<DependencyChanges.ComponentRemoval> modelChanges;
        Collection<Resource> models;
        THashMap changes = new THashMap();
        boolean hasUnresolved = false;
        for (Map.Entry entry : this.changesByResource.entrySet()) {
            Resource key = (Resource)entry.getKey();
            DependencyChanges.Change change = (DependencyChanges.Change)entry.getValue();
            models = (Collection<Resource>)this.g.syncRequest((Read)new IndexRoots(key), (Listener)TransientCacheListener.instance());
            for (Resource model : models) {
                modelChanges = (ArrayList<DependencyChanges.ComponentRemoval>)changes.get((Object)model);
                if (modelChanges == null) {
                    modelChanges = new ArrayList<DependencyChanges.ComponentRemoval>();
                    changes.put((Object)model, modelChanges);
                }
                modelChanges.add((DependencyChanges.ComponentRemoval)change);
            }
            if (!models.isEmpty() || change.getType() != DependencyChanges.ChangeType.COMPONENT_ADDITION) continue;
            hasUnresolved = true;
        }
        if (!this.removals.isEmpty()) {
            THashMap removedComponents = new THashMap(this.removals.size());
            for (DependencyChanges.ComponentRemoval removal : this.removals) {
                removedComponents.put((Object)removal.component, (Object)removal);
            }
            for (DependencyChanges.ComponentRemoval removal : this.removals) {
                Resource parent = removal.parent;
                models = this.getModelsForRemoved(this.g, parent, (THashMap<Resource, DependencyChanges.ComponentRemoval>)removedComponents);
                for (Resource model : models) {
                    modelChanges = (ArrayList<DependencyChanges.ComponentRemoval>)changes.get((Object)model);
                    if (modelChanges == null) {
                        modelChanges = new ArrayList<DependencyChanges.ComponentRemoval>();
                        changes.put((Object)model, modelChanges);
                    }
                    modelChanges.add(removal);
                }
                if (!models.isEmpty() || removedComponents.contains((Object)parent)) continue;
                hasUnresolved = true;
            }
        }
        return new DependencyChanges((Map<Resource, ArrayList<DependencyChanges.Change>>)changes, hasUnresolved);
    }

    private Collection<Resource> getModelsForRemoved(ReadGraph graph, Resource resource, THashMap<Resource, DependencyChanges.ComponentRemoval> removedComponents) throws DatabaseException {
        DependencyChanges.ComponentRemoval removal = (DependencyChanges.ComponentRemoval)removedComponents.get((Object)resource);
        if (removal == null) {
            return (Collection)graph.syncRequest((Read)new IndexRoots(resource), (Listener)TransientCacheListener.instance());
        }
        return this.getModelsForRemoved(graph, removal.parent, removedComponents);
    }
}

