/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ChangeSet;
import org.simantics.db.Metadata;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.SuperTypeString;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.genericrelation.DependencyChangesWriter;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.genericrelation.UnsupportedRelation;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncContextProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class DependenciesRelation
extends UnsupportedRelation
implements GenericRelationIndex {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_LISTENERS = false;
    private static final boolean PROFILE = false;
    private static final Pair<String, Class<?>>[] fields = new Pair[]{Pair.make((Object)"Model", Long.class), Pair.make((Object)"Parent", Long.class), Pair.make((Object)"Resource", Long.class), Pair.make((Object)"Name", String.class), Pair.make((Object)"Types", String.class)};
    final Resource resource;
    private static int trackers = 0;
    private static ChangeListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependenciesRelation(ReadGraph graph, Resource resource) {
        this.resource = resource;
        DependenciesRelation dependenciesRelation = this;
        synchronized (dependenciesRelation) {
            Session session = graph.getSession();
            DependenciesListenerStore store = (DependenciesListenerStore)session.peekService(DependenciesListenerStore.class);
            if (store == null) {
                session.registerService(DependenciesListenerStore.class, (Object)new DependenciesListenerStore());
            }
        }
    }

    public Collection<Entry> find(ReadGraph graph, Resource model) throws DatabaseException {
        return (DependenciesRelation)this.new Process((ReadGraph)graph, (Resource)model).result;
    }

    @Override
    public GenericRelation select(String bindingPattern, Object[] constants) {
        this.checkSelectionArguments(bindingPattern, constants, new String[]{"bffff"});
        final long subjectId = (Long)constants[0];
        return new UnsupportedRelation(){

            @Override
            public final List<Object[]> realize(ReadGraph graph) throws DatabaseException {
                long time = System.nanoTime();
                SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                Resource subject = ss.getResource(subjectId);
                Collection<Entry> entries = DependenciesRelation.this.find(graph, subject);
                long time2 = System.nanoTime();
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                for (Entry entry : entries) {
                    result.add(new Object[]{ss.getRandomAccessId(entry.parent), ss.getRandomAccessId(entry.resource), entry.name, entry.types});
                }
                return result;
            }
        };
    }

    @Override
    public Pair<String, Class<?>>[] getFields() {
        return fields;
    }

    @Override
    public List<Map<String, Object>> query(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!"bffff".equals(bindingPattern)) {
            throw new IllegalArgumentException("DependenciesRelation supports indexing only with 'bffff'");
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, search, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    @Override
    public List<Map<String, Object>> list(RequestProcessor session, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!"bffff".equals(bindingPattern)) {
            throw new IllegalArgumentException("DependenciesRelation supports indexing only with 'bffff'");
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, null, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    public static void assertFinishedTracking() {
        if (trackers != 0) {
            throw new IllegalStateException("Trackers should be 0 (was " + trackers + ")");
        }
    }

    @Override
    public synchronized void untrack(RequestProcessor processor, Resource model) {
        if (--trackers < 0) {
            throw new IllegalStateException("Dependency tracking reference count is broken");
        }
        if (trackers == 0) {
            if (listener == null) {
                throw new IllegalStateException("Dependency tracking was not active");
            }
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
            changeSupport.removeMetadataListener(listener);
            listener = null;
        }
    }

    @Override
    public synchronized void trackAndIndex(RequestProcessor processor, Resource model__) {
        if (trackers == 0) {
            if (listener != null) {
                throw new IllegalStateException("Dependency tracking was active");
            }
            listener = new GenericChangeListener<DependencyChangesRequest, DependencyChanges>(){

                public boolean preEventRequest() {
                    return !Indexing.isDependenciesIndexingDisabled();
                }

                public void onEvent(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
                    WriteGraph w = (WriteGraph)graph;
                    w.addMetadata((Metadata)event);
                    Session session = graph.getSession();
                    IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    for (Map.Entry<Resource, DependencyChanges.Change[]> modelEntry : event.get().entrySet()) {
                        boolean reset;
                        Resource model = modelEntry.getKey();
                        DependencyChanges.Change[] changes = modelEntry.getValue();
                        boolean linkChange = false;
                        List<Object[]> _additions = Collections.emptyList();
                        List<Object> _removals = Collections.emptyList();
                        List<Object> _replacementKeys = Collections.emptyList();
                        List<Object[]> _replacementObjects = Collections.emptyList();
                        Collection<Object> _typeChanges = Collections.emptyList();
                        if (changes != null) {
                            _additions = new ArrayList();
                            _removals = new ArrayList();
                            _replacementKeys = new ArrayList();
                            _replacementObjects = new ArrayList();
                            _typeChanges = new HashSet();
                            DependencyChanges.Change[] changeArray = changes;
                            int n = changes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String types;
                                String name;
                                DependencyChanges.Change entry;
                                DependencyChanges.Change _entry = changeArray[n2];
                                if (_entry instanceof DependencyChanges.ComponentAddition) {
                                    entry = (DependencyChanges.ComponentAddition)_entry;
                                    name = (String)graph.getPossibleRelatedValue(((DependencyChanges.ComponentAddition)entry).component, L0.HasName, (Binding)Bindings.STRING);
                                    types = (String)graph.syncRequest((Read)new TypeString(L0, graph.getTypes(((DependencyChanges.ComponentAddition)entry).component)));
                                    if (name != null && types != null) {
                                        if (((DependencyChanges.ComponentAddition)entry).isValid(graph)) {
                                            Resource parent = graph.getPossibleObject(((DependencyChanges.ComponentAddition)entry).component, L0.PartOf);
                                            if (parent != null) {
                                                _additions.add(new Object[]{ss.getRandomAccessId(parent), ss.getRandomAccessId(((DependencyChanges.ComponentAddition)entry).component), name, types});
                                            } else {
                                                System.err.println("resource " + DependenciesRelation.this.resource + ": no parent for entry " + name + " " + types);
                                            }
                                        }
                                    } else {
                                        System.err.println("resource " + DependenciesRelation.this.resource + ": " + name + " " + types);
                                    }
                                } else if (_entry instanceof DependencyChanges.ComponentModification) {
                                    entry = (DependencyChanges.ComponentModification)_entry;
                                    name = (String)graph.getPossibleRelatedValue(((DependencyChanges.ComponentModification)entry).component, L0.HasName, (Binding)Bindings.STRING);
                                    if (graph.isInstanceOf(((DependencyChanges.ComponentModification)entry).component, L0.Type)) {
                                        SerialisationSupport support = (SerialisationSupport)session.getService(SerialisationSupport.class);
                                        _typeChanges.add(new Pair((Object)name, (Object)String.valueOf(support.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component))));
                                    } else {
                                        Resource part;
                                        types = (String)graph.syncRequest((Read)new TypeString(L0, graph.getTypes(((DependencyChanges.ComponentModification)entry).component)));
                                        if (name != null && types != null && (part = graph.getPossibleObject(((DependencyChanges.ComponentModification)entry).component, L0.PartOf)) != null) {
                                            _replacementKeys.add(ss.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component));
                                            _replacementObjects.add(new Object[]{ss.getRandomAccessId(part), ss.getRandomAccessId(((DependencyChanges.ComponentModification)entry).component), name, types});
                                        }
                                    }
                                } else if (_entry instanceof DependencyChanges.ComponentRemoval) {
                                    entry = (DependencyChanges.ComponentRemoval)_entry;
                                    if (((DependencyChanges.ComponentRemoval)entry).isValid(graph)) {
                                        _removals.add(ss.getRandomAccessId(((DependencyChanges.ComponentRemoval)_entry).component));
                                    }
                                } else if (_entry instanceof DependencyChanges.LinkChange) {
                                    linkChange = true;
                                }
                                ++n2;
                            }
                        }
                        boolean bl = reset = linkChange || event.hasUnresolved;
                        if (!reset && _additions.isEmpty() && _removals.isEmpty() && _replacementKeys.isEmpty() && _typeChanges.isEmpty()) continue;
                        List<Object[]> additions = _additions;
                        List<Object> removals = _removals;
                        List<Object> replacementKeys = _replacementKeys;
                        List<Object[]> replacementObjects = _replacementObjects;
                        boolean typeNameChanges = DependenciesRelation.this.typeNameChanges(graph, indexer, model, _typeChanges);
                        UUID pending = Indexing.makeIndexPending();
                        try {
                            try {
                                boolean didChange = false;
                                boolean doReset = typeNameChanges;
                                if (doReset) {
                                    indexer.removeAll(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model);
                                    didChange = true;
                                } else {
                                    if (!replacementKeys.isEmpty() && replacementKeys.size() == replacementObjects.size()) {
                                        didChange |= indexer.replace(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, "Resource", replacementKeys, replacementObjects);
                                    }
                                    if (!removals.isEmpty()) {
                                        indexer.remove(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, "Resource", removals);
                                        didChange = true;
                                    }
                                    if (!additions.isEmpty()) {
                                        indexer.insert(null, (RequestProcessor)graph, DependenciesRelation.this, DependenciesRelation.this.resource, model, additions);
                                        didChange = true;
                                    }
                                }
                                if (didChange) {
                                    DependenciesRelation.this.fireListeners((RequestProcessor)graph, model);
                                }
                            }
                            catch (Throwable t) {
                                Logger.defaultLogError((String)("Dependencies index update failed for model " + model + " and relation " + DependenciesRelation.this.resource + "."), (Throwable)t);
                                t.printStackTrace();
                                Indexing.releaseIndexPending((UUID)pending);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            Indexing.releaseIndexPending((UUID)pending);
                            throw throwable;
                        }
                        Indexing.releaseIndexPending((UUID)pending);
                    }
                }
            };
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
            changeSupport.addMetadataListener(listener);
        }
        ++trackers;
    }

    private boolean typeNameChanges(ReadGraph graph, IndexedRelations indexer, Resource model, Collection<Pair<String, String>> typeChanges) throws DatabaseException {
        if (typeChanges.isEmpty()) {
            return false;
        }
        for (Pair<String, String> nr : typeChanges) {
            List<Map<String, Object>> results = indexer.query(null, "Resource:" + (String)nr.second, (RequestProcessor)graph, this.resource, model, Integer.MAX_VALUE);
            if (results.size() != 1) {
                return true;
            }
            Map<String, Object> result = results.get(0);
            if (ObjectUtils.objectEquals((Object)result.get("Name"), (Object)nr.first)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(RequestProcessor processor, Resource model, Runnable observer) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.addListener(model, observer);
    }

    @Override
    public void removeListener(RequestProcessor processor, Resource model, Runnable observer) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.removeListener(model, observer);
    }

    void fireListeners(RequestProcessor processor, Resource model) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().peekService(DependenciesListenerStore.class);
        if (store != null) {
            store.fireListeners(model);
        }
    }

    @Override
    public void reset(RequestProcessor processor, Resource input) {
        DependenciesListenerStore store = (DependenciesListenerStore)processor.getSession().getService(DependenciesListenerStore.class);
        store.fireListeners(input);
    }

    static class DependenciesListenerStore {
        private final Map<Resource, Set<Runnable>> listeners = new HashMap<Resource, Set<Runnable>>();

        DependenciesListenerStore() {
        }

        public synchronized void addListener(Resource model, Runnable listener) {
            THashSet list = this.listeners.get(model);
            if (list == null) {
                list = new THashSet();
                this.listeners.put(model, (Set<Runnable>)list);
            }
            list.add((Runnable)listener);
        }

        public synchronized void removeListener(Resource model, Runnable listener) {
            Set<Runnable> list = this.listeners.get(model);
            if (list == null) {
                return;
            }
            list.remove(listener);
        }

        public synchronized void fireListeners(Resource model) {
            Set<Runnable> list = this.listeners.get(model);
            if (list == null) {
                return;
            }
            for (Runnable r : list) {
                r.run();
            }
        }
    }

    public static class DependencyChangesRequest
    extends UnaryRead<ChangeSet, DependencyChanges> {
        private static final boolean LOG = false;

        public DependencyChangesRequest(ChangeSet parameter) {
            super((Object)parameter);
        }

        public DependencyChanges perform(ReadGraph graph) throws DatabaseException {
            DependencyChangesWriter w = new DependencyChangesWriter(graph);
            Layer0 l0 = w.l0;
            for (Resource value : ((ChangeSet)this.parameter).changedValues()) {
                Resource renamedComponent = graph.getPossibleObject(value, l0.PropertyOf);
                if (renamedComponent == null) continue;
                w.addComponentModification(renamedComponent);
            }
            for (Resource value : ((ChangeSet)this.parameter).changedResources()) {
                if (graph.isImmutable(value)) continue;
                w.addComponentModification(value);
            }
            for (ChangeSet.StatementChange change : ((ChangeSet)this.parameter).changedStatements()) {
                Resource subject = change.getSubject();
                Resource predicate = change.getPredicate();
                Resource object = change.getObject();
                if (predicate.equals(l0.ConsistsOf)) {
                    if (change.isClaim()) {
                        w.addComponentAddition(subject, object);
                        continue;
                    }
                    w.addComponentRemoval(subject, object);
                    continue;
                }
                if (predicate.equals(l0.IsLinkedTo)) {
                    w.addLinkChange(subject);
                    continue;
                }
                w.addComponentModification(subject);
            }
            return w.getResult();
        }
    }

    static class Entry
    implements Comparable<Entry> {
        final Resource parent;
        final Resource resource;
        String types;
        String name;
        Resource principalType;

        Entry(Resource parent, Resource resource, String name, String types) {
            this.parent = parent;
            this.resource = resource;
            this.name = name;
            this.types = types;
        }

        @Override
        public int compareTo(Entry o) {
            int names = this.name.compareTo(o.name);
            if (names != 0) {
                return names;
            }
            return this.resource.compareTo((Object)o.resource);
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            return this.resource.equals(other.resource);
        }
    }

    class Process {
        final ArrayList<Entry> result = new ArrayList();
        final AsyncContextMultiProcedure<Resource, Resource> structure;
        final AsyncContextProcedure<Entry, String> names;
        final AsyncContextProcedure<Entry, Resource> type;

        Process(ReadGraph graph, final Resource resource) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            this.names = dqs.compilePossibleRelatedValue(graph, L0.HasName, (AsyncContextProcedure)new AsyncContextProcedure<Entry, String>(){

                public void execute(AsyncReadGraph graph, Entry entry, String name) {
                    entry.name = name;
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    Logger.defaultLogError((Throwable)throwable);
                }
            });
            this.type = new AsyncContextProcedure<Entry, Resource>(){

                public void execute(AsyncReadGraph graph, Entry entry, Resource type) {
                    entry.principalType = type;
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    Logger.defaultLogError((Throwable)throwable);
                }
            };
            this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<Resource, Resource>(){

                public void execute(AsyncReadGraph graph, Resource parent, Resource child) {
                    if (!child.isPersistent()) {
                        return;
                    }
                    Entry entry = new Entry(parent, child, "", "");
                    Process.this.result.add(entry);
                    dqs.forEachObjectCompiled(graph, child, (Object)child, Process.this.structure);
                    dqs.forPossibleRelatedValueCompiled(graph, child, (Object)entry, Process.this.names);
                    dqs.forPossibleDirectType(graph, child, (Object)entry, Process.this.type);
                }

                public void finished(AsyncReadGraph graph) {
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    Logger.defaultLogError((Throwable)throwable);
                }
            });
            graph.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    dqs.forEachObjectCompiled((AsyncReadGraph)graph, resource, (Object)resource, Process.this.structure);
                }
            });
            Map typeStrings = (Map)cs.createMap(String.class);
            for (Entry e : this.result) {
                if (e.principalType != null) {
                    String typeString = (String)typeStrings.get(e.principalType);
                    if (typeString == null) {
                        typeString = (String)graph.syncRequest((Read)new SuperTypeString(e.principalType));
                        typeStrings.put(e.principalType, typeString);
                    }
                    e.types = typeString;
                    continue;
                }
                e.types = (String)graph.syncRequest((Read)new TypeString(L0, graph.getTypes(e.resource)));
            }
        }
    }
}

