/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.service.QueryControl;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl4;
import org.simantics.scl.runtime.function.UnsaturatedFunction2;
import org.simantics.utils.datastructures.Pair;

public class Dependencies
extends FunctionImpl4<ReadGraph, Resource, String, Integer, Object> {
    public static final String FIELD_MODEL = "Model";
    public static final String FIELD_PARENT = "Parent";
    public static final String FIELD_RESOURCE = "Resource";
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_TYPES = "Types";

    protected Resource getIndexRelation(ReadGraph graph) {
        return Layer0X.getInstance((ReadGraph)graph).DependenciesRelation;
    }

    protected String getBindingPattern() {
        return "bffff";
    }

    public Object apply(ReadGraph p0, Resource p1) {
        return new UnsaturatedFunction2((Function)this, (Object)p0, (Object)p1);
    }

    public Object apply(ReadGraph p0, Resource p1, String p2) {
        return this.apply(p0, p1, p2, Integer.MAX_VALUE);
    }

    public Object apply(ReadGraph graph, Resource model, String query, Integer _maxResults) {
        try {
            GenericRelationIndex index = (GenericRelationIndex)graph.adapt(this.getIndexRelation(graph), GenericRelationIndex.class);
            graph.syncRequest((ExternalRead)new ExternalRequest(index, model));
            int maxResults = _maxResults != null ? _maxResults : Integer.MAX_VALUE;
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            return index.query((RequestProcessor)qc.getIndependentGraph(graph), query, this.getBindingPattern(), new Object[]{model}, maxResults);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    static class ExternalRequest
    extends ParametrizedPrimitiveRead<Pair<GenericRelationIndex, Resource>, Long>
    implements Runnable {
        private static long value = 0L;
        private Session session;
        private Listener<Long> procedure;

        public ExternalRequest(GenericRelationIndex index, Resource model) {
            super((Object)Pair.make((Object)index, (Object)model));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(ReadGraph graph, Listener<Long> procedure) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                procedure.execute((Object)value++);
            }
            if (procedure.isDisposed()) {
                return;
            }
            assert (this.procedure == null);
            this.session = graph.getSession();
            this.procedure = procedure;
            ((GenericRelationIndex)((Pair)this.parameter).first).addListener((RequestProcessor)graph, (Resource)((Pair)this.parameter).second, this);
        }

        public void unregistered() {
            ((GenericRelationIndex)((Pair)this.parameter).first).removeListener((RequestProcessor)this.session, (Resource)((Pair)this.parameter).second, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.procedure.execute((Object)value++);
            }
        }
    }
}

