/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.Range;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.validation.L0Validations;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.request.HasEnumerationRange;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.UnescapedPropertyMapOfResource;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.ChildVariableMapRequest;
import org.simantics.db.layer0.variable.ExternalSetValue;
import org.simantics.db.layer0.variable.PropertyValueAccessorRequest;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.SubliteralPropertyVariable;
import org.simantics.db.layer0.variable.SubliteralPropertyVariableDeprecated;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableUtils;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.StringInputValidator;

public class All {
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor standardValueAccessor = new ValueAccessor(){

        @Override
        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor(graph, context);
            if (accessor != null) {
                return accessor.getValue(graph, context);
            }
            return All.standardGetValue(graph, context);
        }

        @Override
        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor(graph, context);
            if (accessor != null) {
                return accessor.getValue(graph, context, binding);
            }
            return All.standardGetValue(graph, context, binding);
        }

        @Override
        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor((ReadGraph)graph, context);
            if (accessor != null) {
                accessor.setValue(graph, context, value);
            } else {
                All.standardSetValue(graph, context, value);
            }
        }

        @Override
        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor((ReadGraph)graph, context);
            if (accessor != null) {
                accessor.setValue(graph, context, value, binding);
            } else {
                All.standardSetValue(graph, context, value, binding);
            }
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardChildDomainProperties = new VariableMapImpl(){

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            return All.getStandardChildDomainPropertyVariable(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return All.getStandardChildDomainPropertyVariables(graph, context, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardPropertyDomainProperties = new VariableMapImpl(){

        VariableMap getValueVariableMap(ReadGraph graph, Variable context) throws DatabaseException {
            Resource represents = context.getPossibleRepresents(graph);
            if (represents == null) {
                return null;
            }
            VariableMap map = (VariableMap)graph.getPossibleRelatedValue2(represents, Layer0.getInstance((ReadGraph)graph).domainProperties, (Object)represents);
            if (map == standardPropertyDomainProperties) {
                return null;
            }
            return map;
        }

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariable(graph, context, name);
            }
            return All.getStandardPropertyDomainPropertyVariableFromValue(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, map);
            }
            return All.getStandardPropertyDomainPropertyVariablesFromValue(graph, context, map);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, classification, map);
            }
            return All.getStandardPropertyDomainPropertyVariablesFromValue(graph, context, classification, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardChildDomainChildren = new VariableMapImpl(){

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            return All.getStandardChildDomainChildVariable(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return All.getStandardChildDomainChildVariables(graph, context, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardPropertyDomainChildren = new VariableMapImpl(){

        VariableMap getValueVariableMap(ReadGraph graph, Variable context) throws DatabaseException {
            Resource represents = context.getPossibleRepresents(graph);
            if (represents == null) {
                return null;
            }
            VariableMap map = (VariableMap)graph.syncRequest((Read)new ChildVariableMapRequest(represents));
            if (map == standardPropertyDomainChildren) {
                return null;
            }
            return map;
        }

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariable(graph, context, name);
            }
            if (context instanceof StandardGraphPropertyVariable) {
                ChildReference ref;
                StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
                Datatype dt = variable.getDatatype(graph);
                if (dt instanceof ArrayType && (ref = All.getPossibleIndexReference(name)) != null) {
                    return new SubliteralPropertyVariableDeprecated(variable, ref);
                }
                return null;
            }
            if (context instanceof StandardGraphChildVariable) {
                return standardChildDomainChildren.getVariable(graph, context, name);
            }
            throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, map);
            }
            if (context instanceof StandardGraphPropertyVariable) {
                return map;
            }
            if (context instanceof StandardGraphChildVariable) {
                return standardChildDomainChildren.getVariables(graph, context, map);
            }
            throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
        }
    };

    public static Object standardGetValue(ReadGraph graph, Variable context) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (variable.node != null) {
            Variant value = Variables.requestNodeValue(graph, variable.node);
            if (Variables.PENDING_NODE_VALUE == value) {
                throw new PendingVariableException("");
            }
            return value.getValue();
        }
        try {
            Resource object;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (((Boolean)graph.syncRequest((Read)new HasEnumerationRange(variable.property), (AsyncProcedure)TransientCacheAsyncListener.instance())).booleanValue() && ((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(object = variable.getRepresents(graph)))).booleanValue()) {
                if (graph.isInstanceOf(object, L0.Literal)) {
                    return graph.getValue(object);
                }
                String label = (String)graph.getPossibleRelatedValue2(variable.getRepresents(graph), L0.HasLabel, (Binding)Bindings.STRING);
                if (label == null) {
                    label = (String)graph.getPossibleRelatedValue(variable.getRepresents(graph), L0.HasName, (Binding)Bindings.STRING);
                }
                if (label == null) {
                    label = "<no label>";
                }
                return label;
            }
            if (variable.parentResource != null) {
                for (Resource assertion : (Collection)graph.syncRequest((Read)new ObjectsWithType(variable.parentResource, L0.Asserts, L0.Assertion))) {
                    if (!variable.property.equals(graph.getSingleObject(assertion, L0.HasPredicate))) continue;
                    return graph.getRelatedValue2(assertion, L0.HasObject, (Object)context);
                }
            }
            return graph.getValue2(variable.getRepresents(graph), (Object)context);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DatabaseException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    public static Object standardGetValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (variable.node != null) {
            try {
                Variant value = Variables.requestNodeValue(graph, variable.node);
                if (Variables.PENDING_NODE_VALUE == value) {
                    throw new PendingVariableException("");
                }
                return value.getValue(binding);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        try {
            Resource object;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (((Boolean)graph.syncRequest((Read)new HasEnumerationRange(variable.property), (AsyncProcedure)TransientCacheAsyncListener.instance())).booleanValue() && ((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(object = variable.getRepresents(graph)))).booleanValue()) {
                if (graph.isInstanceOf(object, L0.Literal)) {
                    return graph.getValue(object);
                }
                return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel, binding);
            }
            if (variable.parentResource != null) {
                for (Resource assertion : (Collection)graph.syncRequest((Read)new ObjectsWithType(variable.parentResource, L0.Asserts, L0.Assertion))) {
                    if (!variable.property.equals(graph.getSingleObject(assertion, L0.HasPredicate))) continue;
                    return graph.getRelatedValue2(assertion, L0.HasObject, (Object)context);
                }
            }
            return graph.getValue2(variable.getRepresents(graph), (Object)context, binding);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DatabaseException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    public static void standardSetValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier;
        if (context instanceof StandardGraphPropertyVariable) {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            if (variable.node != null) {
                try {
                    Binding binding = Layer0Utils.getDefaultBinding((ReadGraph)graph, variable);
                    Object oldValue = variable.node.manager.getValue(variable.node.node, binding);
                    variable.node.manager.setValue(variable.node.node, value, binding);
                    ExternalSetValue ext = new ExternalSetValue(variable.node.manager, variable.node.node, oldValue, value, binding);
                    ((UndoRedoSupport)graph.getService(UndoRedoSupport.class)).addExternalOperation(graph, (ExternalOperation)ext);
                    return;
                }
                catch (NodeManagerException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        }
        if ((modifier = (Function4<WriteGraph, Variable, Object, Object, String>)context.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier")) == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        try {
            modifier.apply((Object)graph, (Object)context, value, (Object)Bindings.getBinding(value.getClass()));
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void standardSetValue(final WriteGraph graph, Variable context, final Object value, final Binding binding) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier;
        if (context instanceof StandardGraphPropertyVariable) {
            final StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            if (variable.node != null) {
                try {
                    variable.node.manager.getRealm().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object oldValue = variable.node.manager.getValue(variable.node.node, binding);
                                variable.node.manager.setValue(variable.node.node, value, binding);
                                ExternalSetValue ext = new ExternalSetValue(variable.node.manager, variable.node.node, oldValue, value, binding);
                                ((UndoRedoSupport)graph.getService(UndoRedoSupport.class)).addExternalOperation(graph, (ExternalOperation)ext);
                            }
                            catch (NodeManagerException e) {
                                Logger.defaultLogError((Throwable)e);
                            }
                        }
                    });
                    return;
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        }
        if ((modifier = (Function4<WriteGraph, Variable, Object, Object, String>)context.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier")) == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        modifier.apply((Object)graph, (Object)context, value, (Object)binding);
    }

    public static Variable getStandardChildDomainPropertyVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        PropertyInfo graphProperty = All.getPossiblePropertyInfoFromContext(graph, variable, variable.resource, name);
        return All.getStandardChildDomainPropertyVariable(graph, context, graphProperty, name);
    }

    public static Variable getStandardChildDomainPropertyVariable(ReadGraph graph, Variable context, PropertyInfo graphProperty, String name) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Object propertyNode = All.getPossibleNodeProperty(graph, variable, name);
        if (graphProperty != null && graphProperty.builder != null) {
            return graphProperty.builder.buildProperty(graph, variable, All.build(variable.node, propertyNode), variable.resource, graphProperty.predicate);
        }
        if (propertyNode != null) {
            String propertyURI;
            Resource propertyResource = null;
            if (variable.node != null && (propertyURI = variable.node.manager.getPropertyURI(variable.node.node, propertyNode)) != null) {
                propertyResource = graph.getPossibleResource(propertyURI);
            }
            return new StandardGraphPropertyVariable(variable, All.build(variable.node, propertyNode), null, propertyResource);
        }
        return null;
    }

    public static Map<String, Variable> getStandardChildDomainPropertyVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Map<String, PropertyInfo> graphProperties = All.collectPropertyInfosFromContext(graph, variable, variable.resource);
        return All.getStandardChildDomainPropertyVariables(graph, context, null, graphProperties, map);
    }

    public static Map<String, Variable> getStandardChildDomainPropertyVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Map<String, PropertyInfo> graphProperties = All.collectPropertyInfosFromContext(graph, variable, variable.resource);
        return All.getStandardChildDomainPropertyVariables(graph, context, classification, graphProperties, map);
    }

    public static Map<String, Variable> getStandardChildDomainPropertyVariables(ReadGraph graph, Variable context, String classification, Map<String, PropertyInfo> graphProperties, Map<String, Variable> map) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Collection<Object> nodeProperties = All.getPossibleNodeProperties(graph, variable);
        if (graphProperties.isEmpty() && nodeProperties.isEmpty()) {
            return map;
        }
        HashSet<String> used = null;
        if (!nodeProperties.isEmpty()) {
            used = new HashSet<String>(nodeProperties.size());
        }
        if (map == null) {
            map = new HashMap<String, Variable>(graphProperties.size());
        }
        for (Object object : nodeProperties) {
            String propertyURI;
            NodeManager manager = variable.node.manager;
            String name = manager.getName(object);
            used.add(name);
            PropertyInfo graphProperty = graphProperties.get(name);
            if (graphProperty != null && graphProperty.builder != null) {
                if (classification != null && !graphProperty.hasClassification(classification)) continue;
                Variable var = graphProperty.builder.buildProperty(graph, variable, All.build(variable.node, object), variable.resource, graphProperty.predicate);
                map.put(name, var);
                continue;
            }
            Resource propertyResource = null;
            if (variable.node != null && (propertyURI = variable.node.manager.getPropertyURI(variable.node.node, object)) != null) {
                propertyResource = graph.getPossibleResource(propertyURI);
            }
            map.put(name, new StandardGraphPropertyVariable(variable, All.build(variable.node, object), null, propertyResource));
        }
        for (Map.Entry entry : graphProperties.entrySet()) {
            String name = (String)entry.getKey();
            if (used != null && used.contains(name)) continue;
            PropertyInfo info = (PropertyInfo)entry.getValue();
            if (classification != null && !info.hasClassification(classification) || info.builder == null) continue;
            map.put(name, info.builder.buildProperty(graph, variable, null, variable.resource, info.predicate));
        }
        return map;
    }

    public static Variable getStandardPropertyDomainPropertyVariableFromValue(ReadGraph graph, Variable context, String name) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            Variable result;
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            Resource literal = variable.getPossibleRepresents(graph);
            if (literal != null && (result = All.getPossiblePropertyFromContext(graph, variable, literal, name)) != null) {
                return result;
            }
            result = All.getPossibleSubliteralPropertyFromContext(graph, variable, name);
            if (result != null) {
                return result;
            }
            return All.getPossiblePropertyFromContext(graph, variable, variable.property, name);
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariable(graph, context, name);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Map<String, Variable> getStandardPropertyDomainPropertyVariablesFromValue(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            map = All.collectPropertiesFromContext(graph, variable, variable.property, map);
            if (variable.parentResource != null) {
                Resource literal = graph.getPossibleObject(variable.parentResource, variable.property);
                if (literal != null) {
                    map = All.collectPropertiesFromContext(graph, variable, literal, map);
                }
                map = All.collectSubliteralProperties(graph, variable, map);
            }
            return map;
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariables(graph, context, map);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Map<String, Variable> getStandardPropertyDomainPropertyVariablesFromValue(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            Resource literal;
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            map = All.collectPropertiesFromContext(graph, variable, variable.property, classification, map);
            if (variable.parentResource != null && (literal = graph.getPossibleObject(variable.parentResource, variable.property)) != null) {
                map = All.collectPropertiesFromContext(graph, variable, literal, classification, map);
            }
            return map;
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariables(graph, context, map);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Resource getPossibleGraphChild(ReadGraph graph, AbstractChildVariable variable, String name) throws DatabaseException {
        if (variable.getPossibleRepresents(graph) == null) {
            return null;
        }
        Map graphChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(variable.getPossibleRepresents(graph)));
        return (Resource)graphChildren.get(name);
    }

    public static Map<String, Resource> getPossibleGraphChildren(ReadGraph graph, StandardGraphChildVariable variable) throws DatabaseException {
        if (variable.resource == null) {
            return Collections.emptyMap();
        }
        return (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(variable.resource));
    }

    public static Object getPossibleNodeChild(ReadGraph graph, AbstractChildVariable variable, String name) throws DatabaseException {
        if (variable.node == null) {
            return null;
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, variable.node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.children.get(name);
    }

    public static Collection<Object> getPossibleNodeChildren(ReadGraph graph, AbstractChildVariable variable) throws DatabaseException {
        if (variable.node == null) {
            return Collections.emptyList();
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, variable.node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.children.values();
    }

    public static Object getPossibleNodeProperty(ReadGraph graph, AbstractChildVariable variable, String name) throws DatabaseException {
        if (variable.node == null) {
            return null;
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, variable.node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.properties.get(name);
    }

    public static VariableNode build(VariableNode parent, Object node) {
        if (node == null) {
            return null;
        }
        return new VariableNode(parent.manager, node);
    }

    public static Collection<Object> getPossibleNodeProperties(ReadGraph graph, AbstractChildVariable variable) throws DatabaseException {
        if (variable.node == null) {
            return Collections.emptyList();
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, variable.node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.properties.values();
    }

    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        AbstractChildVariable variable = (AbstractChildVariable)context;
        Resource graphChild = All.getPossibleGraphChild(graph, variable, name);
        return All.getStandardChildDomainChildVariable(graph, context, graphChild, name);
    }

    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, Resource graphChild, String name) throws DatabaseException {
        AbstractChildVariable variable = (AbstractChildVariable)context;
        Object childNode = All.getPossibleNodeChild(graph, variable, name);
        if (graphChild != null) {
            VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(graphChild, VariableBuilder.class);
            return variableBuilder.buildChild(graph, variable, All.build(variable.node, childNode), graphChild);
        }
        if (childNode != null) {
            return new StandardGraphChildVariable(variable, All.build(variable.node, childNode), null);
        }
        return null;
    }

    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Map<String, Resource> graphChildren = All.getPossibleGraphChildren(graph, variable);
        return All.getStandardChildDomainChildVariables(graph, context, graphChildren, map);
    }

    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String, Resource> graphChildren, Map<String, Variable> map) throws DatabaseException {
        AbstractChildVariable variable = (AbstractChildVariable)context;
        Collection<Object> nodeChildren = All.getPossibleNodeChildren(graph, variable);
        if (graphChildren.isEmpty() && nodeChildren.isEmpty()) {
            return map;
        }
        HashSet<String> used = new HashSet<String>(nodeChildren.size());
        if (map == null) {
            map = new HashMap<String, Variable>(graphChildren.size());
        }
        for (Object object : nodeChildren) {
            VariableBuilder builder;
            Variable var;
            NodeManager manager = variable.node.manager;
            String name = manager.getName(object);
            used.add(name);
            Resource graphChild = graphChildren.get(name);
            if (graphChild != null && (var = (builder = (VariableBuilder)graph.adapt(graphChild, VariableBuilder.class)).buildChild(graph, context, new VariableNode(manager, object), graphChild)) != null) {
                map.put(name, var);
                continue;
            }
            map.put(name, new StandardGraphChildVariable(variable, new VariableNode(manager, object), null));
        }
        for (Map.Entry entry : graphChildren.entrySet()) {
            Resource child;
            VariableBuilder builder;
            Variable var;
            String name = (String)entry.getKey();
            if (used.contains(name) || (var = (builder = (VariableBuilder)graph.adapt(child = (Resource)entry.getValue(), VariableBuilder.class)).buildChild(graph, context, null, child)) == null) continue;
            map.put(name, var);
        }
        return map;
    }

    protected static ChildReference getPossibleIndexReference(String name) {
        if (name.startsWith("i-")) {
            try {
                int index = Integer.parseInt(name.substring(2));
                return new IndexReference(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static ValueAccessor getPossiblePropertyValueAccessor(ReadGraph graph, StandardGraphPropertyVariable variable) throws DatabaseException {
        if (variable.property == null) {
            return null;
        }
        return (ValueAccessor)graph.syncRequest((Read)new PropertyValueAccessorRequest(variable.property), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    public static ValueAccessor getPossibleValueValueAccessor(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource value = variable.getPossibleRepresents(graph);
        if (value == null) {
            return null;
        }
        return (ValueAccessor)graph.syncRequest((Read)new PropertyValueAccessorRequest(value));
    }

    public static PropertyInfo getPossiblePropertyInfoFromContext(ReadGraph graph, Variable variable, Resource context, String name) throws DatabaseException {
        if (context == null) {
            return null;
        }
        Map predicates = (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
        return (PropertyInfo)predicates.get(name);
    }

    public static Variable getPossiblePropertyFromContext(ReadGraph graph, Variable variable, Resource context, String name) throws DatabaseException {
        PropertyInfo info = All.getPossiblePropertyInfoFromContext(graph, variable, context, name);
        if (info == null || info.builder == null) {
            return null;
        }
        return info.builder.buildProperty(graph, variable, null, context, info.predicate);
    }

    public static Variable getPossibleSubliteralPropertyFromContext(ReadGraph graph, StandardGraphPropertyVariable variable, String name) throws DatabaseException {
        Resource predicate = variable.property;
        if (predicate == null) {
            return null;
        }
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
        Pair<Resource, ChildReference> p = info.subliteralPredicates.get(name);
        if (p == null) {
            return null;
        }
        return new SubliteralPropertyVariable((Variable)variable, (Resource)p.first, (ChildReference)p.second);
    }

    public static Map<String, PropertyInfo> collectPropertyInfosFromContext(ReadGraph graph, Variable variable, Resource context) throws DatabaseException {
        if (context == null) {
            return Collections.emptyMap();
        }
        return graph.isImmutable(context) ? (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
    }

    public static Map<String, Variable> collectPropertiesFromContext(ReadGraph graph, Variable variable, Resource context, Map<String, Variable> map) throws DatabaseException {
        Map properties;
        Map map2 = properties = graph.isImmutable(context) ? (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
        if (properties.isEmpty()) {
            return map;
        }
        if (map == null) {
            map = new HashMap<String, Variable>(properties.size());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            PropertyInfo info = (PropertyInfo)entry.getValue();
            if (info.builder == null) continue;
            Variable v = info.builder.buildProperty(graph, variable, null, context, info.predicate);
            map.put(name, v);
        }
        return map;
    }

    public static Map<String, Variable> collectSubliteralProperties(ReadGraph graph, StandardGraphPropertyVariable variable, Map<String, Variable> map) throws DatabaseException {
        Resource predicate = variable.property;
        if (predicate == null) {
            return map;
        }
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
        if (info.subliteralPredicates.isEmpty()) {
            return map;
        }
        for (Map.Entry<String, Pair<Resource, ChildReference>> entry : info.subliteralPredicates.entrySet()) {
            String key = entry.getKey();
            Pair<Resource, ChildReference> p = entry.getValue();
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            map.put(key, new SubliteralPropertyVariable((Variable)variable, (Resource)p.first, (ChildReference)p.second));
        }
        return map;
    }

    public static Map<String, Variable> collectPropertiesFromContext(ReadGraph graph, Variable variable, Resource context, String classification, Map<String, Variable> map) throws DatabaseException {
        Map properties;
        Map map2 = properties = graph.isImmutable(context) ? (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
        if (properties.isEmpty()) {
            return map;
        }
        for (Map.Entry entry : properties.entrySet()) {
            PropertyInfo info = (PropertyInfo)entry.getValue();
            if (!info.classifications.contains(classification) || info.builder == null) continue;
            String name = (String)entry.getKey();
            Variable v = info.builder.buildProperty(graph, variable, null, context, info.predicate);
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            map.put(name, v);
        }
        return map;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String entityLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)context));
        }
        if (context instanceof Variable) {
            Variable parent = ((Variable)context).getParent(graph);
            Resource represents = parent.getRepresents(graph);
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)represents);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object listResources(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return ListUtils.toList((ReadGraph)graph, (Resource)resource);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [String]")
    public static List<String> standardClassifications(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        Resource predicate = context.getParent(graph).getPossiblePredicateResource(graph);
        if (predicate != null) {
            for (Resource type : graph.getTypes(predicate)) {
                String uri = graph.getPossibleURI(type);
                if (uri == null) continue;
                result.add(uri);
            }
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardValidValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.TRUE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> StringInputValidator")
    public static StringInputValidator standardValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return StringInputValidator.PASS;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardRequiredValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static Boolean standardDefaultValue(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable property = context.getParent(graph);
        if (property instanceof StandardGraphPropertyVariable) {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)property;
            if (variable.parentResource != null) {
                Statement stm = graph.getSingleStatement(variable.parentResource, variable.property);
                return stm.isAsserted(variable.parentResource);
            }
        }
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardReadOnlyValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object resourceAsValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return resource;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object functionApplication(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Functions.exec((RequestProcessor)graph, (Resource)resource, (Object[])new Object[]{graph, resource, context});
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object numberInputValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        class Validator
        extends FunctionImpl1<String, String> {
            private final Datatype datatype;

            public Validator(Datatype datatype) {
                this.datatype = datatype;
            }

            public String apply(String input) {
                if (this.datatype == null) {
                    return null;
                }
                try {
                    if (this.datatype instanceof NumberType) {
                        Number number = (Number)PrimitiveValueParser.parse(input, this.datatype);
                        NumberType nt = (NumberType)this.datatype;
                        Range r = nt.getRange();
                        if (r != null && !r.contains(number)) {
                            return "Value is out of valid range";
                        }
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Not a valid floating-point number";
                }
                catch (IllegalArgumentException e) {
                    return "Not a valid floating-point number";
                }
            }
        }
        if (context instanceof Variable) {
            Variable variable = (Variable)context;
            Variable property = variable.getParent(graph);
            Datatype datatype = (Datatype)property.getPossiblePropertyValue(graph, "DATATYPE");
            return new Validator(datatype);
        }
        if (context instanceof Resource) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource literal = (Resource)context;
            Datatype datatype = (Datatype)graph.getRelatedValue(literal, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            return new Validator(datatype);
        }
        return new Validator(null);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object booleanInputValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return new FunctionImpl1<String, String>(){

            public String apply(String input) {
                String lower = input.toLowerCase();
                if ("true".equals(lower) || "false".equals(lower)) {
                    return null;
                }
                return "Not a valid boolean: " + input;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource hasStandardResource(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable parent = context.getParent(graph);
        if (parent instanceof StandardGraphChildVariable) {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)parent;
            return variable.resource;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object valueWithoutBinding(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(variable.getRepresents(graph)))).booleanValue()) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel);
        }
        if (variable.parentResource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + variable.getPossibleURI(graph) + ").");
        }
        try {
            return graph.getRelatedValue2(variable.parentResource, variable.property, (Object)variable);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
    }

    @SCLValue(type="ReadGraph -> Variable -> Binding -> a")
    public static Object valueWithBinding(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(variable.getRepresents(graph)))).booleanValue()) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel, binding);
        }
        if (variable.parentResource == null) {
            throw new VariableException("Variable is not represented by any resource (URI=" + variable.getPossibleURI(graph) + ").");
        }
        try {
            return graph.getRelatedValue2(variable.parentResource, variable.property, (Object)variable);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
    }

    @SCLValue(type="WriteGraph -> Variable -> a -> Binding -> b")
    public static Object valueSetterWithBinding(WriteGraph graph, Variable variable, Object value, Binding binding) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier = (Function4<WriteGraph, Variable, Object, Object, String>)variable.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier");
        if (modifier == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        modifier.apply((Object)graph, (Object)variable, value, (Object)binding);
        return null;
    }

    private static List<Issue> reportInconsistency(ReadGraph graph, Resource subject, String description, List<Issue> issues) throws DatabaseException {
        if (issues == null) {
            issues = new ArrayList<Issue>();
        }
        System.err.println("Change set validation reports the following issue: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)subject, (boolean)true) + ": " + description);
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        issues.add((Issue)new L0Issue(description, IR.Issue, subject));
        return issues;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> relationValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Issue> issues = null;
        for (Statement stm : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
            Collection range;
            StringBuilder sb;
            Collection domain;
            Resource predicate = stm.getPredicate();
            Resource object = stm.getObject();
            if (!All.isRelation(graph, L0, predicate)) {
                issues = All.reportInconsistency(graph, resource, "The predicate of a statement must be a relation: " + NameUtils.toString((ReadGraph)graph, (Statement)stm), issues);
            }
            if (graph.isInstanceOf(predicate, L0.FunctionalRelation) && graph.getObjects(resource, predicate).size() > 1) {
                issues = All.reportInconsistency(graph, resource, "Relation " + NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate) + " is functional.", issues);
            }
            if (!All.isInstanceOfAny(graph, resource, domain = graph.getObjects(predicate, L0.HasDomain), true)) {
                sb = new StringBuilder().append("The domain of ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate)).append(" relation is ");
                All.orString(graph, sb, domain).append(".");
                issues = All.reportInconsistency(graph, resource, sb.toString(), issues);
            }
            if (All.isInstanceOfAny(graph, object, range = graph.getObjects(predicate, L0.HasRange), true)) continue;
            sb = new StringBuilder().append("The range of ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate)).append(" relation is ");
            All.orString(graph, sb, range).append(".");
            issues = All.reportInconsistency(graph, resource, sb.toString(), issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> propertyValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement stm : graph.getStatements(resource, L0.HasProperty)) {
            Resource predicate;
            Resource subject = stm.getSubject();
            String error = L0Validations.checkValueType((ReadGraph)graph, (Resource)subject, (Resource)(predicate = stm.getPredicate()));
            if (error == null) continue;
            issues = All.reportInconsistency(graph, subject, error, issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> valueValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.hasValue(resource)) {
            if (!graph.isInstanceOf(resource, L0.Literal)) {
                issues = All.reportInconsistency(graph, resource, "Resource has a value but it is not a literal.", issues);
            }
        } else if (graph.isInstanceOf(resource, L0.Literal)) {
            issues = All.reportInconsistency(graph, resource, "Resource is a literal but it does not have a value.", issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> uriValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        String name;
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.hasStatement(resource, L0.PartOf) && (name = (String)graph.getPossibleRelatedValue(resource, L0.HasName)) == null) {
            issues = All.reportInconsistency(graph, resource, "Resource has PartOf but has no valid HasName.", issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    private static Resource getPossibleNearestClusterSet(ReadGraph graph, Resource base, Resource resource) throws DatabaseException {
        ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (cs.isClusterSet(resource) && !base.equals(resource)) {
            return resource;
        }
        Resource nearest = CommonDBUtils.getNearestOwner((ReadGraph)graph, Collections.singletonList(resource));
        if (nearest == null) {
            return null;
        }
        return All.getPossibleNearestClusterSet(graph, base, nearest);
    }

    private static boolean quirks(ReadGraph graph, Resource resource) throws DatabaseException {
        if (!resource.isPersistent()) {
            return true;
        }
        if (graph.isImmutable(resource)) {
            return true;
        }
        return resource.getResourceId() < 8192L;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> clusterValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        return Collections.emptyList();
    }

    private static boolean isInstanceOfAny(ReadGraph graph, Resource r, Collection<Resource> types, boolean ifEmpty) throws DatabaseException {
        if (types.isEmpty()) {
            return ifEmpty;
        }
        for (Resource type : types) {
            if (!graph.isInstanceOf(r, type)) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder orString(ReadGraph graph, StringBuilder sb, Collection<Resource> rs) throws DatabaseException {
        sb.append("(");
        boolean first = true;
        for (Resource r : rs) {
            if (!first) {
                sb.append(" | ");
            }
            first = false;
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
        }
        sb.append(")");
        return sb;
    }

    public static boolean isRelation(ReadGraph g, Layer0 l0, Resource relation) throws DatabaseException {
        return g.hasStatement(relation, l0.SubrelationOf) || relation == l0.IsWeaklyRelatedTo;
    }

    public static boolean isType(ReadGraph g, Layer0 l0, Resource type) throws DatabaseException {
        return g.hasStatement(type, l0.Inherits) || type == l0.Entity;
    }

    static class L0Issue
    extends StandardIssue {
        private final String description;

        public L0Issue(String description, Resource type, Resource ... contexts) {
            super(type, contexts);
            this.description = description;
        }

        public Resource write(WriteGraph graph, Resource source) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
            Resource issue = super.write(graph, source);
            graph.claim(issue, IR.Issue_HasSeverity, IR.Severity_Fatal);
            graph.addLiteral(issue, L0.HasDescription, L0.HasDescription_Inverse, (Object)this.description, (Binding)Bindings.STRING);
            return issue;
        }
    }
}

