/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.changeset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.changeset.ChangeVisitor;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.ManagementSupport;

public class MetadataUtils {
    public static final boolean DEBUG = false;

    public static Map<Long, Map<String, byte[]>> getMetadatas(ReadGraph graph, ManagementSupport support, long fromRevisionId, long toRevisionId) throws DatabaseException {
        WriteGraph writeGraph;
        TreeMap metadata;
        TreeMap<Long, Map<String, byte[]>> result = new TreeMap<Long, Map<String, byte[]>>();
        Collection csis = support.getChangeSetIdentifiers(fromRevisionId, toRevisionId);
        for (ChangeSetIdentifier csi : csis) {
            if (csi.getId() < fromRevisionId) {
                System.err.println("ManagementSupport.getChangeSetIdentifiers returned identifiers outside of the requested range.");
                continue;
            }
            Map metadata2 = csi.getMetadata();
            if (metadata2 == null) continue;
            result.put(csi.getId(), metadata2);
        }
        long toBeRevision = support.getHeadRevisionId() + 1L;
        if (toBeRevision >= fromRevisionId && toBeRevision <= toRevisionId && graph instanceof WriteGraph && (metadata = (writeGraph = (WriteGraph)graph).getMetadata()) != null) {
            result.put(toBeRevision, metadata);
        }
        return result;
    }

    public static Map<Resource, Collection<DependencyChanges.Change>> getDependencyChangesFrom(ReadGraph graph, long revisionId) throws DatabaseException {
        ManagementSupport support = (ManagementSupport)graph.getService(ManagementSupport.class);
        HashMap<Resource, Collection<DependencyChanges.Change>> result = new HashMap<Resource, Collection<DependencyChanges.Change>>();
        Map<Long, Map<String, byte[]>> metadatas = MetadataUtils.getMetadatas(graph, support, revisionId, Long.MAX_VALUE);
        for (Map.Entry<Long, Map<String, byte[]>> e : metadatas.entrySet()) {
            DependencyChanges changes;
            byte[] changesData;
            long csid = e.getKey();
            Map<String, byte[]> metadata = e.getValue();
            if (metadata == null || (changesData = metadata.get(DependencyChanges.class.getName())) == null || changesData.length <= 0 || (changes = DependencyChanges.deserialise(graph.getSession(), changesData)) == null) continue;
            for (Map.Entry<Resource, DependencyChanges.Change[]> entry : changes.modelChanges.entrySet()) {
                ArrayList<DependencyChanges.Change> list = (ArrayList<DependencyChanges.Change>)result.get(entry.getKey());
                if (list == null) {
                    list = new ArrayList<DependencyChanges.Change>();
                    result.put(entry.getKey(), list);
                }
                DependencyChanges.Change[] changeArray = entry.getValue();
                int n = changeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencyChanges.Change c = changeArray[n2];
                    list.add(c);
                    ++n2;
                }
            }
        }
        return result;
    }

    public static void visitDependencyChangesFrom2(ReadGraph graph, Resource model, DependencyChanges.Change[] changes, ChangeVisitor changeVisitor) throws DatabaseException {
        DependencyChanges.Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            DependencyChanges.Change change = changeArray[n2];
            changeVisitor.visit(graph, change, false);
            ++n2;
        }
    }

    public static void visitDependencyChangesFrom(ReadGraph graph, Resource model, long fromRevision, ChangeVisitor visitor) throws DatabaseException {
        MetadataUtils.visitDependencyChangesBetween(graph, model, fromRevision, Long.MAX_VALUE, visitor, false);
    }

    private static void visitDependencyChangesBetween(ReadGraph graph, Resource model, long fromRevision, long toRevision, ChangeVisitor visitor, boolean inverted) throws DatabaseException {
        ManagementSupport support = (ManagementSupport)graph.getService(ManagementSupport.class);
        Map<Long, Map<String, byte[]>> metadatas = MetadataUtils.getMetadatas(graph, support, fromRevision, toRevision);
        for (Map.Entry<Long, Map<String, byte[]>> e : metadatas.entrySet()) {
            byte[] undoMetadata;
            DependencyChanges changes;
            Map<String, byte[]> metadata = e.getValue();
            byte[] changesData = metadata.get(DependencyChanges.class.getName());
            if (changesData != null && changesData.length != 0 && (changes = DependencyChanges.deserialise(graph.getSession(), changesData)) != null) {
                for (Map.Entry<Resource, DependencyChanges.Change[]> entry : changes.modelChanges.entrySet()) {
                    if (!((Boolean)graph.syncRequest((Read)new IsLinkedTo(model, entry.getKey()), (Listener)TransientCacheListener.instance())).booleanValue()) continue;
                    DependencyChanges.Change[] changeArray = entry.getValue();
                    int n = changeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DependencyChanges.Change change = changeArray[n2];
                        visitor.visit(graph, change, inverted);
                        ++n2;
                    }
                }
            }
            if ((undoMetadata = metadata.get(UndoMetadata.class.getName())) == null || undoMetadata.length == 0) continue;
            UndoMetadata undo = UndoMetadata.deserialise((Session)graph.getSession(), (byte[])undoMetadata);
            MetadataUtils.visitDependencyChangesBetween(graph, model, undo.getBeginCSId(), undo.getEndCSId(), visitor, undo.isRedo() ? inverted : !inverted);
        }
    }
}

