/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.AbstractStringModifier;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;

public final class StringModifierImpl
extends AbstractStringModifier {
    final Resource resource;
    final IUnitConverter converter;
    PrimitiveValueParser.IValidator validator;

    public StringModifierImpl(ReadGraph g, Resource resource) throws DatabaseException {
        this(g, resource, null);
    }

    public StringModifierImpl(ReadGraph g, Resource resource, IUnitConverter converter) throws DatabaseException {
        super(resource);
        this.resource = resource;
        this.validator = null;
        this.converter = converter;
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        this.validator = PrimitiveValueParser.NON_MODIFIABLE_VALIDATOR;
        Datatype type = (Datatype)g.getPossibleRelatedValue(resource, l0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
        if (type == null) {
            return;
        }
        if (type instanceof DoubleType) {
            this.validator = new PrimitiveValueParser.DoubleValidator();
        } else if (type instanceof StringType) {
            this.validator = null;
        } else if (type instanceof ByteType) {
            this.validator = new PrimitiveValueParser.ByteArrayValidator();
        } else if (type instanceof BooleanType) {
            this.validator = new PrimitiveValueParser.BooleanValidator();
        } else if (type instanceof IntegerType) {
            this.validator = new PrimitiveValueParser.IntegerValidator();
        } else if (type instanceof LongType) {
            this.validator = new PrimitiveValueParser.LongValidator();
        } else if (type instanceof FloatType) {
            this.validator = new PrimitiveValueParser.FloatValidator();
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if ((type = arrayType.componentType()) instanceof DoubleType) {
                this.validator = new PrimitiveValueParser.DoubleArrayValidator();
            } else if (type instanceof StringType) {
                this.validator = null;
            } else if (type instanceof ByteType) {
                this.validator = new PrimitiveValueParser.ByteArrayValidator();
            } else if (type instanceof BooleanType) {
                this.validator = new PrimitiveValueParser.BooleanArrayValidator();
            } else if (type instanceof IntegerType) {
                this.validator = new PrimitiveValueParser.IntegerArrayValidator();
            } else if (type instanceof LongType) {
                this.validator = new PrimitiveValueParser.LongArrayValidator();
            } else if (type instanceof FloatType) {
                this.validator = new PrimitiveValueParser.FloatArrayValidator();
            }
        }
    }

    @Override
    public String isValid(String value) {
        return this.validator == null ? null : this.validator.isValid(value);
    }

    @Override
    public final void modify(WriteGraph graph, final String value) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getGraph((ReadGraph)graph, this.resource);
        if (vg != null) {
            graph.syncRequest((Write)new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    StringModifierImpl.this.modify0(graph, value);
                }
            });
        } else {
            this.modify0(graph, value);
        }
    }

    protected void modify0(WriteGraph graph, String value) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        try {
            Datatype type = graph.getDataType(this.resource);
            if (type == null) {
                return;
            }
            if (type instanceof StringType) {
                graph.claimValue(this.resource, (Object)value, (Binding)Bindings.STRING);
                return;
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                type = arrayType.componentType();
                value = "[" + value + "]";
            }
            Datatype dt = (Datatype)graph.getPossibleRelatedValue(this.resource, l0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            Binding binding = Bindings.getBinding((Datatype)dt);
            Object parsedValue = binding.parseValue(value, new DataValueRepository());
            graph.claimValue(this.resource, parsedValue, binding);
        }
        catch (IllegalArgumentException type) {
        }
        catch (DataTypeSyntaxError e) {
            throw new ValidationException("Could not modify resource '" + this.resource.getResourceId() + "' with value " + value, (Throwable)e);
        }
        catch (BindingException e) {
            throw new ValidationException("Could not modify resource '" + this.resource.getResourceId() + "' with value " + value, (Throwable)e);
        }
    }
}

