/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;

public class EntityRemover
extends AbstractRemover {
    public EntityRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        EntityRemover.remove(graph, this.resource, true);
    }

    public static void remove(WriteGraph graph, Resource resource) throws DatabaseException {
        EntityRemover.remove(graph, resource, true);
    }

    public static void remove(WriteGraph graph, Resource resource, boolean useAdapters) throws DatabaseException {
        if (graph.isImmutable(resource)) {
            return;
        }
        if (Layer0Utils.isContainerPublished((ReadGraph)graph, resource)) {
            throw new CannotRemoveException("Items in published libraries cannot be removed. Please create a new version to perform modifications.");
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Collection stms = graph.getStatements(resource, l0.IsWeaklyRelatedTo);
        ArrayList<Resource> composedOf = null;
        for (Statement stm : stms) {
            Resource partOf;
            Resource subject = stm.getSubject();
            if (!resource.equals(stm.getSubject())) continue;
            Resource predicate = stm.getPredicate();
            Resource object = stm.getObject();
            Resource inverse = graph.getPossibleInverse(predicate);
            graph.deny(subject, predicate, inverse, object);
            graph.denyValue(subject);
            if (resource.equals(object) || !graph.isSubrelationOf(predicate, l0.IsComposedOf) || graph.isSubrelationOf(predicate, l0.HasProperty) && (partOf = graph.getPossibleObject(object, l0.PartOf)) != null && !partOf.equals(resource)) continue;
            if (composedOf == null) {
                composedOf = new ArrayList<Resource>(stms.size());
            }
            composedOf.add(object);
        }
        if (composedOf == null) {
            return;
        }
        for (Resource object : composedOf) {
            Remover remover = null;
            if (useAdapters) {
                remover = (Remover)graph.getPossibleAdapter(object, Remover.class);
            }
            if (remover != null) {
                remover.remove(graph);
                continue;
            }
            EntityRemover.remove(graph, object, useAdapters);
        }
    }
}

