/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

public class EntityInstances
implements Instances {
    private static final boolean TRACE_QUERIES = false;
    private final Resource type;

    public EntityInstances(Resource type) {
        this.type = type;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index) throws DatabaseException {
        return this.find(graph, index, "");
    }

    private Collection<Resource> findRec(ReadGraph graph, Resource index, String filter, Set<Resource> visited) throws DatabaseException {
        if (!visited.add(index)) {
            return Collections.emptyList();
        }
        ArrayList<Resource> indexResult = (ArrayList<Resource>)graph.syncRequest((Read)new QueryIndex(index, this.type, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        ArrayList<Resource> result = indexResult;
        for (Resource dep : linkedRoots) {
            Collection<Resource> linkedIndexResults = this.findRec(graph, dep, filter, visited);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = new ArrayList<Resource>(indexResult.size() + linkedIndexResults.size());
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        return result;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        return this.findRec(graph, index, filter, new HashSet<Resource>());
    }

    @Override
    public Collection<Resource> findByName(ReadGraph graph, Resource model, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (Resource match : this.find(graph, model, name)) {
            if (!name.equals(graph.getPossibleRelatedValue(match, L0.HasName, (Binding)Bindings.STRING))) continue;
            results.add(match);
        }
        return results;
    }

    static class QueryIndex
    extends TernaryRead<Resource, Resource, String, Collection<Resource>> {
        public QueryIndex(Resource index, Resource type, String filter) {
            super((Object)index, (Object)type, (Object)filter);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            String filter;
            Collection results;
            Resource type = (Resource)this.parameter2;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            String typeName = (String)graph.getRelatedValue(type, L0.HasName);
            if (typeName.isEmpty()) {
                return Collections.emptyList();
            }
            Function dependencies = (Function)graph.syncRequest((Read)new Adapter(L0X.Dependencies, Function.class), (Listener)TransientCacheListener.instance());
            StringBuilder filtersb = new StringBuilder();
            filtersb.append("Types:*").append(IndexQueries.escape(typeName, true));
            if (((String)this.parameter3).length() > 0) {
                filtersb.append(" AND ").append((String)this.parameter3);
            }
            if ((results = (Collection)dependencies.apply((Object)graph, this.parameter, (Object)(filter = filtersb.toString()))) == null || results.isEmpty()) {
                return Collections.emptyList();
            }
            TreeSet<Resource> resultSet = new TreeSet<Resource>();
            for (Map entry : results) {
                Resource res = (Resource)entry.get("Resource");
                if (res == null || resultSet.contains(res) || !graph.isInstanceOf(res, type)) continue;
                resultSet.add(res);
            }
            return new ArrayList<Resource>(resultSet);
        }
    }
}

