/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.RealizationType;
import org.simantics.db.common.request.RealizedChildSetRequest;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.layer0.adapter.Realization;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;

public class DefaultRealization
implements Realization {
    protected final Resource resource;

    public DefaultRealization(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("null resource");
        }
        this.resource = resource;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRealization other = (DefaultRealization)obj;
        return this.resource.equals(other.resource);
    }

    @Override
    public void forChildren(AsyncReadGraph graph, AsyncProcedure<Collection<Resource>> procedure) {
        graph.asyncRequest((AsyncRead)new RealizedChildSetRequest(this.resource), procedure);
    }

    @Override
    public void forName(AsyncReadGraph graph, Resource resource, AsyncProcedure<String> procedure) {
        graph.forPossibleRelatedValue(resource, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING, procedure);
    }

    @Override
    public void forType(AsyncReadGraph graph, Resource resource, AsyncProcedure<Resource> procedure) {
        graph.asyncRequest((AsyncRead)new RealizationType(resource, ((Layer0X)graph.getService(Layer0X.class)).Realization), procedure);
    }

    @Override
    public void forValues(AsyncReadGraph graph, AsyncProcedure<Collection<NamedResource>> procedure) {
        graph.asyncRequest((AsyncRead)new AsyncRead<Collection<NamedResource>>(){

            public int threadHash() {
                return this.hashCode();
            }

            public int getFlags() {
                return 0;
            }

            public void perform(AsyncReadGraph graph, final AsyncProcedure<Collection<NamedResource>> procedure) {
                final AtomicInteger ready = new AtomicInteger(1);
                final ConcurrentSkipListSet result = new ConcurrentSkipListSet();
                final Layer0 l0 = (Layer0)graph.getService(Layer0.class);
                graph.forEachPredicate(DefaultRealization.this.resource, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

                    public void finished(AsyncReadGraph graph) {
                        if (ready.decrementAndGet() == 0) {
                            procedure.execute(graph, (Object)result);
                        }
                    }

                    public void execute(AsyncReadGraph graph, final Resource pred) {
                        ready.incrementAndGet();
                        graph.forIsSubrelationOf(pred, l0.HasProperty, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            public void execute(AsyncReadGraph graph, Boolean accept) {
                                if (accept.booleanValue()) {
                                    ready.incrementAndGet();
                                    graph.forPossibleRelatedValue(pred, l0.HasLabel, (Binding)Bindings.STRING, (AsyncProcedure)new AsyncProcedure<String>(){

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            throwable.printStackTrace();
                                        }

                                        public void execute(AsyncReadGraph graph, String name) {
                                            if (name == null) {
                                                ready.incrementAndGet();
                                                graph.forPossibleRelatedValue(pred, l0.HasName, (Binding)Bindings.STRING, (AsyncProcedure)new AsyncProcedure<String>(){

                                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                        throwable.printStackTrace();
                                                    }

                                                    public void execute(AsyncReadGraph graph, String name) {
                                                        if (name != null) {
                                                            result.add(new NamedResource(URIStringUtils.escape((String)name), pred));
                                                        }
                                                        if (ready.decrementAndGet() == 0) {
                                                            procedure.execute(graph, (Object)result);
                                                        }
                                                    }
                                                });
                                                if (ready.decrementAndGet() == 0) {
                                                    procedure.execute(graph, (Object)result);
                                                }
                                            } else {
                                                result.add(new NamedResource(URIStringUtils.escape((String)name), pred));
                                                if (ready.decrementAndGet() == 0) {
                                                    procedure.execute(graph, (Object)result);
                                                }
                                            }
                                        }
                                    });
                                    if (ready.decrementAndGet() == 0) {
                                        procedure.execute(graph, (Object)result);
                                    }
                                } else if (ready.decrementAndGet() == 0) {
                                    procedure.execute(graph, (Object)result);
                                }
                            }
                        });
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            }
        }, procedure);
    }

    @Override
    public void forValue(AsyncReadGraph graph, Resource predicate, final AsyncProcedure<Pair<Object, Binding>> procedure) {
        graph.forPossibleRelatedValue(this.resource, predicate, (AsyncListener)new AsyncListener<Object>(){

            public void execute(AsyncReadGraph graph, Object result) {
                if (result instanceof String) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.STRING));
                } else if (result instanceof String[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.STRING_ARRAY));
                } else if (result instanceof Double) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.DOUBLE));
                } else if (result instanceof double[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.DOUBLE_ARRAY));
                } else if (result instanceof Float) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.FLOAT));
                } else if (result instanceof float[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.FLOAT_ARRAY));
                } else if (result instanceof Integer) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.INTEGER));
                } else if (result instanceof int[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.INT_ARRAY));
                } else if (result instanceof Long) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.LONG));
                } else if (result instanceof long[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.LONG_ARRAY));
                } else if (result instanceof Boolean) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.BOOLEAN));
                } else if (result instanceof boolean[]) {
                    procedure.execute(graph, (Object)new Pair(result, (Object)Bindings.BOOLEAN_ARRAY));
                } else if (result == null) {
                    procedure.execute(graph, null);
                } else {
                    procedure.exception(graph, (Throwable)new IllegalArgumentException("Result was " + result));
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
                procedure.exception(graph, throwable);
            }

            public boolean isDisposed() {
                if (procedure instanceof Listener) {
                    return ((Listener)procedure).isDisposed();
                }
                return false;
            }
        });
    }
}

