/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.FreshEscapedName;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;

public class DefaultPasteImportAdvisor
implements IImportAdvisor2 {
    protected Resource root;
    protected Resource library;
    protected Resource model;
    protected String singleType = null;
    protected Map<String, String> nameMappings = new HashMap<String, String>();
    protected final Map<String, Object> context;
    protected Map<String, Resource> roots = new HashMap<String, Resource>();

    public DefaultPasteImportAdvisor(ReadGraph graph, Resource library) throws DatabaseException {
        this(library, (Resource)graph.syncRequest((Read)new PossibleIndexRoot(library)), Collections.emptyMap());
    }

    public DefaultPasteImportAdvisor(Resource library) {
        this(library, library, Collections.emptyMap());
    }

    public DefaultPasteImportAdvisor(Resource library, Map<String, Object> context) {
        this(library, library, context);
    }

    public DefaultPasteImportAdvisor(Resource library, Resource model, Map<String, Object> context) {
        this.library = library;
        this.model = model;
        this.context = context;
    }

    public Resource getTarget() {
        return this.library;
    }

    public Collection<Resource> getRoots() {
        return this.roots.values();
    }

    public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
    }

    public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
        if ("%model".equals(root.name)) {
            return this.model;
        }
        this.analyzeType(graph, root);
        String type = root.type;
        if (this.singleType != null) {
            if (!type.equals(this.singleType)) {
                throw new DatabaseException("Paste of a set of different types of objects is not supported.");
            }
        } else {
            this.singleType = type;
        }
        if (this.library != null) {
            String newName = this.newName(graph, this.library, root.name);
            this.nameMappings.put(root.name, newName);
        }
        return null;
    }

    public String newName(ReadGraph graph, Resource library, String name) throws DatabaseException {
        String renamed;
        Map renameMap = (Map)this.context.get("renameMap");
        if (renameMap != null && (renamed = (String)renameMap.get(name)) != null) {
            return renamed;
        }
        return (String)graph.syncRequest((Read)new FreshEscapedName(library, Layer0.getInstance((ReadGraph)graph).ConsistsOf, name));
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        return this.createRoot(graph, root, null);
    }

    public String getName(Root root) {
        String name = root.name;
        String newName = this.nameMappings.get(name);
        if (newName != null) {
            name = newName;
        }
        return name;
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
        Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        if (resource == null) {
            resource = graph.newResource();
        }
        this.root = resource;
        if (this.library != null) {
            graph.claim(this.library, l0.ConsistsOf, l0.PartOf, this.root);
        }
        String newName = this.getName(root);
        graph.addLiteral(this.root, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
        this.roots.put(root.name, resource);
        return this.root;
    }

    public Resource getRoot() {
        return this.root;
    }

    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
    }

    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
    }

    public boolean allowImmutableModifications() {
        return false;
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, String name) throws DatabaseException {
        return process.createChild(graph, parent, null, name);
    }

    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child, String name) throws DatabaseException {
        return process.createChild(graph, parent, child, name);
    }
}

