/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.adapter.impl.ImportAdvisorFactory;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.layer0.Layer0;

public class DefaultPasteHandler
extends PasteHandlerAdapter {
    protected Resource resource;

    public DefaultPasteHandler(Resource resource) {
        this.resource = resource;
    }

    public static void defaultExecute(TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        TransferableGraphs.importGraph1((Session)Simantics.getSession(), (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public static void defaultExecute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public void execute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        DefaultPasteHandler.defaultExecute(graph, tg, resource, advisor);
    }

    public void onPasteBegin(WriteGraph graph) throws DatabaseException {
    }

    public void onPaste(WriteGraph graph, IImportAdvisor2 advisor, Set<SimanticsClipboard.Representation> representations) throws DatabaseException {
    }

    public void onPasteEnd(WriteGraph graph) throws DatabaseException {
    }

    public IImportAdvisor2 getAdvisor(ReadGraph graph, TransferableGraph1 tg, Resource target, PasteEventHandler handler) throws DatabaseException {
        Collection roots = TransferableGraphUtils.getRoots((TransferableGraph1)tg);
        if (roots.size() == 1) {
            Root root = (Root)((Identity)roots.iterator().next()).definition;
            Resource type = graph.getPossibleResource(root.type);
            ImportAdvisorFactory factory = (ImportAdvisorFactory)graph.getPossibleAdapter(type, ImportAdvisorFactory.class);
            if (factory != null) {
                if (handler != null) {
                    return handler.createAdvisor(graph, factory, target);
                }
                return factory.create(graph, target, Collections.<String, Object>emptyMap());
            }
        }
        return new DefaultPasteImportAdvisor(target);
    }

    public void pasteObject(WriteGraph graph, Set<SimanticsClipboard.Representation> object, PasteEventHandler handler) throws DatabaseException {
        TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
        if (tg != null) {
            IImportAdvisor2 advisor = this.getAdvisor((ReadGraph)graph, tg, this.resource, handler);
            this.execute(graph, tg, this.resource, (IImportAdvisor)advisor);
            if (handler != null) {
                for (Resource r : advisor.getRoots()) {
                    handler.postProcess(graph, r);
                }
            }
            this.onPaste(graph, advisor, object);
        }
    }

    @Override
    public void pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        this.onPasteBegin(graph);
        HashSet cuts = new HashSet();
        for (Set<SimanticsClipboard.Representation> object : clipboard.getContents()) {
            Collection cut = (Collection)ClipboardUtils.accept(object, SimanticsKeys.KEY_CUT_RESOURCES);
            TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
            if (tg != null) {
                this.pasteObject(graph, object, handler);
                if (cut == null) continue;
                cuts.addAll(cut);
                continue;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource r : cut) {
                graph.deny(r, L0.PartOf);
                graph.claim(this.resource, L0.ConsistsOf, L0.PartOf, r);
            }
        }
        this.onPasteEnd(graph);
        if (!cuts.isEmpty()) {
            for (Resource cut : cuts) {
                RemoverUtil.remove(graph, cut);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter) {
            return this.resource;
        }
        return null;
    }
}

