/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.CopyHandler2;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.TGRepresentation;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.operation.Layer0X;

public class DefaultCopyHandler
implements CopyHandler,
CopyHandler2 {
    protected Collection<Resource> resources;

    public DefaultCopyHandler(Resource resource) {
        this.resources = Collections.singletonList(resource);
    }

    public DefaultCopyHandler(Collection<Resource> resources) {
        this.resources = resources;
    }

    public Resource getResource() {
        if (this.resources.size() != 1) {
            throw new IllegalStateException();
        }
        return this.resources.iterator().next();
    }

    protected CopyHandler2 create(Collection<Resource> resources) {
        return new DefaultCopyHandler(resources);
    }

    @Override
    public CopyHandler2 combine(CopyHandler2 other_) {
        if (other_ instanceof DefaultCopyHandler) {
            DefaultCopyHandler other = (DefaultCopyHandler)other_;
            ArrayList<Resource> allResources = new ArrayList<Resource>();
            allResources.addAll(this.resources);
            allResources.addAll(other.resources);
            return this.create(allResources);
        }
        return null;
    }

    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        return new TransferableGraphConfiguration2(graph, this.resources, true, false);
    }

    protected TransferableGraph1 compute(ReadGraph graph, TransferableGraphConfiguration2 conf) throws DatabaseException {
        TransferableGraphSource source = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
        return TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)source);
    }

    protected SimanticsClipboard.Representation createTransferableGraph(ReadGraph graph, Collection<Resource> resources, boolean cut) throws DatabaseException {
        final TransferableGraphConfiguration2 conf = this.createConfiguration(graph, cut);
        if (conf == null) {
            return null;
        }
        return new TGRepresentation(resources.toArray(new Resource[resources.size()])){

            @Override
            public TransferableGraph1 compute(ReadGraph graph) throws DatabaseException {
                return DefaultCopyHandler.this.compute(graph, conf);
            }
        };
    }

    protected void fillTG(ReadGraph graph, HashSet<SimanticsClipboard.Representation> items, boolean cut) {
        try {
            SimanticsClipboard.Representation tgRepresentation = this.createTransferableGraph(graph, this.resources, cut);
            if (tgRepresentation != null) {
                items.add(tgRepresentation);
            }
            if (this.resources.size() == 1) {
                Collection representations = (Collection)graph.syncRequest((Read)new ResourceRead<Collection<SimanticsClipboard.Representation>>(this.resources.iterator().next()){

                    public Collection<SimanticsClipboard.Representation> perform(ReadGraph graph) throws DatabaseException {
                        ArrayList<SimanticsClipboard.Representation> result = new ArrayList<SimanticsClipboard.Representation>();
                        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                        for (Resource adapter : graph.getObjects(this.resource, L0X.HasRepresentation)) {
                            result.add((SimanticsClipboard.Representation)graph.adapt(adapter, SimanticsClipboard.Representation.class));
                        }
                        return result;
                    }
                });
                for (SimanticsClipboard.Representation r : representations) {
                    items.add(r);
                }
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    protected void fillCopyResource(ReadGraph graph, HashSet<SimanticsClipboard.Representation> items) {
        items.add(ClipboardUtils.createCopyResources(this.resources));
    }

    protected void fillCutResource(ReadGraph graph, HashSet<SimanticsClipboard.Representation> items) {
        items.add(ClipboardUtils.createCutResources(this.resources));
    }

    @Override
    public void copyToClipboard(ReadGraph graph, SimanticsClipboardBuilder clipboard) throws DatabaseException {
        HashSet<SimanticsClipboard.Representation> items = new HashSet<SimanticsClipboard.Representation>();
        this.fillTG(graph, items, false);
        this.fillCopyResource(graph, items);
        clipboard.addContent(items);
    }

    @Override
    public void cutToClipboard(ReadGraph graph, SimanticsClipboardBuilder clipboard) throws DatabaseException {
        HashSet<SimanticsClipboard.Representation> items = new HashSet<SimanticsClipboard.Representation>();
        this.fillTG(graph, items, true);
        this.fillCutResource(graph, items);
        clipboard.addContent(items);
    }
}

