/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.bundle.Activator;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.services.ServiceInitializer;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;

public class VirtualGraphInitializer
implements ServiceInitializer {
    public IStatus initialize(Session s) {
        MultiStatus result = new MultiStatus("org.simantics.db.layer0", 0, "VirtualGraphInitialize errors:", null);
        BundleContext context = Activator.getInstance().getContext();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            Enumeration graphs = b.getEntryPaths("virtualgraphs");
            while (graphs != null && graphs.hasMoreElements()) {
                Status status;
                String element = (String)graphs.nextElement();
                if (!element.endsWith(".tg")) continue;
                URL url = b.getEntry(element);
                try {
                    InputStream stream = url.openStream();
                    Binding binding = Bindings.getBinding(Datatype.class);
                    Serializer serializer = Bindings.getSerializerUnchecked((Binding)binding);
                    Datatype dt = (Datatype)serializer.deserialize(stream);
                    Datatype tgType = Datatypes.getDatatypeUnchecked(TransferableGraph1.class);
                    Binding tgBinding = TransferableGraph1.BINDING;
                    Serializer tgSerializer = Bindings.getSerializerUnchecked(TransferableGraph1.class);
                    if (dt.equals((Object)tgType)) {
                        VirtualGraphSupport support = (VirtualGraphSupport)s.getService(VirtualGraphSupport.class);
                        VirtualGraph vg = support.getMemoryPersistent(UUID.randomUUID().toString());
                        TransferableGraph1 tg = (TransferableGraph1)tgSerializer.deserialize(stream);
                        TransferableGraphs.importVirtualGraph((Session)s, (VirtualGraph)vg, (TransferableGraph1)tg, (IImportAdvisor)new ImportAdvisor());
                    }
                    stream.close();
                }
                catch (IOException e) {
                    status = new Status(4, context.getBundle().getSymbolicName(), "VirtualGraphInitializer transferable graph initialization failed for '" + url.toString() + "', see exception for details.", (Throwable)e);
                    result.add((IStatus)status);
                }
                catch (BindingConstructionException e) {
                    status = new Status(4, context.getBundle().getSymbolicName(), "VirtualGraphInitializer transferable graph initialization failed for '" + url.toString() + "', see exception for details.", (Throwable)e);
                    result.add((IStatus)status);
                }
                catch (DatabaseException e) {
                    status = new Status(4, context.getBundle().getSymbolicName(), "VirtualGraphInitializer transferable graph initialization failed for '" + url.toString() + "', see exception for details.", (Throwable)e);
                    result.add((IStatus)status);
                }
            }
            ++n2;
        }
        if (!result.isOK()) {
            return result;
        }
        return Status.OK_STATUS;
    }
}

