/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class SharedOntologyRemover
extends EntityRemover {
    public SharedOntologyRemover(Resource resource) {
        super(resource);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource ontology : Layer0Utils.listOntologies((ReadGraph)graph)) {
            if (!graph.hasStatement(ontology, L0.IsLinkedTo, this.resource)) continue;
            throw new CannotRemoveException("The shared library is being referenced by " + graph.getURI(ontology));
        }
        for (Resource model : (Collection)graph.syncRequest((Read)new ProjectModels(Simantics.getProject()))) {
            if (!graph.hasStatement(model, L0.IsLinkedTo, this.resource)) continue;
            throw new CannotRemoveException("The shared library is being referenced by " + graph.getURI(model));
        }
        super.remove(graph);
    }
}

