/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals.rules;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.scl.runtime.function.Function4;

public enum NameRule implements ITypicalSynchronizationRule
{
    INSTANCE;


    public static NameRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
        Function4 namingFunction = (Function4)info.getAux("typicalCompositeNamingFunction");
        if (namingFunction == null) {
            return false;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource templateComponent = graph.getPossibleObject(template, MOD.ElementToComponent);
        if (templateComponent == null) {
            return false;
        }
        Resource instanceComponent = graph.getPossibleObject(instance, MOD.ElementToComponent);
        if (instanceComponent == null) {
            return false;
        }
        Resource instanceComposite = graph.getPossibleObject(instanceComponent, L0.PartOf);
        if (instanceComposite == null) {
            return false;
        }
        String templateName = (String)graph.getPossibleRelatedValue(templateComponent, L0.HasName, (Binding)Bindings.STRING);
        if (templateName == null) {
            return false;
        }
        String evaluatedName = (String)namingFunction.apply((Object)graph, (Object)instanceComposite, (Object)instanceComponent, (Object)templateName);
        if (evaluatedName.equals(templateName)) {
            return false;
        }
        String instanceName = (String)graph.getPossibleRelatedValue(instanceComponent, L0.HasName, (Binding)Bindings.STRING);
        if (evaluatedName.equals(instanceName)) {
            return false;
        }
        graph.claimLiteral(instanceComponent, L0.HasName, (Object)evaluatedName);
        return true;
    }
}

