/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.handler.ElementObjectAssortment;
import org.simantics.diagram.handler.PasteOperation;
import org.simantics.diagram.handler.Paster;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CollectingModificationQueue;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationContext;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.ReadTypicalInfo;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.modeling.typicals.TypicalSynchronizationMetadata;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.modeling.typicals.rules.FlagRule;
import org.simantics.modeling.typicals.rules.InstanceOfRule;
import org.simantics.modeling.typicals.rules.LabelRule;
import org.simantics.modeling.typicals.rules.MonitorRule;
import org.simantics.modeling.typicals.rules.NameRule;
import org.simantics.modeling.typicals.rules.SVGElementRule;
import org.simantics.modeling.typicals.rules.TransformRule;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.ui.ErrorLogger;

public class SyncTypicalTemplatesToInstances
extends WriteRequest {
    public static final EmptyMapSet ALL = EmptyMapSet.INSTANCE;
    protected static final boolean DEBUG = false;
    protected Resource[] templates;
    protected Resource[] instances;
    protected MapSet<Resource, Resource> changedElementsByDiagram;
    protected Layer0 L0;
    protected StructuralResource2 STR;
    protected DiagramResource DIA;
    protected ModelingResources MOD;
    protected GraphSynchronizationContext syncCtx;
    protected TypicalSynchronizationMetadata metadata;
    protected IDiagram temporaryDiagram;
    protected ConnectionUtil cu;
    protected Map<Resource, Resource> s2t;
    protected Map<Resource, Resource> t2s;
    protected Map<Object, Object> copyMap;

    public SyncTypicalTemplatesToInstances(Resource ... templates) {
        this(templates, null, ALL);
    }

    public SyncTypicalTemplatesToInstances(Resource[] templates, MapSet<Resource, Resource> changedElementsByDiagram) {
        this(templates, null, changedElementsByDiagram);
    }

    public static SyncTypicalTemplatesToInstances syncSingleInstance(Resource instance) {
        return new SyncTypicalTemplatesToInstances(null, new Resource[]{instance}, ALL);
    }

    private SyncTypicalTemplatesToInstances(Resource[] templates, Resource[] instances, MapSet<Resource, Resource> changedElementsByDiagram) {
        this.templates = templates;
        this.instances = instances;
        this.changedElementsByDiagram = changedElementsByDiagram;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        int n;
        int n2;
        Resource[] resourceArray;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
        this.syncCtx = GraphSynchronizationContext.getWriteInstance((WriteGraph)graph, (IModificationQueue)new CollectingModificationQueue());
        this.syncCtx.set(ModelingSynchronizationHints.MODELING_RESOURCE, (Object)ModelingResources.getInstance((ReadGraph)graph));
        this.metadata = new TypicalSynchronizationMetadata();
        this.metadata.synchronizedTypicals = new ArrayList<Resource>();
        this.temporaryDiagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
        this.temporaryDiagram.setHint(SynchronizationHints.CONTEXT, (Object)this.syncCtx);
        this.cu = new ConnectionUtil(graph);
        if (this.templates != null) {
            resourceArray = this.templates;
            n2 = this.templates.length;
            n = 0;
            while (n < n2) {
                Resource template = resourceArray[n];
                this.syncTemplate(graph, template);
                ++n;
            }
        }
        if (this.instances != null) {
            resourceArray = this.instances;
            n2 = this.instances.length;
            n = 0;
            while (n < n2) {
                Resource instance = resourceArray[n];
                this.syncInstance(graph, instance);
                ++n;
            }
        }
        if (!this.metadata.getTypicals().isEmpty()) {
            graph.addMetadata((Metadata)this.metadata);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Synchronized " + this.metadata.getTypicals().size() + " typical diagram instances (" + this.metadata.getTypicals() + ") with their templates."));
        }
        this.temporaryDiagram = null;
        this.syncCtx = null;
    }

    private void syncTemplate(WriteGraph graph, Resource template) throws DatabaseException {
        Collection instances = graph.getObjects(template, this.MOD.DiagramHasInstance);
        if (instances.isEmpty()) {
            return;
        }
        THashSet templateElements = new THashSet((Collection)graph.syncRequest((Read)new ObjectsWithType(template, this.L0.ConsistsOf, this.DIA.Element)));
        try {
            for (Resource instance : instances) {
                this.temporaryDiagram.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE, (Object)instance);
                this.syncInstance(graph, template, instance, (Set<Resource>)templateElements);
            }
        }
        finally {
            this.temporaryDiagram.removeHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        }
    }

    private void syncInstance(WriteGraph graph, Resource instance) throws DatabaseException {
        Resource template = graph.getPossibleObject(instance, this.MOD.HasDiagramSource);
        if (template == null) {
            return;
        }
        THashSet templateElements = new THashSet((Collection)graph.syncRequest((Read)new ObjectsWithType(template, this.L0.ConsistsOf, this.DIA.Element)));
        try {
            this.temporaryDiagram.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE, (Object)instance);
            this.syncInstance(graph, template, instance, (Set<Resource>)templateElements);
        }
        finally {
            this.temporaryDiagram.removeHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        }
    }

    private void syncInstance(WriteGraph graph, Resource template, Resource instance, Set<Resource> currentTemplateElements) throws DatabaseException {
        Function4 namingFunction;
        TypicalInfo typicalInfo = (TypicalInfo)((Object)graph.syncRequest((Read)new ReadTypicalInfo(instance), (Listener)TransientCacheListener.instance()));
        typicalInfo = (TypicalInfo)typicalInfo.clone();
        typicalInfo.templateElements = currentTemplateElements;
        typicalInfo.auxiliary = new HashMap<Object, Object>(1);
        Resource compositeInstance = graph.getPossibleObject(instance, this.MOD.DiagramToComposite);
        if (compositeInstance != null && (namingFunction = (Function4)graph.getPossibleRelatedValue2(compositeInstance, this.MOD.TypicalComposite_typicalNamingFunction)) != null) {
            typicalInfo.auxiliary.put("typicalCompositeNamingFunction", namingFunction);
        }
        int dSizeAbs = Math.abs(typicalInfo.instanceElements.size() - currentTemplateElements.size());
        Set<Resource> instanceElementsRemovedFromTemplate = this.findInstanceElementsRemovedFromTemplate((ReadGraph)graph, typicalInfo, (THashSet<Resource>)new THashSet(dSizeAbs));
        Set<Resource> templateElementsAddedToTemplate = this.findTemplateElementsMissingFromInstance(graph, currentTemplateElements, typicalInfo, (THashSet<Resource>)new THashSet(dSizeAbs));
        Set changedTemplateElements = this.changedElementsByDiagram.removeValues((Object)template);
        boolean changed = false;
        changed |= this.removeElements(graph, typicalInfo, instanceElementsRemovedFromTemplate);
        changed |= this.addMissingElements(graph, typicalInfo, template, instance, templateElementsAddedToTemplate);
        if (changed |= this.synchronizeChangedElements(graph, typicalInfo, template, instance, changedTemplateElements, this.changedElementsByDiagram == ALL)) {
            this.metadata.addTypical(instance);
        }
    }

    private boolean addMissingElements(WriteGraph graph, TypicalInfo typicalInfo, Resource template, Resource instance, Set<Resource> elementsAddedToTemplate) throws DatabaseException {
        if (elementsAddedToTemplate.isEmpty()) {
            return false;
        }
        CopyAdvisor copyAdvisor = (CopyAdvisor)graph.syncRequest((Read)new Adapter(instance, CopyAdvisor.class));
        this.temporaryDiagram.setHint(SynchronizationHints.COPY_ADVISOR, (Object)copyAdvisor);
        ElementObjectAssortment assortment = new ElementObjectAssortment((ReadGraph)graph, elementsAddedToTemplate);
        if (this.copyMap == null) {
            this.copyMap = new THashMap();
        } else {
            this.copyMap.clear();
        }
        PasteOperation pasteOp = new PasteOperation(Commands.COPY, null, template, instance, this.temporaryDiagram, assortment, false, (Point2D)new Point2D.Double(0.0, 0.0), typicalInfo.templateToInstance, this.copyMap);
        new Paster(graph.getSession(), pasteOp).perform(graph);
        boolean changed = false;
        for (Resource addedElement : elementsAddedToTemplate) {
            Resource copyElement = (Resource)this.copyMap.get(addedElement);
            if (copyElement == null) continue;
            graph.claim(copyElement, this.MOD.IsTemplatized, this.MOD.IsTemplatized, copyElement);
            graph.claim(copyElement, this.MOD.HasElementSource, this.MOD.ElementHasInstance, addedElement);
            typicalInfo.instanceElements.add(copyElement);
            typicalInfo.instanceToTemplate.put(copyElement, addedElement);
            typicalInfo.templateToInstance.put(addedElement, copyElement);
            changed = true;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource instanceComposite = graph.getPossibleObject(instance, MOD.DiagramToComposite);
        ArrayList<Resource> instanceComponents = new ArrayList<Resource>(elementsAddedToTemplate.size());
        for (Resource addedElement : elementsAddedToTemplate) {
            Resource component;
            Resource copyElement = (Resource)this.copyMap.get(addedElement);
            if (copyElement == null) continue;
            this.postProcessAddedElement(graph, addedElement, copyElement, typicalInfo);
            if (instanceComponents == null || (component = graph.getPossibleObject(copyElement, MOD.ElementToComponent)) == null) continue;
            instanceComponents.add(component);
        }
        if (instanceComposite != null) {
            TypicalUtil.applySelectedModuleNames(graph, instanceComposite, instanceComponents);
        }
        return changed;
    }

    private void postProcessAddedElement(WriteGraph graph, Resource addedTemplateElement, Resource addedInstanceElement, TypicalInfo typicalInfo) throws DatabaseException {
        if (graph.isInstanceOf(addedInstanceElement, this.DIA.Monitor)) {
            this.postProcessAddedMonitor(graph, addedTemplateElement, addedInstanceElement, typicalInfo);
        }
    }

    private void postProcessAddedMonitor(WriteGraph graph, Resource addedTemplateMonitor, Resource addedInstanceMonitor, TypicalInfo typicalInfo) throws DatabaseException {
        Resource monitoredInstanceComponent;
        Resource monitoredInstanceElement;
        Resource monitoredTemplateElement;
        Resource monitor = addedInstanceMonitor;
        Resource monitoredComponent = graph.getPossibleObject(monitor, this.DIA.HasMonitorComponent);
        if (monitoredComponent != null && (monitoredTemplateElement = graph.getPossibleObject(monitoredComponent, this.MOD.ComponentToElement)) != null && (monitoredInstanceElement = typicalInfo.templateToInstance.get(monitoredTemplateElement)) != null && (monitoredInstanceComponent = graph.getPossibleObject(monitoredInstanceElement, this.MOD.ElementToComponent)) != null) {
            graph.deny(monitor, this.DIA.HasMonitorComponent);
            graph.claim(monitor, this.DIA.HasMonitorComponent, monitoredInstanceComponent);
        }
    }

    private boolean removeElements(WriteGraph graph, TypicalInfo typicalInfo, Set<Resource> elementsRemovedFromTemplate) throws DatabaseException {
        if (elementsRemovedFromTemplate.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Resource removedElement : elementsRemovedFromTemplate) {
            RemoverUtil.remove((WriteGraph)graph, (Resource)removedElement);
            typicalInfo.instanceElements.remove(removedElement);
            Resource template = typicalInfo.instanceToTemplate.remove(removedElement);
            if (template != null) {
                typicalInfo.templateToInstance.remove(template);
            }
            changed = true;
        }
        return changed;
    }

    private Set<Resource> findTemplateElementsMissingFromInstance(WriteGraph graph, Collection<Resource> currentTemplateElements, TypicalInfo typicalInfo, THashSet<Resource> result) throws DatabaseException {
        for (Resource templateElement : currentTemplateElements) {
            Resource instanceElement = typicalInfo.templateToInstance.get(templateElement);
            if (instanceElement != null) continue;
            result.add((Object)templateElement);
        }
        return result;
    }

    public Set<Resource> findInstanceElementsRemovedFromTemplate(ReadGraph graph, TypicalInfo typicalInfo, THashSet<Resource> result) throws DatabaseException {
        for (Resource instanceElement : typicalInfo.instanceElements) {
            if (typicalInfo.instanceToTemplate.containsKey(instanceElement) || !typicalInfo.isTemplatized.contains(instanceElement)) continue;
            result.add((Object)instanceElement);
        }
        return result;
    }

    private boolean synchronizeChangedElements(WriteGraph graph, TypicalInfo typicalInfo, Resource template, Resource instance, Collection<Resource> changedTemplateElements, boolean synchronizeAllElements) throws DatabaseException {
        if (synchronizeAllElements) {
            changedTemplateElements = (Collection)graph.syncRequest((Read)new ObjectsWithType(template, this.L0.ConsistsOf, this.DIA.Element));
        }
        if (changedTemplateElements.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Resource changedTemplateElement : changedTemplateElements) {
            Resource instanceElement = typicalInfo.templateToInstance.get(changedTemplateElement);
            if (instanceElement == null) continue;
            changed |= InstanceOfRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            changed |= NameRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            changed |= TransformRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            changed |= LabelRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            Set types = graph.getTypes(changedTemplateElement);
            if (types.contains(this.DIA.RouteGraphConnection)) {
                changed |= this.synchronizeConnection(graph, changedTemplateElement, instanceElement, typicalInfo);
            } else if (types.contains(this.DIA.Flag)) {
                changed |= FlagRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            } else if (types.contains(this.DIA.Monitor)) {
                changed |= MonitorRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            } else if (types.contains(this.DIA.SVGElement)) {
                changed |= SVGElementRule.INSTANCE.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            }
            for (Resource rule : graph.getObjects(changedTemplateElement, this.MOD.HasTypicalSynchronizationRule)) {
                ITypicalSynchronizationRule r = (ITypicalSynchronizationRule)graph.getPossibleAdapter(rule, ITypicalSynchronizationRule.class);
                if (r == null) continue;
                changed |= r.synchronize(graph, changedTemplateElement, instanceElement, typicalInfo);
            }
        }
        if (this.s2t != null) {
            this.s2t.clear();
        }
        if (this.t2s != null) {
            this.t2s.clear();
        }
        return changed;
    }

    private boolean synchronizeConnection(WriteGraph graph, Resource sourceConnection, Resource targetConnection, TypicalInfo typicalInfo) throws DatabaseException {
        boolean changed = false;
        this.s2t = SyncTypicalTemplatesToInstances.newOrClear(this.s2t);
        this.t2s = SyncTypicalTemplatesToInstances.newOrClear(this.t2s);
        if (this.cu == null) {
            this.cu = new ConnectionUtil(graph);
        }
        Collection targetConnectors = graph.getObjects(targetConnection, this.DIA.HasConnector);
        for (Resource targetConnector : targetConnectors) {
            Resource connectionOfTemplateConnector;
            Resource templateConnector;
            Resource isConnectedTo;
            Statement toNode = this.cu.getConnectedComponentStatement(targetConnection, targetConnector);
            if (toNode == null) {
                ErrorLogger.defaultLogError((String)("Encountered corrupted typical template connection " + NameUtils.getSafeName((ReadGraph)graph, (Resource)targetConnection, (boolean)true) + " with a stray DIA.Connector instance " + NameUtils.getSafeName((ReadGraph)graph, (Resource)targetConnector, (boolean)true)), (Throwable)new Exception("trace"));
                return false;
            }
            if (!graph.hasStatement(toNode.getObject(), this.MOD.IsTemplatized)) {
                return false;
            }
            Resource templateNode = graph.getPossibleObject(toNode.getObject(), this.MOD.HasElementSource);
            if (templateNode == null || (isConnectedTo = graph.getPossibleInverse(toNode.getPredicate())) == null || (templateConnector = graph.getPossibleObject(templateNode, isConnectedTo)) == null || !sourceConnection.equals(connectionOfTemplateConnector = ConnectionUtil.tryGetConnection((ReadGraph)graph, (Resource)templateConnector))) continue;
            this.s2t.put(templateConnector, targetConnector);
            this.t2s.put(targetConnector, templateConnector);
        }
        Collection sourceInteriorRouteNodes = graph.getObjects(sourceConnection, this.DIA.HasInteriorRouteNode);
        Collection targetInteriorRouteNodes = graph.getObjects(targetConnection, this.DIA.HasInteriorRouteNode);
        THashMap sourceToRouteLine = new THashMap();
        THashMap targetToRouteLine = new THashMap();
        for (Resource source : sourceInteriorRouteNodes) {
            sourceToRouteLine.put(source, Paster.readRouteLine((ReadGraph)graph, (Resource)source));
        }
        for (Resource target : targetInteriorRouteNodes) {
            targetToRouteLine.put(target, Paster.readRouteLine((ReadGraph)graph, (Resource)target));
        }
        Iterator sourceIt = sourceToRouteLine.entrySet().iterator();
        block3: while (!targetToRouteLine.isEmpty() && sourceIt.hasNext()) {
            Map.Entry sourceEntry = sourceIt.next();
            Paster.RouteLine sourceLine = (Paster.RouteLine)sourceEntry.getValue();
            Iterator targetIt = targetToRouteLine.entrySet().iterator();
            while (targetIt.hasNext()) {
                Map.Entry targetEntry = targetIt.next();
                if (!sourceLine.equals(targetEntry.getValue())) continue;
                this.s2t.put((Resource)sourceEntry.getKey(), (Resource)targetEntry.getKey());
                this.t2s.put((Resource)targetEntry.getKey(), (Resource)sourceEntry.getKey());
                sourceIt.remove();
                targetIt.remove();
                continue block3;
            }
        }
        for (Resource targetConnector : targetConnectors) {
            if (this.t2s.containsKey(targetConnector)) continue;
            this.cu.removeConnectionPart(targetConnector);
            changed = true;
        }
        Collection sourceConnectors = graph.getObjects(sourceConnection, this.DIA.HasConnector);
        for (Resource sourceConnector : sourceConnectors) {
            if (this.s2t.containsKey(sourceConnector)) continue;
            Statement sourceIsConnectorOf = graph.getSingleStatement(sourceConnector, this.DIA.IsConnectorOf);
            Statement connects = this.cu.getConnectedComponentStatement(sourceConnection, sourceConnector);
            if (connects == null) {
                throw new DatabaseException("ERROR: connector is astray, i.e. not connected to a node element: " + SyncTypicalTemplatesToInstances.safeNameAndType((ReadGraph)graph, sourceConnector));
            }
            Resource connectsInstanceElement = typicalInfo.templateToInstance.get(connects.getObject());
            if (connectsInstanceElement == null) {
                throw new DatabaseException("ERROR: could not find instance element to which template element " + SyncTypicalTemplatesToInstances.safeNameAndType((ReadGraph)graph, connects.getObject()) + " is connected to");
            }
            Resource hasConnector = graph.getInverse(sourceIsConnectorOf.getPredicate());
            Resource newTargetConnector = this.cu.newConnector(targetConnection, hasConnector);
            graph.claim(newTargetConnector, connects.getPredicate(), connectsInstanceElement);
            changed = true;
            this.s2t.put(sourceConnector, newTargetConnector);
            this.t2s.put(newTargetConnector, sourceConnector);
        }
        Resource[] targetRouteLines = targetToRouteLine.keySet().toArray(Resource.NONE);
        int targetRouteLine = targetRouteLines.length - 1;
        for (Map.Entry sourceEntry : sourceToRouteLine.entrySet()) {
            Resource source = (Resource)sourceEntry.getKey();
            Paster.RouteLine sourceLine = (Paster.RouteLine)sourceEntry.getValue();
            Resource target = null;
            if (targetRouteLine < 0) {
                target = this.cu.newRouteLine(targetConnection, Double.valueOf(sourceLine.getPosition()), Boolean.valueOf(sourceLine.isHorizontal()));
                changed = true;
            } else {
                target = targetRouteLines[targetRouteLine--];
                this.copyRouteLine(graph, source, target);
                this.cu.disconnectFromAllRouteNodes(target);
                changed = true;
            }
            this.s2t.put(source, target);
            this.t2s.put(target, source);
        }
        if (targetRouteLine >= 0) {
            while (targetRouteLine >= 0) {
                this.cu.removeConnectionPart(targetRouteLines[targetRouteLine]);
                --targetRouteLine;
            }
        }
        changed |= this.connectRouteNodes(graph, sourceInteriorRouteNodes);
        changed |= this.connectRouteNodes(graph, sourceConnectors);
        changed |= this.cu.removeExtraInteriorRouteNodes(targetConnection) > 0;
        return changed |= this.cu.removeUnusedConnectors(targetConnection) > 0;
    }

    private boolean connectRouteNodes(WriteGraph graph, Collection<Resource> sourceRouteNodes) throws DatabaseException {
        boolean changed = false;
        for (Resource src : sourceRouteNodes) {
            Resource dst = this.s2t.get(src);
            if (dst == null) {
                throw new DatabaseException("TARGET ROUTE NODE == NULL FOR SRC: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)src));
            }
            Collection connectedToSrcs = graph.getObjects(src, this.DIA.AreConnected);
            Collection connectedToDsts = graph.getObjects(dst, this.DIA.AreConnected);
            for (Resource connectedToDst : connectedToDsts) {
                Resource connectedToSrc = this.t2s.get(connectedToDst);
                if (connectedToSrc == null) {
                    throw new DatabaseException("CONNECTED TO SRC == NULL FOR DST: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectedToDst));
                }
                if (connectedToSrc != null && graph.hasStatement(src, this.DIA.AreConnected, connectedToSrc)) continue;
                graph.deny(dst, this.DIA.AreConnected, this.DIA.AreConnected, connectedToDst);
                changed = true;
            }
            for (Resource connectedToSrc : connectedToSrcs) {
                Resource connectedToDst = this.s2t.get(connectedToSrc);
                if (connectedToDst == null) {
                    throw new DatabaseException("CONNECTED TO DST == NULL FOR SRC: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectedToSrc));
                }
                if (graph.hasStatement(dst, this.DIA.AreConnected, connectedToDst)) continue;
                graph.claim(dst, this.DIA.AreConnected, this.DIA.AreConnected, connectedToDst);
                changed = true;
            }
        }
        return changed;
    }

    private void copyRouteLine(WriteGraph graph, Resource src, Resource tgt) throws DatabaseException {
        Double pos = (Double)graph.getPossibleRelatedValue(src, this.DIA.HasPosition, (Binding)Bindings.DOUBLE);
        Boolean hor = (Boolean)graph.getPossibleRelatedValue(src, this.DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
        if (pos == null) {
            pos = 0.0;
        }
        if (hor == null) {
            hor = Boolean.TRUE;
        }
        graph.claimLiteral(tgt, this.DIA.HasPosition, this.L0.Double, (Object)pos, (Binding)Bindings.DOUBLE);
        graph.claimLiteral(tgt, this.DIA.IsHorizontal, this.L0.Boolean, (Object)hor, (Binding)Bindings.BOOLEAN);
    }

    private static String safeNameAndType(ReadGraph graph, Resource r) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true));
        sb.append(" : [");
        boolean first = true;
        for (Resource type : graph.getPrincipalTypes(r)) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)type, (boolean)true));
        }
        sb.append("]");
        return sb.toString();
    }

    private static <K, V> Map<K, V> newOrClear(Map<K, V> current) {
        if (current == null) {
            return new THashMap();
        }
        current.clear();
        return current;
    }

    public static class EmptyMapSet
    extends MapSet<Resource, Resource> {
        public static final EmptyMapSet INSTANCE = new EmptyMapSet();

        public EmptyMapSet() {
            this.sets = Collections.emptyMap();
        }

        protected Set<Resource> getOrCreateSet(Resource key) {
            throw new UnsupportedOperationException("immutable constant instance");
        }
    }
}

