/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.request.VariableValue;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.format.ValueFormat;

public class SubscriptionItemLabel {
    public static String resolveLabel(ReadGraph graph, Resource item, boolean synchronous) throws DatabaseException {
        IEclipsePreferences chartPreferenceNode = InstanceScope.INSTANCE.getNode("org.simantics.charts");
        String s = chartPreferenceNode.get("chart.valueformat", ValueFormat.Default.name());
        ValueFormat valueFormat = ValueFormat.valueOf((String)s);
        return SubscriptionItemLabel.resolveLabel(graph, item, valueFormat, synchronous);
    }

    public static String resolveLabel(ReadGraph graph, Resource item, ValueFormat valueFormat, boolean synchronous) throws DatabaseException {
        return SubscriptionItemLabel.resolveLabel(graph, item, valueFormat, synchronous, true, true);
    }

    public static String resolveLabel(ReadGraph graph, Resource item, ValueFormat valueFormat, boolean synchronous, boolean tryLabel, boolean showValue) throws DatabaseException {
        Variable variable;
        Variable base;
        Resource run;
        Resource model;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        String label = tryLabel ? (String)graph.getPossibleRelatedValue(item, L0.HasLabel, (Binding)Bindings.STRING) : null;
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        RVI rvi = (RVI)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_VariableId, rviBinding);
        Variable configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)item);
        if ((label == null || label.isEmpty()) && rvi != null && configuration != null) {
            label = rvi.asPossibleString(graph, configuration);
            if (label == null) {
                label = rvi.toPossibleString(graph, configuration);
            }
            if (label != null) {
                label = SubscriptionItemLabel.removeVariablePrefixPath(label);
                label = URIStringUtils.unescape((String)label);
            }
        }
        if (label == null) {
            label = "<no variable id>";
        }
        if (showValue && rvi != null && configuration != null && (model = Variables.getPossibleModel((ReadGraph)graph, (Variable)configuration)) != null && (run = (Resource)graph.sync((ReadInterface)new PossibleActiveExperiment(model))) != null && (base = Variables.getPossibleVariable((ReadGraph)graph, (Resource)run)) != null && (variable = rvi.resolvePossible(graph, base)) != null) {
            StringBuilder sb;
            block13: {
                sb = new StringBuilder(label);
                Double gain = (Double)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Gain, (Binding)Bindings.DOUBLE);
                Double bias = (Double)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Bias, (Binding)Bindings.DOUBLE);
                String unit = (String)graph.getPossibleRelatedValue(item, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
                boolean oldSync = graph.setSynchronous(synchronous);
                try {
                    try {
                        Object value = graph.syncRequest((Read)new VariableValue(variable));
                        if (value instanceof Number) {
                            double d = ((Number)value).doubleValue();
                            double ad = d * gain + bias;
                            sb.append(" (").append(valueFormat.format.format(ad));
                        } else {
                            sb.append(" (").append(FormattingUtils.engineeringFormat((Object)value));
                        }
                        if (unit != null && !unit.isEmpty()) {
                            sb.append(' ').append(unit);
                        }
                        sb.append(')');
                    }
                    catch (PendingVariableException e) {
                        sb.append(" (<pending>)");
                        graph.setSynchronous(oldSync);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    graph.setSynchronous(oldSync);
                    throw throwable;
                }
                graph.setSynchronous(oldSync);
            }
            label = sb.toString();
        }
        return label;
    }

    public static String removeVariablePrefixPath(String rvi) {
        int propIndex = rvi.indexOf(35);
        if (propIndex == -1) {
            return rvi;
        }
        int prevSlash = rvi.lastIndexOf(47, propIndex);
        if (prevSlash == -1) {
            return rvi;
        }
        Pair<String, Integer> attrKey = SubscriptionItemLabel.attributeKey(rvi, propIndex + 1);
        return String.valueOf(rvi.substring(prevSlash + 1, propIndex + 1)) + (String)attrKey.first + (attrKey.second != null ? "(" + ((Integer)attrKey.second + 1) + ")" : "");
    }

    public static Pair<String, Integer> attributeKey(String key, int start) {
        ChildReference child;
        boolean isIndexed;
        int iy = key.lastIndexOf(47);
        boolean bl = isIndexed = iy >= start;
        if (isIndexed && (child = ChildReference.parsePath((String)key.substring(iy + 1))) instanceof IndexReference) {
            return Pair.make((Object)key.substring(start, iy), (Object)((IndexReference)child).getIndex());
        }
        return Pair.make((Object)key.substring(start), null);
    }
}

