/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import gnu.trove.THashMap;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategyBase;
import org.simantics.modeling.services.NamingException;

public class CaseInsensitiveComponentIndexNamingStrategy
extends ComponentNamingStrategyBase {
    protected static final boolean DEBUG_INDEX_SEARCH = false;
    private final GenericRelationIndex index;
    private SoftReference<THashMap<Resource, SoftReference<Cache>>> mapRef = new SoftReference<THashMap>(new THashMap());
    CaseInsensitiveComponentNamingStrategy2 fallbackStrategy = null;

    public CaseInsensitiveComponentIndexNamingStrategy(GenericRelationIndex index) {
        this("%s %d", index);
    }

    public CaseInsensitiveComponentIndexNamingStrategy(String generatedNameFormat, GenericRelationIndex index) {
        super(generatedNameFormat);
        this.index = index;
    }

    public void dispose() {
        this.mapRef.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (model == null) {
            System.err.println("Could not find Model from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
            if (this.fallbackStrategy == null) {
                this.fallbackStrategy = new CaseInsensitiveComponentNamingStrategy2((GraphChangeListenerSupport)graph.getService(GraphChangeListenerSupport.class), this.generatedNameFormat);
            }
            return this.fallbackStrategy.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
        }
        CaseInsensitiveComponentIndexNamingStrategy caseInsensitiveComponentIndexNamingStrategy = this;
        synchronized (caseInsensitiveComponentIndexNamingStrategy) {
            String search = "Name:" + proposition + "*";
            List components = this.index.query((RequestProcessor)graph, search, "bffff", new Object[]{model}, Integer.MAX_VALUE);
            TreeSet<Object> reserved = new TreeSet<Object>(this.getComparator());
            for (Map componentResult : components) {
                String name = (String)componentResult.get("Name");
                if (name == null) continue;
                reserved.add(name);
            }
            Cache cache = this.getCache(graph, configurationRoot);
            cache.removeReserved(reserved);
            this.findStartsWithMatches(cache.getRequested(), proposition, reserved);
            String result = this.findFreshName(reserved, proposition, acceptProposition);
            cache.addRequested(result);
            return result;
        }
    }

    private synchronized Cache getCache(ReadGraph graph, Resource configurationRoot) throws DatabaseException {
        Cache cache = null;
        THashMap map = this.mapRef.get();
        if (map != null) {
            SoftReference cacheRef = (SoftReference)map.get((Object)configurationRoot);
            if (cacheRef != null && (cache = (Cache)cacheRef.get()) != null) {
                return cache;
            }
        } else {
            map = new THashMap();
            this.mapRef = new SoftReference<THashMap>(map);
        }
        cache = new Cache(this.caseInsensitive);
        map.put((Object)configurationRoot, new SoftReference<Cache>(cache));
        return cache;
    }

    static class Cache {
        private final Set<String> requested;

        Cache(boolean caseInsensitive) {
            this.requested = new TreeSet<Object>(CaseInsensitiveComponentIndexNamingStrategy.getComparator(caseInsensitive));
        }

        public Set<String> getRequested() {
            return this.requested;
        }

        public void addRequested(String name) {
            this.requested.add(name);
        }

        public void removeReserved(Set<String> reserved) {
            this.requested.removeAll(reserved);
        }
    }
}

