/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import gnu.trove.THashMap;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategyBase;
import org.simantics.modeling.services.NamingException;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;

public class CaseInsensitiveComponentFunctionNamingStrategy
extends ComponentNamingStrategyBase {
    protected static final boolean DEBUG_INDEX_SEARCH = false;
    private final Function index;
    private Function1<String, String> propositionPreFilter;
    private SoftReference<THashMap<Resource, SoftReference<Cache>>> mapRef = new SoftReference<THashMap>(new THashMap());
    CaseInsensitiveComponentNamingStrategy2 fallbackStrategy = null;

    public CaseInsensitiveComponentFunctionNamingStrategy(Function index) {
        this("%s %d", index);
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index) {
        super(generatedNameFormat);
        this.index = index;
    }

    public CaseInsensitiveComponentFunctionNamingStrategy(String generatedNameFormat, Function index, Function1<String, String> propositionPreFilter) {
        super(generatedNameFormat);
        this.index = index;
        this.propositionPreFilter = propositionPreFilter;
    }

    public void dispose() {
        this.mapRef.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition, boolean acceptProposition) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            System.err.println("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
            if (this.fallbackStrategy == null) {
                this.fallbackStrategy = new CaseInsensitiveComponentNamingStrategy2((GraphChangeListenerSupport)graph.getService(GraphChangeListenerSupport.class), this.generatedNameFormat);
            }
            return this.fallbackStrategy.validateInstanceName(graph, configurationRoot, container, componentType, proposition, acceptProposition);
        }
        if (this.propositionPreFilter != null) {
            proposition = (String)this.propositionPreFilter.apply((Object)proposition);
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            String search = "Name:" + proposition + "*";
            List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
            TreeSet<Object> reserved = new TreeSet<Object>(this.getComparator());
            for (Map componentResult : components) {
                String name = (String)componentResult.get("Name");
                if (name == null) continue;
                reserved.add(name);
            }
            int indexCounter = Indexing.getIndexPendingCounter();
            Cache cache = this.getCache(graph, configurationRoot);
            if (Indexing.isIndexPending()) {
                cache.removeReserved(reserved);
            } else {
                cache.clearIfPossible(indexCounter);
            }
            this.findStartsWithMatches(cache.getRequested(), proposition, reserved);
            String result = this.findFreshName(reserved, proposition, acceptProposition);
            cache.addRequested(result);
            cache.setIndexCounter(indexCounter);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> validateInstanceNames(ReadGraph graph, Resource configurationRoot, List<String> propositions, boolean acceptProposition, Set<String> externallyReserved) throws NamingException, DatabaseException {
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(configurationRoot));
        if (indexRoot == null) {
            throw new NamingException("Could not find index root from configuration root '" + NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRoot, (boolean)true) + "'");
        }
        CaseInsensitiveComponentFunctionNamingStrategy caseInsensitiveComponentFunctionNamingStrategy = this;
        synchronized (caseInsensitiveComponentFunctionNamingStrategy) {
            ArrayList<String> result = new ArrayList<String>(propositions.size());
            TreeSet<Object> reserved = new TreeSet<Object>(this.getComparator());
            for (String proposition : propositions) {
                if (this.propositionPreFilter != null) {
                    proposition = (String)this.propositionPreFilter.apply((Object)proposition);
                }
                String search = "Name:" + IndexQueries.escape((String)proposition) + "*";
                List components = (List)this.index.apply((Object)graph, (Object)indexRoot, (Object)search, (Object)Integer.MAX_VALUE);
                reserved.clear();
                for (Map componentResult : components) {
                    String name = (String)componentResult.get("Name");
                    if (name == null) continue;
                    reserved.add(name);
                }
                if (externallyReserved != null) {
                    reserved.addAll(externallyReserved);
                }
                reserved.addAll(result);
                String name = this.findFreshName(reserved, proposition, acceptProposition);
                result.add(name);
            }
            return result;
        }
    }

    private synchronized Cache getCache(ReadGraph graph, Resource configurationRoot) throws DatabaseException {
        Cache cache = null;
        THashMap map = this.mapRef.get();
        if (map != null) {
            SoftReference cacheRef = (SoftReference)map.get((Object)configurationRoot);
            if (cacheRef != null && (cache = (Cache)cacheRef.get()) != null) {
                return cache;
            }
        } else {
            map = new THashMap();
            this.mapRef = new SoftReference<THashMap>(map);
        }
        cache = new Cache(this.caseInsensitive);
        map.put((Object)configurationRoot, new SoftReference<Cache>(cache));
        return cache;
    }

    static class Cache {
        private final Set<String> requested;
        private int indexCounter = -1;

        Cache(boolean caseInsensitive) {
            this.requested = new TreeSet<Object>(CaseInsensitiveComponentFunctionNamingStrategy.getComparator(caseInsensitive));
        }

        public Set<String> getRequested() {
            return this.requested;
        }

        public void addRequested(String name) {
            this.requested.add(name);
        }

        public void removeReserved(Set<String> reserved) {
            this.requested.removeAll(reserved);
        }

        public void setIndexCounter(int indexCounter) {
            this.indexCounter = indexCounter;
        }

        public void clearIfPossible(int indexCounter) {
            if (indexCounter > this.indexCounter) {
                this.requested.clear();
            }
        }
    }
}

