/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.GraphEntityType;
import org.simantics.modeling.scl.GraphPropertyRelation;
import org.simantics.modeling.scl.GraphRelation;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.LazyModule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.SCLTypeParseException;

public class OntologyModule
extends LazyModule {
    private static final String DB_MODULE = "Simantics/DB";
    private static final Collection<DImportAst> DEPENDENCIES = Arrays.asList(new DImportAst("Simantics/DB", null));
    private static final TCon RESOURCE = Types.con((String)"Simantics/DB", (String)"Resource");
    Map<String, Resource> childMap;

    public OntologyModule(ReadGraph graph, String moduleName) throws DatabaseException {
        super(moduleName);
        Resource ontology = graph.getResource(moduleName);
        this.childMap = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(ontology));
    }

    public Collection<DImportAst> getDependencies() {
        return DEPENDENCIES;
    }

    protected SCLValue createValue(String name) {
        Resource resource = this.childMap.get(name);
        if (resource == null) {
            return null;
        }
        SCLValue value = new SCLValue(Name.create((String)this.getModuleName(), (String)name));
        value.setType((Type)RESOURCE);
        value.setExpression((Expression)new EExternalConstant((Object)resource, (Type)RESOURCE));
        value.setInlineInSimplification(true);
        return value;
    }

    protected SCLRelation createRelation(String name) {
        final Resource resource = this.childMap.get(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return OntologyModule.createRelation(graph, resource);
        }
        try {
            return (SCLRelation)Simantics.getSession().syncRequest((Read)new Read<SCLRelation>(){

                public SCLRelation perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.createRelation(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SCLRelation createRelation(ReadGraph graph, Resource relation) {
        Type valueType;
        Layer0 L0;
        block4: {
            try {
                L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(relation, L0.Relation)) break block4;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (graph.isInstanceOf(relation, L0.PropertyRelation) && graph.isInstanceOf(relation, L0.FunctionalRelation) && (valueType = OntologyModule.getValueType(graph, relation)) != null) {
            return new GraphPropertyRelation(relation, valueType);
        }
        Resource inverseRelation = graph.getPossibleInverse(relation);
        return new GraphRelation(relation, OntologyModule.getSelectivity(graph, relation), inverseRelation, OntologyModule.getSelectivity(graph, inverseRelation));
    }

    protected SCLEntityType createEntityType(String name) {
        final Resource resource = this.childMap.get(name);
        if (resource == null) {
            return null;
        }
        ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
        if (graph != null) {
            return this.createEntityType(graph, resource);
        }
        try {
            return (SCLEntityType)Simantics.getSession().syncRequest((Read)new Read<SCLEntityType>(){

                public SCLEntityType perform(ReadGraph graph) throws DatabaseException {
                    return OntologyModule.this.createEntityType(graph, resource);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SCLEntityType createEntityType(ReadGraph graph, Resource type) {
        block3: {
            try {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, L0.Type)) break block3;
                return null;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new GraphEntityType(graph, type);
    }

    private static double getSelectivity(ReadGraph graph, Resource relation) throws DatabaseException {
        if (relation == null) {
            return Double.POSITIVE_INFINITY;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(relation, L0.FunctionalRelation)) {
            return 1.0;
        }
        return 10.0;
    }

    private static Type getValueType(ReadGraph graph, Resource relation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Type valueType = OntologyModule.parseValueType((String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING));
        if (valueType != null) {
            return valueType;
        }
        Resource range = graph.getPossibleObject(relation, L0.HasRange);
        if (range != null) {
            for (Resource valueTypeLiteral : graph.getAssertedObjects(range, L0.HasValueType)) {
                valueType = OntologyModule.parseValueType((String)graph.getValue(valueTypeLiteral, (Binding)Bindings.STRING));
                if (valueType == null) continue;
                return valueType;
            }
        }
        return null;
    }

    private static Type parseValueType(String valueTypeString) {
        if (valueTypeString == null) {
            return null;
        }
        try {
            return Types.parseType((String)valueTypeString);
        }
        catch (SCLTypeParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void findValuesForPrefix(Collection<SCLValue> values, String prefix) {
        for (String name : this.childMap.keySet()) {
            if (!name.startsWith(prefix)) continue;
            values.add(this.getValue(name));
        }
    }
}

