/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.Source;
import org.simantics.scl.compiler.top.StringSource;
import org.simantics.scl.runtime.SCLContext;

public enum GraphSourceLoader implements SCLSourceLoader
{
    INSTANCE;


    public Source locateSource(final String name) {
        if (!name.startsWith("http://")) {
            return null;
        }
        try {
            Object graph = SCLContext.getCurrent().get((Object)"graph");
            if (graph instanceof ReadGraph) {
                return GraphSourceLoader.locateSource((ReadGraph)graph, name);
            }
            return (Source)Simantics.getSession().syncRequest((Read)new Read<Source>(){

                public Source perform(ReadGraph graph) throws DatabaseException {
                    return GraphSourceLoader.locateSource(graph, name);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Source locateSource(ReadGraph graph, String name) throws DatabaseException {
        Resource moduleResource = graph.getPossibleResource(name);
        if (moduleResource == null) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(moduleResource, L0.SCLModule)) {
            return null;
        }
        String text = (String)graph.getRelatedValue(moduleResource, L0.SCLModule_definition);
        return new StringSource(name, text);
    }
}

