/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.rules;

import gnu.trove.THashSet;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.structural.stubs.StructuralResource2;

public class RelatedDiagramConnections {
    ReadGraph g;
    StructuralResource2 sr;
    DiagramResource dr;
    THashSet<Resource> connections = new THashSet();
    THashSet<Resource> connectionJoins = new THashSet();

    public RelatedDiagramConnections(ReadGraph g) {
        this.g = g;
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.dr = DiagramResource.getInstance((ReadGraph)g);
    }

    public void addConnection(Resource connection) throws DatabaseException {
        if (this.connections.add((Object)connection)) {
            for (Resource connector : this.g.getObjects(connection, this.dr.HasConnector)) {
                for (Resource flag : this.g.getObjects(connector, this.sr.Connects)) {
                    if (!this.g.isInstanceOf(flag, this.dr.Flag)) continue;
                    for (Resource join : this.g.getObjects(flag, this.dr.FlagIsJoinedBy)) {
                        this.addConnectionJoin(join);
                    }
                }
            }
        }
    }

    public void addConnectionJoin(Resource join) throws DatabaseException {
        if (this.connectionJoins.add((Object)join)) {
            for (Resource flag : this.g.getObjects(join, this.dr.JoinsFlag)) {
                for (Resource connector : this.g.getObjects(flag, this.sr.IsConnectedTo)) {
                    for (Resource connection : this.g.getObjects(connector, this.dr.IsConnectorOf)) {
                        this.addConnection(connection);
                    }
                }
            }
        }
    }

    public static Collection<Resource> getRelatedDiagramConnections(ReadGraph g, Resource connection) throws DatabaseException {
        RelatedDiagramConnections p = new RelatedDiagramConnections(g);
        p.addConnection(connection);
        return p.connections;
    }
}

