/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.rules.IMapping;
import org.simantics.structural2.modelingRules.CPConnection;
import org.simantics.structural2.modelingRules.CPConnectionJoin;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IConnectionPoint;

public class Mapping
implements IMapping {
    Resource componentMap;
    Resource connectionMap;
    Resource invConnectionMap;
    Resource componentTypeMap;
    Resource connectionRelationMap;

    public Mapping(ReadGraph g) throws DatabaseException {
        this.initializeRelations(g);
    }

    protected void initializeRelations(ReadGraph g) throws DatabaseException {
        this.componentMap = g.getResource("http://www.simantics.org/Modeling-1.2/ElementToComponent");
        this.connectionMap = g.getResource("http://www.simantics.org/Modeling-1.2/DiagramConnectionToConnection");
        this.invConnectionMap = g.getResource("http://www.simantics.org/Modeling-1.2/ConnectionToDiagramConnection");
        this.componentTypeMap = g.getResource("http://www.simantics.org/Modeling-1.2/SymbolToComponentType");
        this.connectionRelationMap = g.getResource("http://www.simantics.org/Modeling-1.2/DiagramConnectionRelationToConnectionRelation");
    }

    @Override
    public Resource mapComponentType(ReadGraph g, Resource componentType) throws DatabaseException {
        return g.getPossibleObject(componentType, this.componentTypeMap);
    }

    @Override
    public Resource mapConnection(ReadGraph g, Resource connection) throws DatabaseException {
        return g.getPossibleObject(connection, this.connectionMap);
    }

    @Override
    public Resource invMapConnection(WriteGraph g, Resource connection) throws DatabaseException {
        return g.getPossibleObject(connection, this.invConnectionMap);
    }

    @Override
    public Resource mapConnectionRelation(ReadGraph g, Resource relation) throws DatabaseException {
        return g.getPossibleObject(relation, this.connectionRelationMap);
    }

    @Override
    public Resource mapComponent(ReadGraph g, Resource component) throws DatabaseException {
        return g.getPossibleObject(component, this.componentMap);
    }

    @Override
    public IConnectionPoint mapConnectionPoint(ReadGraph g, IConnectionPoint cp) throws DatabaseException {
        if (cp instanceof CPConnection) {
            CPConnection ccp = (CPConnection)cp;
            Resource connection = this.mapConnection(g, ccp.connection);
            if (connection == null) {
                return null;
            }
            return new CPConnection(connection);
        }
        if (cp instanceof CPTerminal) {
            return this.mapCPTerminal(g, (CPTerminal)cp);
        }
        if (cp instanceof CPConnectionJoin) {
            return cp;
        }
        return null;
    }

    protected IConnectionPoint mapCPTerminal(ReadGraph g, CPTerminal ccp) throws DatabaseException {
        Resource component = this.mapComponent(g, ccp.component);
        if (component == null) {
            return null;
        }
        Resource connectionRelation = this.mapConnectionRelation(g, ccp.relation);
        if (connectionRelation == null) {
            return null;
        }
        return new CPTerminal(component, connectionRelation);
    }
}

