/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.jface.viewers.IFilter;
import org.simantics.db.Resource;
import org.simantics.modeling.requests.Node;

public class CollectionResult {
    public final Set<Node> roots = new ConcurrentSkipListSet<Node>();
    private final Set<Node> diagramSet = new ConcurrentSkipListSet<Node>();
    public final List<Node> diagramList = new Vector<Node>();
    public final Map<Resource, Node> diagrams = new ConcurrentHashMap<Resource, Node>();

    public void addDiagram(Resource r, Node n) {
        this.diagramList.add(n);
        this.diagrams.put(r, n);
        this.diagramSet.add(n);
    }

    public Collection<Node> breadthFirstFlatten() {
        return this.breadthFirstFlatten(null);
    }

    public Collection<Node> breadthFirstFlatten(IFilter filter) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<Node> sortedRoots = new ArrayList<Node>(this.roots);
        Collections.sort(sortedRoots);
        ArrayDeque<Node> todo = new ArrayDeque<Node>(sortedRoots);
        while (!todo.isEmpty()) {
            Node n = (Node)todo.removeFirst();
            ArrayList<Node> sorted = new ArrayList<Node>(n.getChildren());
            Collections.sort(sorted);
            todo.addAll(sorted);
            if (!this.diagramSet.contains(n) || filter != null && !filter.select((Object)n)) continue;
            result.add(n);
        }
        return result;
    }

    public Collection<Node> depthFirstFlatten() {
        return this.depthFirstFlatten(null, null);
    }

    public Collection<Node> depthFirstFlatten(IFilter filter, Comparator<? super Node> comparator) {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayList<Node> sortedRoots = new ArrayList<Node>(this.roots);
        Collections.sort(sortedRoots, comparator);
        for (Node n : sortedRoots) {
            this.depthFirstFlattenRec(filter, comparator, n, result);
        }
        return result;
    }

    private Collection<Node> depthFirstFlattenRec(IFilter filter, Comparator<? super Node> comparator, Node n, Collection<Node> result) {
        Collection<Node> children;
        if (this.diagramSet.contains(n) && (filter == null || filter.select((Object)n))) {
            result.add(n);
        }
        if ((children = n.getChildren()).isEmpty()) {
            return result;
        }
        ArrayList<Node> sorted = new ArrayList<Node>(children);
        Collections.sort(sorted, comparator);
        for (Node child : sorted) {
            this.depthFirstFlattenRec(filter, comparator, child, result);
        }
        return result;
    }
}

