/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.ArrayDeque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.NameLabelUtil;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.page.PageDesc;

public class CollectionRequest
implements Read<CollectionResult> {
    private static final boolean DEBUG = false;
    IProgressMonitor monitor;
    PageDesc defaultPageDesc;
    Resource[] input;
    ReadGraph g;
    Layer0 l0;
    StructuralResource2 sr;
    DiagramResource dr;
    ModelingResources mr;
    SimulationResource SIMU;

    public CollectionRequest(IProgressMonitor monitor, PageDesc defaultPageDesc, Resource ... input) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.defaultPageDesc = defaultPageDesc;
        this.input = input;
    }

    String safeGetName(Resource r) throws DatabaseException {
        return (String)this.g.syncRequest((Read)new GetName(r));
    }

    public CollectionResult perform(ReadGraph g) throws DatabaseException {
        this.g = g;
        this.l0 = Layer0.getInstance((ReadGraph)g);
        this.dr = DiagramResource.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.mr = ModelingResources.getInstance((ReadGraph)g);
        this.SIMU = SimulationResource.getInstance((ReadGraph)g);
        final CollectionResult result = new CollectionResult();
        final ArrayDeque<Node> roots = new ArrayDeque<Node>();
        Resource[] resourceArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            Node node;
            Resource composite;
            Resource r = resourceArray[n2];
            if (g.isInstanceOf(r, this.SIMU.Model)) {
                Resource diagram;
                composite = g.getPossibleObject(r, this.SIMU.HasConfiguration);
                Resource resource = diagram = composite != null ? g.getPossibleObject(composite, this.mr.CompositeToDiagram) : null;
                if (composite != null) {
                    Node node2 = new Node(null, this.safeGetName(r), diagram, composite, r);
                    roots.add(node2);
                    result.roots.add((Node)roots.peekLast());
                }
            } else if (g.isInstanceOf(r, this.sr.Composite)) {
                String name = null;
                Resource model = g.getPossibleObject(r, this.SIMU.IsConfigurationOf);
                name = model != null ? this.safeGetName(model) : this.safeGetName(r);
                Resource diagram = g.getPossibleObject(r, this.mr.CompositeToDiagram);
                diagram = diagram != null && g.isInstanceOf(diagram, this.dr.Composite) ? diagram : null;
                node = new Node(null, name, diagram, r);
                roots.add(node);
                result.roots.add((Node)roots.peekLast());
            } else if (g.isInheritedFrom(r, this.dr.DefinedElement)) {
                composite = g.getPossibleObject(r, this.sr.IsDefinedBy);
                Resource resource = composite = composite != null && g.isInstanceOf(composite, this.dr.Composite) ? composite : null;
                if (composite != null) {
                    Resource componentType = g.getPossibleObject(r, this.mr.SymbolToComponentType);
                    String name = this.safeGetName(componentType);
                    name = String.valueOf(name) + " Symbol";
                    node = new Node(null, name, composite, r);
                    roots.add(node);
                    result.roots.add((Node)roots.peekLast());
                }
            }
            ++n2;
        }
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)this.monitor);
        g.syncRequest((AsyncRead)new AsyncReadRequest(){

            public void run(AsyncReadGraph graph) {
                for (Node node : roots) {
                    this.loadComposites(graph, node);
                }
            }

            private void loadComposites(AsyncReadGraph graph, final Node node) {
                Resource diagram = node.getDiagramResource();
                if (diagram != null) {
                    result.addDiagram(diagram, node);
                }
                mon.setWorkRemaining(1000);
                this.forComposites(graph, node.getDefiningResources().resources[0], (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){

                    public void execute(AsyncReadGraph graph, final Resource composite) {
                        if (mon.isCanceled()) {
                            return;
                        }
                        graph.asyncRequest((Read)new GetName(composite), (AsyncProcedure)new AsyncProcedureAdapter<String>(){

                            public void execute(AsyncReadGraph graph, final String compositeName) {
                                graph.forPossibleObject(composite, ((this).this).CollectionRequest.this.mr.CompositeToDiagram, (AsyncProcedure)new AsyncProcedureAdapter<Resource>(){

                                    public void execute(AsyncReadGraph graph, Resource definingDiagram) {
                                        Node n = new Node(node, compositeName, definingDiagram, composite);
                                        this.loadComposites(graph, n);
                                        mon.worked(1);
                                    }
                                });
                            }
                        });
                    }
                });
            }

            private void forComposites(AsyncReadGraph graph, Resource resource, final AsyncMultiProcedure<Resource> procedure) {
                graph.forEachObject(resource, CollectionRequest.this.l0.ConsistsOf, (AsyncMultiProcedure)new AsyncMultiProcedureAdapter<Resource>(){

                    public void execute(AsyncReadGraph graph, final Resource component) {
                        graph.forIsInstanceOf(component, (this).CollectionRequest.this.sr.Composite, (AsyncProcedure)new AsyncProcedureAdapter<Boolean>(){

                            public void execute(AsyncReadGraph graph, Boolean isComposite) {
                                if (Boolean.TRUE.equals(isComposite)) {
                                    procedure.execute(graph, (Object)component);
                                }
                            }
                        });
                    }

                    public void finished(AsyncReadGraph graph) {
                        procedure.finished(graph);
                    }
                });
            }
        });
        for (Node node : result.diagramList) {
            if (this.monitor.isCanceled()) {
                return null;
            }
            mon.setWorkRemaining(10000);
            PageDesc realPageDesc = (PageDesc)g.syncRequest(DiagramRequests.getPageDesc((Resource)node.getDiagramResource(), (PageDesc)this.defaultPageDesc));
            node.setPageDesc(realPageDesc);
            mon.worked(1);
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        return result;
    }

    static class GetName
    extends ResourceRead<String> {
        public GetName(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            try {
                return NameLabelUtil.modalName((ReadGraph)graph, (Resource)this.resource);
            }
            catch (AdaptionException e) {
                return NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource);
            }
        }
    }
}

