/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicateAdapter;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.InversePredicate;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.layer0.utils.predicates.Negation;
import org.simantics.layer0.utils.predicates.Type;
import org.simantics.layer0.utils.predicates.UnaryTest;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.DiagramConnectionExistence;
import org.simantics.modeling.mapping.MappingBase;
import org.simantics.modeling.mapping.NamingCreationInstruction;
import org.simantics.modeling.mapping.Tag;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ObjectUtils;

public class DiagramToCompositeMapping3
extends MappingBase {
    public static int VARIABLE_COUNT = 0;
    protected static final int Diagram = VARIABLE_COUNT++;
    protected static final int Configuration = VARIABLE_COUNT++;
    protected static final int Element = VARIABLE_COUNT++;
    protected static final int ElementType = VARIABLE_COUNT++;
    protected static final int ComponentType = VARIABLE_COUNT++;
    protected static final int Component = VARIABLE_COUNT++;
    protected static final int DiagramConnectionRelation = VARIABLE_COUNT++;
    protected static final int DiagramConnectionRelation2 = VARIABLE_COUNT++;
    protected static final int CElement = VARIABLE_COUNT++;
    protected static final int ConnectionRelation = VARIABLE_COUNT++;
    protected static final int Connector = VARIABLE_COUNT++;
    protected static final int Connection = VARIABLE_COUNT++;
    protected static final int Connection2 = VARIABLE_COUNT++;
    protected static final int ConnectionType = VARIABLE_COUNT++;
    protected static final int ConnectionRelation2 = VARIABLE_COUNT++;
    protected static final int ConnectionRelation3 = VARIABLE_COUNT++;
    protected static final int Component2 = VARIABLE_COUNT++;
    protected static final int FlagType = VARIABLE_COUNT++;
    protected static final int ConnectionDirection = VARIABLE_COUNT++;
    protected static final int ConnectionJoin = VARIABLE_COUNT++;
    protected static final int ConfigurationRoot = VARIABLE_COUNT++;
    protected static final int Join = VARIABLE_COUNT++;
    protected Session session;
    protected Layer0 L0;
    protected DiagramResource DIA;
    protected ModelingResources MOD;
    protected StructuralResource2 STR;
    protected IUnaryPredicate mapped;
    protected IUnaryPredicate mappedFromConnector;
    protected IUnaryPredicate external;
    protected IUnaryPredicate inputFlag;
    protected IUnaryPredicate hasOutputConnector;
    protected IUnaryPredicate flagIsConnected;
    protected IUnaryPredicate internalJoin;
    protected IBinaryPredicate fromFlagToConnection;
    IRuleInstruction instruction;
    public Resource source;
    public Resource target;
    protected IProject project;
    protected Resource configurationRoot;

    IRuleInstruction createMappingRule() throws DatabaseException {
        this.L0 = Layer0.getInstance((RequestProcessor)this.session);
        this.DIA = DiagramResource.getInstance((RequestProcessor)this.session);
        this.MOD = ModelingResources.getInstance((RequestProcessor)this.session);
        this.STR = StructuralResource2.getInstance((RequestProcessor)this.session);
        this.mapped = new Tag(this.MOD.Mapped);
        this.mappedFromConnector = new Tag(this.MOD.MappedFromConnector);
        this.external = new Tag(this.DIA.ExternalFlag);
        this.inputFlag = new UnaryTest(){

            public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
                return g.hasStatement(resource, DiagramToCompositeMapping3.this.DIA.HasFlagType, DiagramToCompositeMapping3.this.DIA.FlagType_InputFlag);
            }
        };
        this.hasOutputConnector = new UnaryTest(){

            public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
                Resource connection = g.getPossibleObject(resource, DiagramToCompositeMapping3.this.MOD.DiagramConnectionToConnection);
                if (connection == null) {
                    return false;
                }
                if (g.hasStatement(connection, DiagramToCompositeMapping3.this.STR.Binds)) {
                    return false;
                }
                for (Resource join : g.getObjects(connection, DiagramToCompositeMapping3.this.STR.IsJoinedBy)) {
                    for (Resource connection2 : g.getObjects(join, DiagramToCompositeMapping3.this.STR.Joins)) {
                        if (connection.equals(connection2) || !g.hasStatement(connection, DiagramToCompositeMapping3.this.STR.Binds)) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        this.flagIsConnected = new UnaryTest(){

            public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
                return g.hasStatement(resource, DiagramToCompositeMapping3.this.DIA.Flag_ConnectionPoint);
            }
        };
        this.internalJoin = new UnaryTest(){

            public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
                return g.getObjects(resource, DiagramToCompositeMapping3.this.STR.JoinsComposite).size() <= 1;
            }
        };
        this.fromFlagToConnection = new BinaryPredicateAdapter(){

            public boolean supportsGetObjects() {
                return true;
            }

            public Collection<Resource> getObjects(ReadGraph g, Resource flag) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>(2);
                for (Resource connector : g.getObjects(flag, DiagramToCompositeMapping3.this.DIA.Flag_ConnectionPoint)) {
                    for (Resource routeGraph : g.getObjects(connector, DiagramToCompositeMapping3.this.DIA.IsConnectorOf)) {
                        if (flag.equals(routeGraph)) continue;
                        result.addAll(g.getObjects(routeGraph, DiagramToCompositeMapping3.this.MOD.DiagramConnectionToConnection));
                    }
                }
                return result;
            }
        };
        return DiagramToCompositeMapping3.and(this.destructiveRule(), this.additiveRule());
    }

    public TypedBracketInstruction.CreationInstruction componentCreationInstruction(int component, int componentType, int configuration) {
        return new NamingCreationInstruction(this.project, ConfigurationRoot, component, componentType, configuration);
    }

    protected IRuleInstruction additiveRule() {
        return DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.bf((IBinaryPredicate)OrderedSetElementsPredicate.INSTANCE, Diagram, Element), DiagramToCompositeMapping3.query(DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.L0.InstanceOf, Element, ElementType), DiagramToCompositeMapping3.bf(this.MOD.SymbolToComponentType, ElementType, ComponentType)), this.createComponentRule(), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.b(this.DIA.Connection, Element), this.createNormalConnectionRule(), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.b(this.DIA.Flag, Element), this.createFlagRule())))));
    }

    protected IRuleInstruction destructiveRule() {
        return DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.bf(this.L0.ConsistsOf, Configuration, Component), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.b(this.mapped, Component), DiagramToCompositeMapping3.query(DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.ComponentToElement, Component, Element), DiagramToCompositeMapping3.bf((IBinaryPredicate)new InversePredicate((IBinaryPredicate)OrderedSetElementsPredicate.INSTANCE), Element, Diagram), DiagramToCompositeMapping3.b(DiagramToCompositeMapping3.implies((IUnaryPredicate)new Type(this.DIA.Flag), DiagramToCompositeMapping3.and(this.external, this.flagIsConnected)), Element), DiagramToCompositeMapping3.b(DiagramToCompositeMapping3.implies((IUnaryPredicate)new Type(this.DIA.Connection), this.hasOutputConnector), Element)), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.statement_bff(Component, ConnectionRelation, Connection, this.STR.IsConnectedTo), DiagramToCompositeMapping3.b(this.mapped, Connection)), this.destructiveConnectionRule()), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ComponentToElement), Component)), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.exists(Component)))))), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.b(this.mappedFromConnector, Component), DiagramToCompositeMapping3.query(DiagramToCompositeMapping3.unless(DiagramToCompositeMapping3.bf(this.MOD.ComponentToConnector, Component, Connector), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ComponentToElement), Component)), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.exists(Component)))))))), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.STR.HasConnectionJoin, Configuration, Join), DiagramToCompositeMapping3.b(this.internalJoin, Join), DiagramToCompositeMapping3.bf(this.STR.Joins, Join, Connection), DiagramToCompositeMapping3.b(this.mapped, Connection)), DiagramToCompositeMapping3.unless(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.ConnectionMapsTo, Connection, Connection2), DiagramToCompositeMapping3.or(DiagramToCompositeMapping3.b((IUnaryPredicate)new Negation((IUnaryPredicate)new Tag(this.MOD.ConnectionToDiagramConnectionSpecial)), Connection), DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ElementToComponent), Connection2))), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ConnectionMapsTo), Connection)), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.exists(Connection))))), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.STR.HasConnectionJoin, Configuration, Join), DiagramToCompositeMapping3.bf(this.STR.Joins, Join, Connection), DiagramToCompositeMapping3.b(this.mapped, Connection), DiagramToCompositeMapping3.b(DiagramToCompositeMapping3.not((IUnaryPredicate)new Tag(this.STR.Connects)), Connection), DiagramToCompositeMapping3.b(DiagramToCompositeMapping3.not((IUnaryPredicate)new Tag(this.MOD.ConnectionMapsTo)), Connection)), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.exists(Connection))));
    }

    protected IRuleInstruction destructiveConnectionRule() {
        return DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.ConnectionMapsTo, Connection, Connection2), DiagramToCompositeMapping3.or(DiagramToCompositeMapping3.b((IUnaryPredicate)new Negation((IUnaryPredicate)new Tag(this.MOD.ConnectionToDiagramConnectionSpecial)), Connection), DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ElementToComponent), Connection2))), DiagramToCompositeMapping3.unless(DiagramToCompositeMapping3.or(new IInstruction[]{new DiagramConnectionExistence(Element, ConnectionRelation, Connection2), DiagramToCompositeMapping3.b(this.DIA.Connection, Element), DiagramToCompositeMapping3.b(this.DIA.Flag, Element), DiagramToCompositeMapping3.b((IUnaryPredicate)new Negation((IUnaryPredicate)new Tag(this.MOD.ConnectionRelationToDiagramConnectionRelation)), ConnectionRelation), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.fb(this.MOD.HasReferenceRelation, CElement, ConnectionRelation), DiagramToCompositeMapping3.bb(this.MOD.HasParentComponent, CElement, Component))}), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.statement(Component, ConnectionRelation, Connection))), DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.b((IUnaryPredicate)new Tag(this.MOD.ConnectionMapsTo), Connection)), DiagramToCompositeMapping3.deny(DiagramToCompositeMapping3.exists(Connection))));
    }

    protected IRuleInstruction createComponentRule() {
        return DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.exists(DiagramToCompositeMapping3.bf(this.MOD.ElementToComponent, Element, Component), this.componentCreationInstruction(Component, ComponentType, Configuration)), DiagramToCompositeMapping3.bb(this.L0.InstanceOf, Component, ComponentType), DiagramToCompositeMapping3.bb(this.L0.PartOf, Component, Configuration), DiagramToCompositeMapping3.b(this.mapped, Component));
    }

    IRuleInstruction createConnectionRule() {
        return DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.b(this.DIA.Connection, Element), this.createNormalConnectionRule());
    }

    protected Resource getConfigurationConnectionType() {
        return this.STR.Connection;
    }

    protected IInstruction claimBasicConnection() {
        return DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.exists(DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionToConnection, Element, Connection), Connection), DiagramToCompositeMapping3.b(this.getConfigurationConnectionType(), Connection), DiagramToCompositeMapping3.b(this.mapped, Connection));
    }

    protected IRuleInstruction createNormalConnectionRule() {
        return DiagramToCompositeMapping3.claim(this.claimBasicConnection(), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.STR.IsConnectedTo, Element, Connector), DiagramToCompositeMapping3.statement_ffb(CElement, DiagramConnectionRelation, Connector, this.STR.IsConnectedTo)), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionRelationToConnectionRelation, DiagramConnectionRelation, ConnectionRelation), DiagramToCompositeMapping3.bf(this.MOD.ElementToComponent, CElement, Component)), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionRelationToConnectionRelationB, DiagramConnectionRelation, ConnectionRelation2), DiagramToCompositeMapping3.b(this.hasOutputConnector, Element), DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionRelationToConnectionRelationC, DiagramConnectionRelation, ConnectionRelation3), DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionRelationToComponentType, DiagramConnectionRelation, ComponentType)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.exists(DiagramToCompositeMapping3.bf(this.MOD.ElementToComponent, Element, Component2), new NamingCreationInstruction(this.project, ConfigurationRoot, Component2, ComponentType, Configuration)), DiagramToCompositeMapping3.bb(this.L0.InstanceOf, Component2, ComponentType), DiagramToCompositeMapping3.bb(this.L0.PartOf, Component2, Configuration), DiagramToCompositeMapping3.bb(this.MOD.ConnectorToComponent, Connector, Component2), DiagramToCompositeMapping3.b(this.mappedFromConnector, Component2), DiagramToCompositeMapping3.exists(DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionToConnectionSpecial, Element, Connection2), Connection2), DiagramToCompositeMapping3.statement(Component2, ConnectionRelation2, Connection2), DiagramToCompositeMapping3.statement(Component, ConnectionRelation, Connection2), DiagramToCompositeMapping3.b(this.getConfigurationConnectionType(), Connection2), DiagramToCompositeMapping3.b(this.mapped, Connection2), DiagramToCompositeMapping3.statement(Component2, ConnectionRelation3, Connection)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.statement(Component, ConnectionRelation, Connection))), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.MOD.HasParentComponent, CElement, Component), DiagramToCompositeMapping3.bf(this.MOD.HasReferenceRelation, CElement, ConnectionRelation)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.statement(Component, ConnectionRelation, Connection))))));
    }

    protected IRuleInstruction createFlagRule() {
        return DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.DIA.FlagIsJoinedBy, Element, ConnectionJoin), DiagramToCompositeMapping3.bf(DiagramToCompositeMapping3.compose(this.STR.IsConnectedTo, this.STR.Connects, this.MOD.DiagramConnectionToConnection), Element, Connection)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.bb(this.STR.Joins, ConnectionJoin, Connection), DiagramToCompositeMapping3.bb(this.STR.HasConnectionJoin, Configuration, ConnectionJoin)), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.b(DiagramToCompositeMapping3.and(this.external, this.inputFlag, this.flagIsConnected), Element), DiagramToCompositeMapping3.bf(DiagramToCompositeMapping3.compose(this.STR.IsConnectedTo, this.STR.Connects), Element, Connection2), DiagramToCompositeMapping3.bf(this.MOD.DiagramConnectionToConnection, Connection2, Connection), DiagramToCompositeMapping3.bf(this.STR.HasConnectionType, Connection2, ConnectionType), DiagramToCompositeMapping3.bf(this.MOD.ConnectionTypeToComponentType, ConnectionType, ComponentType), DiagramToCompositeMapping3.bf(this.MOD.ConnectionTypeToConnectionRelation, ConnectionType, ConnectionRelation)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.exists(DiagramToCompositeMapping3.bf(this.MOD.ElementToComponent, Element, Component), new NamingCreationInstruction(this.project, ConfigurationRoot, Component, ComponentType, Configuration)), DiagramToCompositeMapping3.bb(this.L0.InstanceOf, Component, ComponentType), DiagramToCompositeMapping3.bb(this.L0.PartOf, Component, Configuration), DiagramToCompositeMapping3.b(this.mapped, Component), DiagramToCompositeMapping3.statement(Component, ConnectionRelation, Connection)))), DiagramToCompositeMapping3.if_(DiagramToCompositeMapping3.and(DiagramToCompositeMapping3.bf(this.DIA.IsLiftedAs, Element, ConnectionRelation), DiagramToCompositeMapping3.bf(this.fromFlagToConnection, Element, Connection)), DiagramToCompositeMapping3.claim(DiagramToCompositeMapping3.bb(this.STR.Binds, Connection, ConnectionRelation))));
    }

    protected void setup(ReadGraph graph) {
    }

    public DiagramToCompositeMapping3(ReadGraph g, Resource mapping) throws DatabaseException {
        this.setup(g);
        this.session = g.getSession();
        this.source = g.getPossibleObject(mapping, g.getInverse(Layer0X.getInstance((ReadGraph)g).HasTrigger));
        if (this.source != null) {
            this.target = g.getPossibleObject(this.source, ModelingResources.getInstance((ReadGraph)g).DiagramToComposite);
        }
        if (this.target != null) {
            this.configurationRoot = ComponentUtils.getCompositeConfigurationRoot(g, this.target);
            assert (this.configurationRoot != null);
        }
        this.project = Simantics.peekProject();
        this.instruction = (IRuleInstruction)g.syncRequest((Read)new RuleQuery());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DiagramToCompositeMapping3)) {
            return false;
        }
        DiagramToCompositeMapping3 map = (DiagramToCompositeMapping3)((Object)other);
        return ObjectUtils.objectEquals((Object)map.source, (Object)this.source) && ObjectUtils.objectEquals((Object)map.target, (Object)this.target);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.source) + 31 * ObjectUtils.hashCode((Object)this.target);
    }

    public IModification perform(ReadGraph g) throws DatabaseException {
        if (this.source == null || this.target == null) {
            return null;
        }
        Object[] bindings = new Object[VARIABLE_COUNT];
        bindings[DiagramToCompositeMapping3.Diagram] = this.source;
        bindings[DiagramToCompositeMapping3.Configuration] = this.target;
        bindings[DiagramToCompositeMapping3.ConfigurationRoot] = this.configurationRoot;
        IModification modi = this.instruction.execute(g, bindings);
        return modi;
    }

    class RuleQuery
    implements Read<IRuleInstruction> {
        RuleQuery() {
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == RuleQuery.class && this.getParentClass().equals(((RuleQuery)other).getParentClass());
        }

        private Class<? extends DiagramToCompositeMapping3> getParentClass() {
            return ((Object)((Object)DiagramToCompositeMapping3.this)).getClass();
        }

        public int hashCode() {
            return ((Object)((Object)DiagramToCompositeMapping3.this)).getClass().hashCode();
        }

        public IRuleInstruction perform(ReadGraph g) {
            try {
                return DiagramToCompositeMapping3.this.createMappingRule();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

