/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.flags;

import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.utils.ObjectUtils;

public class LiftFlag {
    private static final boolean DEBUG = false;

    public static String liftFlag(WriteGraph g, Resource flag) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        if (g.hasStatement(flag, STR.IsJoinedBy)) {
            return "Flag is already connected to other flag.";
        }
        if (g.hasStatement(flag, DIA.IsLiftedAs)) {
            return "Flag is already lifted.";
        }
        Resource connection = LiftFlag.findConfigurationConnection((ReadGraph)g, flag);
        if (connection == null) {
            return "Couldn't find configuration connection.";
        }
        LiftedConnectionPoint lcp = LiftFlag.calculateLiftedConnectionPointForConnection((ReadGraph)g, connection);
        if (lcp.component == null) {
            return "Didn't find a component where the flag is connected to.";
        }
        if (lcp.componentType == null) {
            return "Didn't find an enclosing user component.";
        }
        String newName = LiftFlag.generateTerminalName((ReadGraph)g, lcp);
        newName = NameUtils.findFreshName((ReadGraph)g, (String)newName, (Resource)lcp.componentType);
        Resource connectionPoint = g.newResource();
        Resource connectionPointInv = g.newResource();
        for (Resource superrelation : g.getObjects(lcp.connectionPoint, L0.SubrelationOf)) {
            g.claim(connectionPoint, L0.SubrelationOf, null, superrelation);
            g.claim(connectionPointInv, L0.SubrelationOf, null, g.getInverse(superrelation));
        }
        for (Resource type : g.getObjects(lcp.connectionPoint, L0.InstanceOf)) {
            g.claim(connectionPoint, L0.InstanceOf, null, type);
        }
        g.claim(connectionPoint, L0.InverseOf, connectionPointInv);
        g.claimLiteral(connectionPoint, L0.HasName, (Object)newName, (Binding)Bindings.STRING);
        g.claim(connectionPoint, L0.ConsistsOf, connectionPointInv);
        g.claimLiteral(connectionPointInv, L0.HasName, (Object)"Inverse", (Binding)Bindings.STRING);
        g.claim(connectionPoint, L0.HasDomain, lcp.componentType);
        for (Statement terminalStm : g.getStatements(lcp.connectionPoint, MOD.ConnectionRelationToTerminal)) {
            if (terminalStm.isAsserted(lcp.connectionPoint)) continue;
            g.claim(connectionPoint, MOD.ConnectionRelationToTerminal, terminalStm.getObject());
        }
        StructuralUtils.addConnectionPoint((WriteGraph)g, (Resource)lcp.componentType, (Resource)connectionPoint);
        g.claim(flag, DIA.IsLiftedAs, connectionPoint);
        g.claim(connection, STR.Binds, connectionPoint);
        if (lcp.attachmentRelation != null) {
            g.claim(connectionPoint, STR.HasAttachmentRelation, lcp.attachmentRelation);
        }
        g.claim(lcp.componentType, L0.ConsistsOf, connectionPoint);
        return null;
    }

    public static Resource findConfigurationConnection(ReadGraph g, Resource element) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        for (Resource connector : g.getObjects(element, STR.IsConnectedTo)) {
            Resource connection;
            Resource diagramConnection = ConnectionUtil.tryGetConnection((ReadGraph)g, (Resource)connector);
            if (diagramConnection != null && (connection = g.getPossibleObject(diagramConnection, MOD.DiagramConnectionToConnection)) != null) {
                return connection;
            }
            Resource mappedConnection = ConnectionUtil.tryGetMappedConnection((ReadGraph)g, (Resource)connector);
            if (mappedConnection == null) continue;
            return mappedConnection;
        }
        return null;
    }

    public static String generateTerminalName(ReadGraph g, LiftedConnectionPoint lcp) throws DatabaseException {
        String componentName = NameUtils.getSafeName((ReadGraph)g, (Resource)lcp.component);
        String cpName = NameUtils.getSafeName((ReadGraph)g, (Resource)lcp.connectionPoint);
        StringBuilder sb = new StringBuilder();
        if (componentName == null) {
            if (cpName == null) {
                sb.append("ConnectionPoint");
            } else {
                sb.append("Lifted").append(cpName);
            }
        } else if (cpName == null) {
            sb.append(componentName).append("Lifted");
        } else {
            sb.append(componentName).append("_").append(cpName);
        }
        return sb.toString();
    }

    public static LiftedConnectionPoint calculateLiftedConnectionPointForFlag(ReadGraph graph, Resource flag) throws DatabaseException {
        Resource connection = LiftFlag.findConfigurationConnection(graph, flag);
        return connection == null ? new LiftedConnectionPoint() : LiftFlag.calculateLiftedConnectionPointForConnection(graph, connection);
    }

    public static LiftedConnectionPoint calculateLiftedConnectionPointForConnection(ReadGraph graph, Resource connection) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        LiftedConnectionPoint result = new LiftedConnectionPoint();
        block0: for (Statement stat : graph.getStatements(connection, STR.Connects)) {
            result.component = stat.getObject();
            result.connectionPoint = graph.getInverse(stat.getPredicate());
            result.attachmentRelation = graph.getPossibleObject(result.connectionPoint, STR.HasAttachmentRelation);
            Resource connector = graph.getPossibleObject(result.component, MOD.ComponentToConnector);
            if (connector == null) continue;
            for (Statement s : graph.getStatements(connector, STR.Connects)) {
                Resource element = s.getObject();
                Resource diagramRelation = graph.getInverse(s.getPredicate());
                Resource componentCandidate = graph.getPossibleObject(element, MOD.ElementToComponent);
                Resource cpCandidate = graph.getPossibleObject(diagramRelation, MOD.DiagramConnectionRelationToConnectionRelation);
                if (componentCandidate == null || cpCandidate == null) continue;
                result.component = componentCandidate;
                result.connectionPoint = cpCandidate;
                result.attachmentRelation = graph.getPossibleObject(cpCandidate, STR.HasAttachmentRelation);
                if (result.attachmentRelation != null && graph.isSubrelationOf(result.attachmentRelation, DIA.HasTailConnector)) break block0;
            }
        }
        Resource componentType = null;
        Resource curComponent = result.component;
        do {
            if ((componentType = graph.getPossibleObject(curComponent, STR.Defines)) == null) continue;
            result.componentType = componentType;
            break;
        } while ((curComponent = graph.getPossibleObject(curComponent, L0.PartOf)) != null);
        return result;
    }

    public static String isConnectionPointValid(ReadGraph graph, Resource componentType, Resource connectionPoint, LiftedConnectionPoint proper) throws DatabaseException {
        THashSet properTypes;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource existingHasAttachment = graph.getPossibleObject(connectionPoint, STR.HasAttachmentRelation);
        if (!ObjectUtils.objectEquals((Object)existingHasAttachment, (Object)proper.attachmentRelation)) {
            return "Wrong connection point (" + connectionPoint + ") attachment relation: is " + existingHasAttachment + ", should be " + proper.attachmentRelation;
        }
        THashSet existingTypes = new THashSet(graph.getObjects(connectionPoint, L0.InstanceOf));
        if (!existingTypes.equals(properTypes = new THashSet(proper.connectionPoint != null ? graph.getObjects(proper.connectionPoint, L0.InstanceOf) : Collections.emptySet()))) {
            return "Incorrect connection point relation (" + connectionPoint + ") types (existing " + existingTypes + " vs. proper " + properTypes + ")";
        }
        Resource diagramConnectionPoint = graph.getPossibleObject(connectionPoint, MOD.ConnectionRelationToDiagramConnectionRelation);
        if (diagramConnectionPoint != null) {
            THashSet properTypes2;
            THashSet existingTypes2 = new THashSet(graph.getObjects(diagramConnectionPoint, L0.InstanceOf));
            if (!existingTypes2.equals(properTypes2 = new THashSet(proper.connectionPoint != null ? graph.getObjects(proper.connectionPoint, MOD.ImpliesDiagramConnectionRelationType) : Collections.emptySet()))) {
                return "Incorrect diagram connection point relation (" + diagramConnectionPoint + ") types (existing " + existingTypes2 + " vs. proper " + properTypes2 + ")";
            }
            THashSet properTerminalTypes = new THashSet(graph.getObjects(connectionPoint, MOD.ConnectionRelationToTerminal));
            for (Resource terminal : graph.getObjects(diagramConnectionPoint, DIA.HasConnectionPoint_Inverse)) {
                THashSet existingTerminalTypes = new THashSet(graph.getObjects(terminal, L0.InstanceOf));
                if (existingTerminalTypes.equals(properTerminalTypes)) continue;
                return "Incorrect diagram connection point relation types (existing " + existingTypes2 + " vs. proper " + properTypes2 + ")";
            }
        }
        return null;
    }

    public static String validateConnectionPoint(WriteGraph graph, Resource componentType, Resource connectionPoint, LiftedConnectionPoint proper) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource existingHasAttachment = graph.getPossibleObject(connectionPoint, STR.HasAttachmentRelation);
        if (!ObjectUtils.objectEquals((Object)existingHasAttachment, (Object)proper.attachmentRelation)) {
            graph.deny(connectionPoint, STR.HasAttachmentRelation);
            if (proper.attachmentRelation != null) {
                graph.claim(connectionPoint, STR.HasAttachmentRelation, proper.attachmentRelation);
            }
        }
        LiftFlag.fixDirectTypes(graph, connectionPoint, (Set<Resource>)(proper.connectionPoint != null ? new THashSet(graph.getObjects(proper.connectionPoint, L0.InstanceOf)) : Collections.emptySet()));
        Resource diagramConnectionPoint = graph.getPossibleObject(connectionPoint, MOD.ConnectionRelationToDiagramConnectionRelation);
        if (diagramConnectionPoint != null) {
            LiftFlag.fixDirectTypes(graph, diagramConnectionPoint, (Set<Resource>)(proper.connectionPoint != null ? new THashSet(graph.getObjects(proper.connectionPoint, MOD.ImpliesDiagramConnectionRelationType)) : Collections.emptySet()));
            THashSet properTerminalTypes = new THashSet(graph.getObjects(connectionPoint, MOD.ConnectionRelationToTerminal));
            for (Resource terminal : graph.getObjects(diagramConnectionPoint, DIA.HasConnectionPoint_Inverse)) {
                LiftFlag.fixDirectTypes(graph, terminal, (Set<Resource>)properTerminalTypes);
            }
        }
        return null;
    }

    private static void fixDirectTypes(WriteGraph graph, Resource r, Set<Resource> properTypes) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        THashSet existingTypes = new THashSet(graph.getObjects(r, L0.InstanceOf));
        if (!existingTypes.equals(properTypes)) {
            THashSet addTypes = new THashSet(properTypes);
            properTypes.removeAll((Collection<?>)existingTypes);
            existingTypes.removeAll(properTypes);
            for (Resource remove : existingTypes) {
                graph.deny(r, L0.InstanceOf, remove);
            }
            for (Resource add : addTypes) {
                graph.claim(r, L0.InstanceOf, null, add);
            }
        }
    }

    public static class LiftedConnectionPoint
    extends Bean {
        @Optional
        public Resource component;
        @Optional
        public Resource componentType;
        @Optional
        public Resource connectionPoint;
        @Optional
        public Resource attachmentRelation;
    }
}

