/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.flags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;

public class ExpandFlags {
    private static ArrayList<Connector> getConnectors(ReadGraph g, Resource connection) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ArrayList<Connector> result = new ArrayList<Connector>();
        for (Resource connector : g.getObjects(connection, STR.IsConnectedTo)) {
            for (Statement stat : g.getStatements(connector, STR.Connects)) {
                if (connection.equals(stat.getObject())) continue;
                result.add(new Connector(stat.getObject(), g.getInverse(stat.getPredicate())));
            }
        }
        return result;
    }

    public static Resource[] expandFlag(WriteGraph graph, Resource flag) throws DatabaseException {
        return (Resource[])Commands.get((ReadGraph)graph, (String)"Simantics/Flag/expandFlag").execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(flag)), new Object[]{flag});
    }

    public static Resource[] expandFlagWithoutMetadata(WriteGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Collection joins_ = graph.getObjects(flag, DIA.FlagIsJoinedBy);
        if (joins_.size() <= 1) {
            return Resource.NONE;
        }
        Resource diagram = (Resource)OrderedSetUtils.getSubjects((ReadGraph)graph, (Resource)flag).iterator().next();
        Resource flagType = graph.getSingleObject(flag, DIA.HasFlagType);
        double[] transform = (double[])graph.getRelatedValue(flag, DIA.HasTransform);
        Resource connector = graph.getSingleObject(flag, DIA.Flag_ConnectionPoint);
        Statement connectsStatement = null;
        for (Statement temp : graph.getStatements(connector, STR.Connects)) {
            if (flag.equals(temp.getObject())) continue;
            connectsStatement = temp;
            break;
        }
        if (connectsStatement == null) {
            return Resource.NONE;
        }
        Resource arrowType = connectsStatement.getPredicate();
        Resource diagramConnection = connectsStatement.getObject();
        Resource connection = graph.getSingleObject(diagramConnection, MOD.DiagramConnectionToConnection);
        ArrayList<Connector> connectors = ExpandFlags.getConnectors((ReadGraph)graph, diagramConnection);
        if (connectors.size() == 2) {
            Iterator<Connector> it = connectors.iterator();
            while (it.hasNext()) {
                if (!it.next().element.equals(flag)) continue;
                it.remove();
            }
        }
        Resource diagramRelation = connectors.size() != 1 ? null : connectors.get((int)0).terminal;
        Resource connectionPoint = diagramRelation == null ? null : graph.getPossibleObject(diagramRelation, MOD.DiagramConnectionRelationToConnectionRelation);
        Resource element = connectors.size() == 1 ? connectors.get((int)0).element : null;
        Resource component = null;
        Resource connectionType = null;
        Resource routeLine = null;
        if (connectionPoint != null && !graph.isInstanceOf(connectionPoint, L0.FunctionalRelation)) {
            component = graph.getSingleObject(element, MOD.ElementToComponent);
            connectionType = graph.getSingleObject(diagramConnection, STR.HasConnectionType);
        } else if (element != null && graph.isInstanceOf(element, MOD.ReferenceElement)) {
            component = graph.getSingleObject(element, MOD.HasParentComponent);
            connectionPoint = graph.getSingleObject(element, MOD.HasReferenceRelation);
            connectionType = graph.getSingleObject(diagramConnection, STR.HasConnectionType);
        } else {
            routeLine = graph.getSingleObject(connector, DIA.AreConnected);
            if (!graph.isInstanceOf(routeLine, DIA.RouteLine)) {
                Resource otherConnector = routeLine;
                routeLine = graph.newResource();
                graph.deny(connector, DIA.AreConnected, otherConnector);
                graph.claim(routeLine, L0.InstanceOf, DIA.RouteLine);
                graph.claim(diagramConnection, DIA.HasInteriorRouteNode, routeLine);
                graph.claimLiteral(routeLine, DIA.HasPosition, (Object)(transform[4] - 10.500000000000002));
                graph.claimLiteral(routeLine, DIA.IsHorizontal, (Object)false);
                graph.claim(routeLine, DIA.AreConnected, connector);
                graph.claim(routeLine, DIA.AreConnected, otherConnector);
            }
        }
        Resource[] joins = joins_.toArray(new Resource[joins_.size()]);
        Resource[] flags = new Resource[joins.length];
        double flagSeparation = 6.000000000000001;
        flags[0] = flag;
        int i = 1;
        while (i < flags.length) {
            Resource newFlag;
            flags[i] = newFlag = graph.newResource();
            graph.claim(newFlag, L0.InstanceOf, DIA.Flag);
            graph.claim(newFlag, DIA.HasFlagType, flagType);
            OrderedSetUtils.add((WriteGraph)graph, (Resource)diagram, (Resource)newFlag);
            graph.claim(diagram, L0.ConsistsOf, newFlag);
            graph.deny(flag, DIA.FlagIsJoinedBy, joins[i]);
            for (Resource otherFlag : graph.getObjects(joins[i], DIA.JoinsFlag)) {
                for (Statement label : graph.getStatements(otherFlag, L0.HasLabel)) {
                    if (label.isAsserted(otherFlag)) continue;
                    Resource literalCopy = CopyAdvisorUtil.copy((WriteGraph)graph, (Resource)label.getObject(), null);
                    graph.claim(newFlag, label.getPredicate(), literalCopy);
                }
            }
            graph.claim(newFlag, DIA.FlagIsJoinedBy, joins[i]);
            graph.claim(diagram, L0.ConsistsOf, newFlag);
            AddElement.claimFreshElementName((WriteGraph)graph, (Resource)diagram, (Resource)newFlag);
            double[] newTransform = new double[]{transform[0], transform[1], transform[2], transform[3], transform[4] + (double)i * 6.000000000000001 * transform[2], transform[5] + (double)i * 6.000000000000001 * transform[3]};
            graph.claimLiteral(newFlag, DIA.HasTransform, G2D.Transform, (Object)newTransform);
            if (routeLine == null) {
                Resource newConnector1 = graph.newResource();
                Resource newDiagramConnection = graph.newResource();
                Resource newConnector2 = graph.newResource();
                Resource newConnection = graph.newResource();
                graph.claim(newConnector1, L0.InstanceOf, DIA.Connector);
                graph.claim(newDiagramConnection, L0.InstanceOf, DIA.RouteGraphConnection);
                graph.claim(newDiagramConnection, STR.HasConnectionType, connectionType);
                graph.claim(newConnector2, L0.InstanceOf, DIA.Connector);
                graph.claim(newConnection, L0.InstanceOf, STR.Connection);
                Resource arrow = graph.getInverse(arrowType);
                Resource otherArrow = arrow.equals(DIA.HasPlainConnector) ? DIA.HasArrowConnector : DIA.HasPlainConnector;
                graph.claim(element, diagramRelation, newConnector1);
                graph.claim(newDiagramConnection, otherArrow, newConnector1);
                graph.claim(newDiagramConnection, arrow, newConnector2);
                graph.claim(newConnector1, DIA.AreConnected, newConnector2);
                graph.claim(newFlag, DIA.Flag_ConnectionPoint, newConnector2);
                graph.claim(component, connectionPoint, newConnection);
                graph.deny(joins[i], STR.Joins, connection);
                graph.claim(joins[i], STR.Joins, newConnection);
                graph.claim(newDiagramConnection, MOD.DiagramConnectionToConnection, newConnection);
                graph.claim(newConnection, MOD.Mapped, newConnection);
                OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)diagram, (Resource)newDiagramConnection);
                graph.claim(diagram, L0.ConsistsOf, newDiagramConnection);
            } else {
                Resource newConnector = graph.newResource();
                graph.claim(newConnector, L0.InstanceOf, DIA.Connector);
                graph.claim(newFlag, DIA.Flag_ConnectionPoint, newConnector);
                graph.claim(newConnector, arrowType, diagramConnection);
                graph.claim(newConnector, DIA.AreConnected, routeLine);
            }
            ++i;
        }
        return flags;
    }

    public static void collectGroupedFlags(ReadGraph graph, Resource composite, ArrayList<Resource> groups) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
        if (diagram == null) {
            return;
        }
        for (Resource element : graph.getObjects(diagram, L0.ConsistsOf)) {
            Collection objects;
            if (!graph.isInstanceOf(element, DIA.Flag) || (objects = graph.getObjects(element, DIA.FlagIsJoinedBy)).size() <= 1) continue;
            groups.add(element);
        }
    }

    static class Connector {
        Resource element;
        Resource terminal;

        public Connector(Resource element, Resource terminal) {
            this.element = element;
            this.terminal = terminal;
        }
    }
}

