/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultCopyHandler;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.structural.stubs.StructuralResource2;

public class CompositeCopyHandler
extends DefaultCopyHandler {
    public CompositeCopyHandler(Resource composite) {
        super(composite);
    }

    public CompositeCopyHandler(Collection<Resource> composites) {
        super(composites);
    }

    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        HashSet<Resource> exclusions = new HashSet<Resource>();
        ArrayList<TransferableGraphConfiguration2.RootSpec> roots = new ArrayList<TransferableGraphConfiguration2.RootSpec>();
        for (Resource resource : this.resources) {
            for (Resource join : graph.getObjects(resource, SR.HasConnectionJoin)) {
                for (Resource comp : graph.getObjects(join, SR.JoinsComposite)) {
                    if (this.resources.contains(comp)) continue;
                    exclusions.add(join);
                }
            }
            String rootName = (String)graph.getRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
            String path = ModelingUtils.getDiagramCompositePath(graph, resource);
            roots.add(new TransferableGraphConfiguration2.RootSpec(resource, "composite:" + path + "#" + rootName, true));
            for (Resource child : (Collection)graph.sync((ReadInterface)new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
                String childName = (String)graph.getRelatedValue(child, L0.HasName, (Binding)Bindings.STRING);
                roots.add(new TransferableGraphConfiguration2.RootSpec(child, "child:" + rootName + ":" + childName, true));
            }
        }
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.resources.iterator().next()));
        if (model == null) {
            throw new DatabaseException("Composite is not part of any index root");
        }
        roots.add(new TransferableGraphConfiguration2.RootSpec(model, "%model", false));
        return TransferableGraphConfiguration2.createWithNames2((RequestProcessor)graph, roots, exclusions, (boolean)true, (boolean)false);
    }
}

