/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.operations.Operation;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.persistent.IContextMap;
import org.simantics.utils.ui.ErrorLogger;

public class DisconnectFlag
extends Operation {
    public DisconnectFlag() {
        super("Disconnect");
    }

    public void exec(Session session, IContextMap parameters) {
        final Resource flag = (Resource)parameters.get(SUBJECT);
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                Set flags = FlagUtil.getCounterparts((ReadGraph)g, (Resource)flag, new HashSet<Resource>(Collections.singleton(flag)));
                FlagUtil.disconnectFlag((WriteGraph)g, (Resource)flag);
                for (Resource f : flags) {
                    g.denyValue(f, Layer0.getInstance((ReadGraph)g).HasLabel);
                }
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException parameter) {
                if (parameter != null) {
                    ErrorLogger.defaultLogError((String)"Flag disconnect failed, see exception for details.", (Throwable)parameter);
                }
            }
        });
    }
}

