/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.UnescapedPropertyMapOfResource;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.BijectionMap;

public class SubstructureMapRequest
extends ResourceRead<BijectionMap<String, String>> {
    public SubstructureMapRequest(Resource type) {
        super(type);
    }

    private void collect(ReadGraph graph, Resource t, BijectionMap<String, String> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource relation : graph.getObjects(t, L0.DomainOf)) {
            if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
            String name = (String)graph.getRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING);
            result.map((Object)name, (Object)("#" + name));
        }
    }

    public BijectionMap<String, String> perform(ReadGraph graph) throws DatabaseException {
        BijectionMap propertyMap = new BijectionMap();
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource composite = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
        if (composite != null) {
            for (Map.Entry child : ((Map)graph.sync((ReadInterface)new UnescapedChildMapOfResource(composite))).entrySet()) {
                for (Map.Entry property : ((Map)graph.sync((ReadInterface)new UnescapedPropertyMapOfResource((Resource)child.getValue()))).entrySet()) {
                    propertyMap.map((Object)(String.valueOf((String)child.getKey()) + "." + (String)property.getKey()), (Object)("/" + (String)child.getKey() + "#" + (String)property.getKey()));
                }
            }
        }
        this.collect(graph, this.resource, (BijectionMap<String, String>)propertyMap);
        for (Resource t : graph.getSupertypes(this.resource)) {
            this.collect(graph, t, (BijectionMap<String, String>)propertyMap);
        }
        return propertyMap;
    }
}

