/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.TextGridNode;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BackgroundNode;
import org.simantics.scenegraph.g2d.nodes.BoundsNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.DecorationSVGNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.trend.impl.ItemNode;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class SCLScenegraph {
    public static ICanvasSceneGraphProvider getICanvasSceneGraphProvider(Resource model, Resource diagram, String diagramRVI) throws DatabaseException, InterruptedException {
        ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((Resource)model, (Resource)diagram, (String)diagramRVI);
        return provider;
    }

    public static void disposeSceneGraphProvider(ICanvasSceneGraphProvider provider) {
        provider.dispose();
    }

    public static String getNodeTransform(ICanvasContext ctx, String name) {
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode text : texts) {
            String nodeName = NodeUtil.getNodeName((INode)text);
            if (!nodeName.equals(name)) continue;
            String transform = text.getTransform().toString();
            return transform;
        }
        return "No node found";
    }

    public static String getNodeText(ICanvasContext ctx, String name) {
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode text : texts) {
            String nodeName = NodeUtil.getNodeName((INode)text);
            if (!nodeName.equals(name)) continue;
            String texti = text.getText();
            return texti;
        }
        return "No node found";
    }

    public static String getNodeCount(ICanvasContext ctx) {
        G2DSceneGraph g2 = ctx.getSceneGraph();
        int amount = NodeUtil.countTreeNodes((INode)g2);
        return "Node count: " + amount;
    }

    public static String getAllNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DSceneGraph.class);
        int amount = g2.size() + 1;
        return "All nodes: " + amount;
    }

    public static String getBoundsNodes(ICanvasContext ctx) {
        Set bn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), BoundsNode.class);
        int amount = bn.size();
        return "BoundsNodes: " + amount;
    }

    public static String getBackgroundNodes(ICanvasContext ctx) {
        Set bg = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), BackgroundNode.class);
        int amount = bg.size();
        return "BackgroundNodes: " + amount;
    }

    public static String getDataNodes(ICanvasContext ctx) {
        Set dn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), DataNode.class);
        int amount = dn.size();
        return "DataNodes: " + amount;
    }

    public static String getNavigationNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), NavigationNode.class);
        int amount = g2.size();
        return "NavigationNodes: " + amount;
    }

    public static String getParentNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DParentNode.class);
        int amount = g2.size();
        return "ParentNodes: " + amount;
    }

    public static String getDecorationNodes(ICanvasContext ctx) {
        Set deco = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), DecorationSVGNode.class);
        int amount = deco.size();
        return "DecorationNodes: " + amount;
    }

    public static String getSingleElementNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), SingleElementNode.class);
        int amount = g2.size();
        return "SingleElementNodes: " + amount;
    }

    public static String getConnectionNodes(ICanvasContext ctx) {
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), ConnectionNode.class);
        int amount = g2.size();
        return "ConnectionNodes: " + amount;
    }

    public static String getTextNodes(ICanvasContext ctx) {
        Set tn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        Set tgn = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextGridNode.class);
        int amount = tn.size() + tgn.size();
        return "TextNodes: " + amount;
    }

    public static String getItemNodes(ICanvasContext ctx) {
        Set item = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), ItemNode.class);
        int amount = item.size();
        return "ItemNodes: " + amount;
    }

    public static String editNodeText(ICanvasContext ctx, String module, String previous_value, String new_value) {
        Set textGridNodes = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        for (TextNode modulenode : textGridNodes) {
            if (!module.equals(modulenode.getText())) continue;
            ParentNode parentnode = modulenode.getParent();
            Collection textnodes = parentnode.getNodes();
            for (TextNode valuenode : textnodes) {
                if (!previous_value.equals(valuenode.getText())) continue;
                valuenode.activateEdit(0, null, ctx);
                valuenode.setText(new_value);
                valuenode.fireTextEditingEnded();
            }
        }
        return "Modified module " + module + " with value " + new_value;
    }

    public static String sceneGraphTest(ICanvasContext ctx, String module, String value) {
        boolean module_founded = false;
        boolean value_founded = false;
        Set g2 = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), G2DSceneGraph.class);
        System.out.println("Total amount of nodes: " + g2.size() + 1);
        Set grid = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextGridNode.class);
        Integer textGridNodeAmount = grid.size();
        System.out.println("Amount of TextGridNodes " + textGridNodeAmount);
        Set texts = NodeUtil.collectNodes((INode)ctx.getSceneGraph(), TextNode.class);
        Integer textNodeAmount = grid.size();
        System.out.println("Amount of TextNodes " + textNodeAmount);
        for (TextNode node : texts) {
            if (module.equals(node.getText())) {
                module_founded = true;
                System.out.println("Correct module " + module + " founded.");
            }
            if (!value.equals(node.getText())) continue;
            value_founded = true;
            System.out.println("Correct value " + value + " founded.");
        }
        if (value_founded && module_founded) {
            return "Found both correct module " + module + " and value " + value;
        }
        if (!value_founded && module_founded) {
            return "Found only correct module " + module + " but not value " + value;
        }
        if (value_founded && !module_founded) {
            return "Found only correct value " + value + " but not module " + module;
        }
        return "Didn't found either module " + module + " or value " + value;
    }

    public static boolean copyPaste(final ICanvasContext source_ctx, final ICanvasContext target_ctx, List<Resource> modules) throws DatabaseException {
        IDiagram idiagram = (IDiagram)source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        DataElementMap dem = (DataElementMap)idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (dem != null) {
            final ArrayList<IElement> newSelection = new ArrayList<IElement>();
            for (Resource module : modules) {
                IElement element = dem.getElement(idiagram, (Object)module);
                if (element != null) {
                    newSelection.add(element);
                    continue;
                }
                throw new DatabaseException("Could not find IElement for " + element);
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (source_ctx.isDisposed()) {
                        return;
                    }
                    Selection selection = (Selection)source_ctx.getAtMostOneItemOfClass(Selection.class);
                    if (selection != null) {
                        selection.setSelection(0, newSelection);
                    }
                    CanvasUtils.sendCommand((ICanvasContext)source_ctx, (Command)Commands.COPY);
                    CanvasUtils.sendCommand((ICanvasContext)target_ctx, (Command)Commands.PASTE);
                }
            });
            while (source_ctx.getEventQueue().size() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return true;
    }
}

