/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Logger;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;

public class SCL {
    public static void killPlatformWrite(WriteGraph graph) throws DatabaseException {
        SimanticsPlatform.INSTANCE.server.stop();
    }

    public static void killPlatformRead(ReadGraph graph) throws DatabaseException {
        SimanticsPlatform.INSTANCE.server.stop();
    }

    public static void killPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.server.stop();
    }

    public static void shutdownPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.shutdown(null);
    }

    public static void reconnectPlatform() throws Exception {
        SimanticsPlatform.INSTANCE.reconnect();
    }

    public static void sync() throws DatabaseException {
        int i = 0;
        while (i < 3) {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                }

                public String toString() {
                    return "Utils sync";
                }
            });
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                }
            });
            ++i;
        }
    }

    public static void syncGraph() throws Exception {
        Job[] jobs;
        SCL.sync();
        IJobManager job = Job.getJobManager();
        Job[] jobArray = jobs = job.find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job j = jobArray[n2];
            if (j instanceof DatabaseJob) {
                j.join();
            }
            ++n2;
        }
        SCL.sync();
    }

    public static boolean deleteMBNode(List<Resource> resources) throws DatabaseException {
        boolean value = false;
        try {
            value = RemoverUtil.tryCollectionRemover(resources);
        }
        catch (DatabaseException e) {
            return value;
        }
        return value;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static boolean hasSomethingToPaste(ReadGraph graph, Resource resource) throws DatabaseException {
        SimanticsClipboard clipboard = Simantics.getClipboard();
        return !clipboard.getContents().isEmpty();
    }

    public static String currentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(System.currentTimeMillis()));
    }
}

