/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Stack;
import org.simantics.basicexpression.Expressions;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.ADivMultiplicative;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.AVariablePrimary;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ProceduralSubstructureMapRequest;
import org.simantics.modeling.SubstructureMapRequest;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Triple;

public class InvertBasicExpressionVisitor
extends DepthFirstAdapter {
    Stack<Object> stack = new Stack();
    private static final String MAGIC = "_111_";

    public Object getResult() {
        if (this.stack.size() != 1) {
            return null;
        }
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAVariablePrimary(AVariablePrimary node) {
        String value = node.toString().trim();
        this.stack.push(Triple.make((Object)1.0, (Object)0.0, (Object)value));
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 + (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMinusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)(-((Double)p.first).doubleValue()), (Object)((Double)o1 - (Double)p.second), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second - (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 - (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o1), (Object)((Double)p.second * (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o2), (Object)((Double)p.second * (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 * (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outADivMultiplicative(ADivMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            this.stack.push(Double.NaN);
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first / (Double)o2), (Object)((Double)p.second / (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 / (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    private static String replaced(String expression) {
        return expression.replaceAll("\\.([A-Z])", "_111_$1");
    }

    public static void invert(WriteGraph graph, Variable base, String expression, double value) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = base.getPossibleType((ReadGraph)graph);
        if (type == null) {
            return;
        }
        boolean procedural = graph.isInstanceOf(type, STR.ProceduralComponentType);
        BijectionMap map = procedural ? (BijectionMap)graph.sync((ReadInterface)new ProceduralSubstructureMapRequest(base)) : (BijectionMap)graph.sync((ReadInterface)new SubstructureMapRequest(type));
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object pair = visitor.getResult();
        if (pair == null) {
            return;
        }
        if (pair instanceof Triple) {
            Triple data = (Triple)pair;
            if (Math.abs((Double)data.first) > 1.0E-9) {
                Double inverted = (Double.valueOf(value) - (Double)data.second) / (Double)data.first;
                String key = ((String)data.third).replace(MAGIC, ".");
                String path = (String)map.getRight((Object)key);
                Variable targetVariable = base.browse((ReadGraph)graph, path);
                targetVariable.setValue(graph, (Object)inverted);
            }
        }
    }

    public static boolean isInvertible(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = base.getPossibleType(graph);
        if (type == null) {
            return false;
        }
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object pair = visitor.getResult();
        if (pair == null) {
            return false;
        }
        if (pair instanceof Triple) {
            String key;
            Triple data = (Triple)pair;
            boolean procedural = graph.isInstanceOf(type, STR.ProceduralComponentType);
            BijectionMap map = procedural ? (BijectionMap)graph.sync((ReadInterface)new ProceduralSubstructureMapRequest(base)) : (BijectionMap)graph.sync((ReadInterface)new SubstructureMapRequest(type));
            String path = (String)map.getRight((Object)(key = ((String)data.third).replace(MAGIC, ".")));
            return path != null;
        }
        return false;
    }

    public static Variable possibleInvertibleExpressionReferencedProperty(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        BijectionMap map;
        if (base == null) {
            return null;
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = base.getPossibleType(graph);
        if (type == null) {
            return null;
        }
        boolean procedural = graph.isInstanceOf(type, STR.ProceduralComponentType);
        BijectionMap bijectionMap = map = procedural ? (BijectionMap)graph.sync((ReadInterface)new ProceduralSubstructureMapRequest(base)) : (BijectionMap)graph.sync((ReadInterface)new SubstructureMapRequest(type));
        if (map.isEmpty()) {
            return null;
        }
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object pair = visitor.getResult();
        if (pair == null) {
            return null;
        }
        if (pair instanceof Triple) {
            Triple data = (Triple)pair;
            String key = ((String)data.third).replace(MAGIC, ".");
            String path = (String)map.getRight((Object)key);
            Variable targetVariable = base.browsePossible(graph, path);
            return targetVariable;
        }
        return null;
    }
}

