/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.activation;

import org.simantics.db.Disposable;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.utils.queries.QueryExecutor2;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.layer0.utils.triggers.ITrigger;
import org.simantics.operation.Layer0X;
import org.simantics.utils.threads.logger.IThreadLogger;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ActivationManager
implements IActivationManager,
Disposable {
    Session session;
    static IThreadLogger threadLogger = ThreadLogger.getInstance();

    public ActivationManager(Session session) {
        this.session = session;
    }

    public IActivation activate(Resource r) {
        Session s = this.session;
        if (s == null) {
            throw new IllegalStateException("ActivationManager is disposed");
        }
        Activation activation = new Activation(r);
        try {
            activation.execute((RequestProcessor)this.session);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return activation;
    }

    public IActivation activate(WriteGraph graph, Resource r) throws DatabaseException {
        Session s = this.session;
        if (s == null) {
            throw new IllegalStateException("ActivationManager is disposed");
        }
        Activation activation = new Activation(r);
        activation.execute(graph);
        return activation;
    }

    public void activateOnce(Resource resource) {
        this.activate(resource).runOnceAndDeactivate();
    }

    public void activateOnce(WriteGraph graph, Resource resource) throws DatabaseException {
        Session s = this.session;
        if (s == null) {
            throw new IllegalStateException("ActivationManager is disposed");
        }
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(resource, L0X.HasTrigger)) {
            new Activation(resource).executeOnce(graph, r);
        }
    }

    public void dispose() {
        this.session = null;
    }

    class Activation
    extends QueryExecutor2
    implements IActivation {
        final boolean DEBUG = false;
        final boolean BREAK_INFINITE_ACTIVATION_LOOPS = true;
        final int INFINITE_LOOP_COUNT = 100;
        Resource resource;
        int transactionCount = 0;
        boolean disposed = false;
        boolean runOnce = false;

        public Activation(Resource resource) {
            this.resource = resource;
        }

        public void runOnceAndDeactivate() {
            this.runOnce = true;
        }

        public void run(ReadGraph g) throws DatabaseException {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
            for (Resource r : g.getObjects(this.resource, L0X.HasTrigger)) {
                if (this.calcModification(g, r) == null) continue;
                this.execute(g, r);
            }
        }

        private IModification calcModification(ReadGraph g, Resource trigger) throws DatabaseException {
            IModification modi = (IModification)g.syncRequest((Read)g.adapt(trigger, ITrigger.class));
            return modi;
        }

        private WriteRequest getRequest(final Resource trigger) {
            return new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    int count = 0;
                    while (true) {
                        CommonDBUtils.selectClusterSet((WriteGraph)g, (Resource)trigger);
                        IModification modification = Activation.this.calcModification((ReadGraph)g, trigger);
                        if (modification == null) {
                            if (count > 0) {
                                CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
                                String msg = "ActivationManager modification count=" + count;
                                g.addMetadata((Metadata)cm.add(msg));
                            }
                            if (Activation.this.runOnce) {
                                Activation.this.deactivate();
                            }
                            return;
                        }
                        if (++count > 100) {
                            Activation.this.deactivate();
                            String msg = "Possible dynamic activation loop. Forcing break.Loop count was " + count + ". Activated resource was " + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)Activation.this.resource) + ".";
                            System.out.println("WARNING: " + msg);
                            throw new DatabaseException(msg);
                        }
                        try {
                            modification.perform(g);
                        }
                        catch (DatabaseException e) {
                            Activation.this.deactivate();
                            throw e;
                        }
                    }
                }
            };
        }

        private void executeOnce(WriteGraph graph, Resource trigger) throws DatabaseException {
            this.getRequest(trigger).perform(graph);
        }

        private void execute(ReadGraph graph, Resource trigger) {
            graph.asyncRequest((Write)this.getRequest(trigger));
        }

        public void deactivate() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed || ActivationManager.this.session == null;
        }
    }
}

