/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Adapt;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.ImmutableIndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsMemorySearcher;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.request.ReadInterface;

public class MemoryIndexing {
    private final Session session;
    final Map<String, Map<String, List<Map<String, Object>>>> persistentCache = new HashMap<String, Map<String, List<Map<String, Object>>>>();
    private final Map<String, RAMDirectory> directories = new HashMap<String, RAMDirectory>();
    private final Map<String, IndexedRelationsSearcherBase> immutableSearchers = new HashMap<String, IndexedRelationsSearcherBase>();
    private final Map<String, IndexedRelationsSearcher> searchers = new HashMap<String, IndexedRelationsSearcher>();

    public MemoryIndexing(Session session) {
        this.session = session;
    }

    protected File getIndexDirectory(Resource relation, Resource input) {
        return DatabaseIndexing.getIndexLocation(this.session, relation, input);
    }

    public IndexedRelationsSearcher get(RequestProcessor processor, Resource relation, Resource input) {
        try {
            File location = this.getIndexDirectory(relation, input);
            String key = location.getAbsolutePath();
            IndexedRelationsSearcher searcher = this.searchers.get(key);
            if (searcher == null) {
                GenericRelation r = (GenericRelation)processor.sync((ReadInterface)new Adapt(relation, GenericRelation.class));
                searcher = new IndexedRelationsSearcher(processor, relation, input, r);
                this.searchers.put(key, searcher);
            }
            return searcher;
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public IndexedRelationsSearcherBase getImmutable(RequestProcessor processor, Resource relation, Resource input) {
        try {
            File location = this.getIndexDirectory(relation, input);
            String key = location.getAbsolutePath();
            IndexedRelationsSearcherBase searcher = this.immutableSearchers.get(key);
            if (searcher == null) {
                searcher = new ImmutableIndexedRelationsSearcher(processor, relation, input);
                this.immutableSearchers.put(key, searcher);
            }
            return searcher;
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static MemoryIndexing getInstance(Session session) {
        MemoryIndexing ret = (MemoryIndexing)session.peekService(MemoryIndexing.class);
        if (ret == null) {
            ret = new MemoryIndexing(session);
            session.registerService(MemoryIndexing.class, (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Directory getDirectory(String path, Analyzer analyzer) throws IOException {
        RAMDirectory directory = this.directories.get(path);
        if (directory == null) {
            Map<String, RAMDirectory> map = this.directories;
            synchronized (map) {
                directory = this.directories.get(path);
                if (directory == null) {
                    directory = new RAMDirectory();
                    new IndexWriter((Directory)directory, new IndexWriterConfig(Version.LUCENE_35, analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE)).close();
                    this.directories.put(path, directory);
                }
            }
        }
        return directory;
    }

    public void remove(String path) {
        this.directories.remove(path);
    }

    public void flush(IProgressMonitor progress) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        Set<Map.Entry<String, IndexedRelationsSearcher>> set = this.searchers.entrySet();
        Set<Map.Entry<String, IndexedRelationsSearcherBase>> iset = this.immutableSearchers.entrySet();
        monitor.setWorkRemaining(set.size() + iset.size());
        for (Map.Entry<String, IndexedRelationsSearcher> entry : set) {
            IndexedRelationsSearcher persistent = entry.getValue();
            IndexedRelationsMemorySearcher searcher = persistent.cache;
            if (persistent.isIndexAvailable()) {
                List<Object[]> os = searcher.allDocs((IProgressMonitor)monitor, this.session);
                persistent.applyChanges((IProgressMonitor)monitor, this.session, searcher.r, os);
            }
            monitor.worked(1);
            entry.getValue().changeState((IProgressMonitor)monitor, this.session, IndexedRelationsSearcherBase.State.READY);
        }
        for (Map.Entry<String, IndexedRelationsSearcherBase> entry : iset) {
            entry.getValue().changeState((IProgressMonitor)monitor, this.session, IndexedRelationsSearcherBase.State.READY);
            monitor.worked(1);
        }
    }
}

