/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.SafeName;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.IndexPolicy;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.DataContainer;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;

public abstract class IndexedRelationsSearcherBase {
    public static final boolean DEBUG = false;
    private State state = State.READY;
    private Throwable exception;
    RequestProcessor session;
    Resource relation;
    Resource input;
    File indexPath;
    Directory directory;
    IndexReader reader;
    IndexWriter writer;
    IndexSearcher searcher;
    Analyzer analyzer;

    public Throwable getException() {
        return this.exception;
    }

    public void setProblem(Throwable t) {
        this.state = State.PROBLEM;
        this.exception = t;
    }

    public void setNone() {
        this.state = State.NONE;
    }

    public void setReady() {
        this.state = State.READY;
    }

    protected boolean checkState(State state) {
        return this.state == state;
    }

    protected void assertState(State state) throws AssertionError {
        if (this.state != state) {
            throw new AssertionError((Object)("Illegal state, expected " + state.name() + " but was in " + this.state.name()));
        }
    }

    public void changeState(IProgressMonitor monitor, Session session, State state) {
        this.changeState(monitor, session, state, 0);
    }

    protected void changeState(IProgressMonitor monitor, Session session, State state, int depth) {
        block22: {
            boolean success;
            block21: {
                if (this.state == state) {
                    return;
                }
                if (State.PROBLEM == this.state && depth > 0) {
                    Throwable t = this.bestEffortClear(monitor, session);
                    if (t != null) {
                        this.exception = t;
                        return;
                    }
                    this.state = State.NONE;
                    return;
                }
                if (State.NONE == this.state && State.READ == state) {
                    return;
                }
                if (State.NONE == this.state && State.WRITE == state) {
                    return;
                }
                success = false;
                try {
                    try {
                        boolean forWriting;
                        if (this.searcher != null) {
                            this.searcher.close();
                            this.searcher = null;
                        }
                        if (this.reader != null) {
                            this.reader.close();
                            this.reader = null;
                        }
                        this.closeWriter(this.writer);
                        this.directory = null;
                        success = true;
                        if (State.READ != state && State.WRITE != state) break block21;
                        success = false;
                        boolean bl = forWriting = State.WRITE == state;
                        if (this.directory != null) {
                            throw new IllegalStateException(String.valueOf(this.getDescriptor()) + "Index already loaded");
                        }
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        mon.beginTask("Loading index", 100);
                        if (IndexPolicy.TRACE_INDEX_LOAD) {
                            System.out.println(String.valueOf(this.getDescriptor()) + "Loading Lucene index from " + this.indexPath + " for " + (forWriting ? "writing" : "reading"));
                        }
                        long start = System.nanoTime();
                        this.directory = this.getDirectory(session);
                        this.analyzer = IndexedRelationsSearcherBase.getAnalyzer();
                        if (forWriting) {
                            try {
                                this.writer = new IndexWriter(this.directory, new IndexWriterConfig(Version.LUCENE_35, this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
                            }
                            catch (IndexNotFoundException e) {
                                this.writer = new IndexWriter(this.directory, new IndexWriterConfig(Version.LUCENE_35, this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                                this.writer.commit();
                            }
                            this.reader = IndexReader.open((Directory)this.directory);
                            this.searcher = new IndexSearcher(this.reader);
                        } else {
                            this.reader = IndexReader.open((Directory)this.directory);
                            this.searcher = new IndexSearcher(this.reader);
                        }
                        long end = System.nanoTime();
                        mon.worked(100);
                        if (IndexPolicy.PERF_INDEX_LOAD) {
                            double time = (double)(end - start) * 1.0E-6;
                            System.out.println(String.valueOf(this.getDescriptor()) + "Loaded Lucene index from " + this.indexPath + " for " + (forWriting ? "writing" : "reading") + " in " + time + " ms");
                        }
                        success = true;
                    }
                    catch (Throwable t) {
                        this.setProblem(t);
                        if (!success) {
                            this.state = State.PROBLEM;
                            this.changeState(monitor, session, State.NONE, depth + 1);
                            return;
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        this.state = State.PROBLEM;
                        this.changeState(monitor, session, State.NONE, depth + 1);
                        return;
                    }
                    throw throwable;
                }
            }
            if (!success) {
                this.state = State.PROBLEM;
                this.changeState(monitor, session, State.NONE, depth + 1);
                return;
            }
        }
        this.state = state;
    }

    protected static PerFieldAnalyzerWrapper getAnalyzer() {
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new LowerCaseWhitespaceAnalyzer());
        return analyzer;
    }

    void insertIndex(IProgressMonitor monitor, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        this.assertAccessOpen(true);
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Inserting " + documentsData.size() + " documents into index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        Document document = new Document();
        Pair[] fields = r.getFields();
        Field[] fs = new Field[fields.length - boundLength];
        int i = boundLength;
        while (i < fields.length) {
            Field f;
            String fieldName = (String)fields[i].first;
            Class fieldClass = (Class)fields[i].second;
            if (Long.class.equals((Object)fieldClass)) {
                fs[i - boundLength] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                document.add((Fieldable)f);
            } else if (String.class.equals((Object)fieldClass)) {
                fs[i - boundLength] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                document.add((Fieldable)f);
            } else {
                throw new DatabaseException("Can only index Long and String fields, encountered class " + fieldClass);
            }
            ++i;
        }
        for (Object[] documentData : documentsData) {
            int i2 = 0;
            while (i2 < documentData.length) {
                Object value = documentData[i2];
                if (value instanceof String) {
                    fs[i2].setValue((String)value);
                } else if (value instanceof Long) {
                    fs[i2].setValue(String.valueOf((Long)value));
                } else {
                    System.err.println("Can only index Long and String fields, encountered " + value);
                }
                ++i2;
            }
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Inserting document " + document);
            }
            this.writer.addDocument(document);
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Inserted " + documentsData.size() + " documents into index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    void removeIndex(IProgressMonitor monitor, GenericRelation r, RequestProcessor processor, String key, Collection<Object> keyValues) throws DatabaseException, CorruptIndexException, IOException {
        this.assertAccessOpen(true);
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Removing " + keyValues.size() + " documents from index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        Term term = new Term(key);
        for (Object keyValue : keyValues) {
            Term removedTerm = null;
            if (keyValue instanceof Long) {
                removedTerm = term.createTerm(String.valueOf((Long)keyValue));
            } else {
                if (!(keyValue instanceof String)) continue;
                removedTerm = term.createTerm((String)keyValue);
            }
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Removing document with key " + removedTerm);
            }
            this.writer.deleteDocuments(removedTerm);
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Removed " + keyValues.size() + " documents from index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    void removeIndex(IProgressMonitor monitor) throws DatabaseException, CorruptIndexException, IOException {
        this.assertAccessOpen(true);
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        this.writer.deleteAll();
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Removed all documents from index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    boolean replaceIndex(IProgressMonitor monitor, String key, Collection<Object> keyValues, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        boolean didReplace = false;
        this.assertAccessOpen(true);
        if (keyValues.size() != documentsData.size()) {
            throw new IllegalArgumentException("keyValues size does not match documents data size, " + keyValues.size() + " <> " + documentsData.size());
        }
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Replacing " + keyValues.size() + " documents from index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        Iterator<Object> keyIt = keyValues.iterator();
        Iterator<Object[]> documentDataIt = documentsData.iterator();
        Document document = new Document();
        Term term = new Term(key);
        Pair[] fields = r.getFields();
        Field[] fs = new Field[fields.length - boundLength];
        int i = boundLength;
        while (i < fields.length) {
            Field f;
            String fieldName = (String)fields[i].first;
            Class fieldClass = (Class)fields[i].second;
            if (Long.class.equals((Object)fieldClass)) {
                fs[i - boundLength] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                document.add((Fieldable)f);
            } else if (String.class.equals((Object)fieldClass)) {
                fs[i - boundLength] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                document.add((Fieldable)f);
            } else {
                throw new DatabaseException("Can only index Long and String fields, encountered class " + fieldClass);
            }
            ++i;
        }
        block1: while (keyIt.hasNext()) {
            Object keyValue = keyIt.next();
            Object[] documentData = documentDataIt.next();
            Term removedTerm = null;
            if (keyValue instanceof Long) {
                removedTerm = term.createTerm(String.valueOf((Long)keyValue));
            } else if (keyValue instanceof String) {
                removedTerm = term.createTerm((String)keyValue);
            } else {
                System.err.println("[" + this.getClass().getSimpleName() + "] Unrecognized document key to remove '" + keyValue + "', only " + String.class + " and " + Resource.class + " are supported.");
                continue;
            }
            int i2 = 0;
            while (i2 < documentData.length) {
                Object value = documentData[i2];
                if (value instanceof String) {
                    fs[i2].setValue((String)value);
                } else if (keyValue instanceof Long) {
                    fs[i2].setValue(String.valueOf((Long)value));
                } else {
                    System.err.println("[" + this.getClass().getSimpleName() + "] Unrecognized document value '" + value + "' for field '" + fs[i2].toString() + "', only " + String.class + " and " + Resource.class + " are supported.");
                    continue block1;
                }
                ++i2;
            }
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Replacing document with key " + removedTerm + " with " + document);
            }
            TopDocs exist = this.searcher.search((Query)new TermQuery(removedTerm), null, 2);
            if (exist.scoreDocs.length == 1) {
                Document doc = this.reader.document(exist.scoreDocs[0].doc);
                if (this.areSame(doc, document)) continue;
                this.writer.deleteDocuments(removedTerm);
                this.writer.addDocument(document);
                didReplace |= true;
                continue;
            }
            this.writer.deleteDocuments(removedTerm);
            this.writer.addDocument(document);
            didReplace |= true;
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Replaced " + keyValues.size() + " documents from index at " + this.indexPath + " in " + ms + " ms");
        }
        return didReplace;
    }

    private boolean areSame(Document d1, Document d2) {
        List fs1 = d1.getFields();
        List fs2 = d2.getFields();
        if (fs1.size() != fs2.size()) {
            return false;
        }
        int i = 0;
        while (i < fs1.size()) {
            Fieldable f1 = (Fieldable)fs1.get(i);
            Fieldable f2 = (Fieldable)fs2.get(i);
            String s1 = f1.stringValue();
            String s2 = f2.stringValue();
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.err.println("areSame " + s1 + " vs. " + s2);
            }
            if (!ObjectUtils.objectEquals((Object)s1, (Object)s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    IndexedRelationsSearcherBase(RequestProcessor session, Resource relation, Resource input) {
        this.session = session;
        this.relation = relation;
        this.input = input;
        this.indexPath = IndexedRelationsSearcherBase.getIndexDirectory(session.getSession(), relation, input);
        this.state = this.isIndexAvailable() ? State.READY : State.NONE;
    }

    Directory getDirectory(Session session) throws IOException {
        return FSDirectory.open((File)this.indexPath);
    }

    abstract String getDescriptor();

    boolean startAccess(IProgressMonitor monitor, Session session, boolean forWriting) {
        if (forWriting) {
            this.changeState(monitor, session, State.WRITE);
            return this.checkState(State.WRITE);
        }
        this.changeState(monitor, session, State.READ);
        return this.checkState(State.READ);
    }

    boolean hasAccess(boolean forWriting) {
        if (forWriting) {
            return this.checkState(State.WRITE);
        }
        return this.checkState(State.WRITE) || this.checkState(State.READ);
    }

    void assertAccessOpen(boolean forWriting) {
        if (forWriting) {
            if (!this.checkState(State.WRITE)) {
                throw new IllegalStateException("index not opened for writing (directory=" + this.directory + ", reader=" + this.reader + ")");
            }
            if (!this.checkState(State.WRITE) && !this.checkState(State.READ)) {
                throw new IllegalStateException("index not opened for reading (directory=" + this.directory + ", writer=" + this.writer + ")");
            }
        }
    }

    void closeWriter(IndexWriter writer) throws CorruptIndexException, IOException {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (OutOfMemoryError e) {
            writer.close();
            throw e;
        }
    }

    private static String getPattern(GenericRelation relation, int boundCount) {
        String result = "";
        int i = 0;
        while (i < boundCount) {
            result = String.valueOf(result) + "b";
            ++i;
        }
        i = 0;
        while (i < relation.getFields().length - boundCount) {
            result = String.valueOf(result) + "f";
            ++i;
        }
        return result;
    }

    void initializeIndex(IProgressMonitor monitor, ReadGraph graph, final Object[] bound, boolean overwrite) throws IOException, DatabaseException {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (IndexPolicy.TRACE_INDEX_INIT) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Initializing index at " + this.indexPath + " (overwrite = " + overwrite + ")");
        }
        mon.beginTask("Initializing Index", 100);
        if (overwrite) {
            mon.subTask("Erasing previous index");
            FileUtils.deleteAll((File)this.indexPath);
        }
        AtomicReference<FSDirectory> directory = new AtomicReference<FSDirectory>();
        final AtomicReference<IndexWriter> writer = new AtomicReference<IndexWriter>();
        try {
            try {
                mon.subTask("Create index at " + this.indexPath.toString());
                IndexedRelationsSearcherBase.createDirectory(this.indexPath);
                directory.set(FSDirectory.open((File)this.indexPath));
                IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)IndexedRelationsSearcherBase.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                writer.set(new IndexWriter((Directory)directory.get(), conf));
                mon.worked(5);
                final DataContainer start = new DataContainer();
                graph.syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        GenericRelation r = (GenericRelation)graph.adapt(IndexedRelationsSearcherBase.this.relation, GenericRelation.class);
                        if (r == null) {
                            throw new DatabaseException("Given resource " + (String)graph.syncRequest((Read)new SafeName(IndexedRelationsSearcherBase.this.relation)) + "could not be adapted to GenericRelation.");
                        }
                        mon.worked(45);
                        Document document = new Document();
                        Pair[] fields = r.getFields();
                        Field[] fs = new Field[fields.length - bound.length];
                        int i = bound.length;
                        while (i < fields.length) {
                            Field f;
                            String fieldName = (String)fields[i].first;
                            Class fieldClass = (Class)fields[i].second;
                            if (Long.class.equals((Object)fieldClass)) {
                                fs[i - bound.length] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                                document.add((Fieldable)f);
                            } else if (String.class.equals((Object)fieldClass)) {
                                fs[i - bound.length] = f = new Field(fieldName, "", Field.Store.YES, Field.Index.ANALYZED);
                                document.add((Fieldable)f);
                            } else {
                                throw new DatabaseException("Can only index Long and String fields, encountered class " + fieldClass);
                            }
                            ++i;
                        }
                        GenericRelation selection = r.select(IndexedRelationsSearcherBase.getPattern(r, bound.length), bound);
                        long perfStart = 0L;
                        if (IndexPolicy.PERF_INDEX_INIT) {
                            perfStart = System.nanoTime();
                        }
                        List results = selection.realize(graph);
                        if (IndexPolicy.PERF_INDEX_INIT) {
                            System.out.println(String.valueOf(IndexedRelationsSearcherBase.this.getDescriptor()) + "Realized index at " + IndexedRelationsSearcherBase.this.indexPath + " in " + 1.0E-9 * (double)(System.nanoTime() - perfStart) + " seconds.");
                        }
                        if (IndexPolicy.TRACE_INDEX_INIT) {
                            System.out.println(String.valueOf(IndexedRelationsSearcherBase.this.getDescriptor()) + "Indexed relation " + r + " produced " + results.size() + " results");
                        }
                        if (IndexPolicy.PERF_INDEX_INIT) {
                            start.set((Object)System.nanoTime());
                        }
                        for (Object[] result : results) {
                            int i2 = 0;
                            while (i2 < result.length) {
                                Object value = result[i2];
                                if (value instanceof String) {
                                    if (IndexPolicy.DEBUG_INDEX_INIT) {
                                        System.out.println(String.valueOf(IndexedRelationsSearcherBase.this.getDescriptor()) + "index " + fs[i2].name() + " = " + value + " : String");
                                    }
                                    fs[i2].setValue((String)value);
                                } else if (value instanceof Long) {
                                    if (IndexPolicy.DEBUG_INDEX_INIT) {
                                        System.out.println(String.valueOf(IndexedRelationsSearcherBase.this.getDescriptor()) + "index " + fs[i2].name() + " = " + value + " : Long");
                                    }
                                    fs[i2].setValue(String.valueOf((Long)value));
                                }
                                ++i2;
                            }
                            try {
                                try {
                                    ((IndexWriter)writer.get()).addDocument(document);
                                }
                                catch (CorruptIndexException e) {
                                    throw new DatabaseException((Throwable)e);
                                }
                                catch (IOException e) {
                                    throw new DatabaseException((Throwable)e);
                                }
                            }
                            finally {
                                mon.worked(1);
                            }
                        }
                    }
                });
                ((IndexWriter)writer.get()).commit();
                if (IndexPolicy.PERF_INDEX_INIT) {
                    long end = System.nanoTime();
                    System.out.println(String.valueOf(this.getDescriptor()) + "Wrote index at " + this.indexPath + " in " + 1.0E-9 * (double)(end - (Long)start.get()) + " seconds.");
                }
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
                try {
                    this.closeWriter(writer.getAndSet(null));
                }
                finally {
                    ((FSDirectory)directory.getAndSet(null)).close();
                }
            }
        }
        finally {
            try {
                this.closeWriter(writer.getAndSet(null));
            }
            finally {
                ((FSDirectory)directory.getAndSet(null)).close();
            }
        }
    }

    List<Map<String, Object>> doSearch(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, DatabaseException {
        if (search.isEmpty()) {
            return Collections.emptyList();
        }
        this.assertAccessOpen(false);
        QueryParser parser = new QueryParser(Version.LUCENE_30, "Name", this.analyzer);
        parser.setAllowLeadingWildcard(true);
        Query query = parser.parse(search);
        long start = System.nanoTime();
        maxResultCount = Math.min(maxResultCount, this.searcher.maxDoc());
        if (maxResultCount == 0) {
            return Collections.emptyList();
        }
        final TopDocs docs = this.searcher.search(query, null, maxResultCount);
        if (IndexPolicy.PERF_INDEX_QUERY) {
            long end = System.nanoTime();
            System.out.println(String.valueOf(this.getDescriptor()) + "search(" + search + ", " + maxResultCount + ") into index at " + this.indexPath + " took " + 1.0E-9 * (double)(end - start) + " seconds.");
        }
        if (docs.totalHits == 0) {
            return Collections.emptyList();
        }
        return (List)processor.syncRequest((Read)new Read<List<Map<String, Object>>>(){

            public List<Map<String, Object>> perform(ReadGraph graph) throws DatabaseException {
                GenericRelation r = (GenericRelation)graph.adapt(IndexedRelationsSearcherBase.this.relation, GenericRelation.class);
                if (r == null) {
                    throw new DatabaseException("Given resource " + (String)graph.syncRequest((Read)new SafeName(IndexedRelationsSearcherBase.this.relation)) + "could not be adapted to GenericRelation.");
                }
                THashMap classMap = new THashMap();
                Pair[] pairArray = r.getFields();
                int n = pairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Pair field = pairArray[n2];
                    classMap.put((String)field.first, (Class)field.second);
                    ++n2;
                }
                SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(docs.scoreDocs.length);
                ScoreDoc[] scoreDocArray = docs.scoreDocs;
                int n3 = docs.scoreDocs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ScoreDoc scoreDoc = scoreDocArray[n4];
                    try {
                        Document doc = IndexedRelationsSearcherBase.this.reader.document(scoreDoc.doc);
                        List fs = doc.getFields();
                        THashMap entry = new THashMap(fs.size());
                        for (Fieldable f : fs) {
                            Class clazz = (Class)classMap.get(f.name());
                            if (String.class.equals((Object)clazz)) {
                                entry.put(f.name(), f.stringValue());
                                continue;
                            }
                            entry.put(f.name(), support.getResource(Long.parseLong(f.stringValue())));
                        }
                        result.add((Map<String, Object>)entry);
                    }
                    catch (CorruptIndexException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                    ++n4;
                }
                return result;
            }
        });
    }

    protected static File getIndexDirectory(Session session, Resource relation, Resource input) {
        File path = DatabaseIndexing.getIndexLocation(session, relation, input);
        return path;
    }

    private static void createDirectory(File path) throws IOException {
        if (path.exists() && !path.isDirectory()) {
            throw new IOException("Could not create index directory " + path + ", a file by that name already exists");
        }
        path.mkdirs();
        if (!path.exists()) {
            throw new IOException("Could not create index directory " + path + " for an unknown reason");
        }
        if (!path.isDirectory()) {
            throw new IOException("Could not create index directory " + path + ", a file by that name already exists");
        }
    }

    File getIndexPath() {
        return this.indexPath;
    }

    boolean isIndexAvailable() {
        return this.indexPath.exists() && this.indexPath.isDirectory();
    }

    Throwable bestEffortClear(IProgressMonitor monitor, Session session) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Throwable clearDirectory(IProgressMonitor monitor, Session session) {
        File file = this.getIndexPath();
        try {
            int i = 0;
            while (true) {
                if (i >= 15) {
                    return new IllegalStateException("Failed to delete directory " + file.getAbsolutePath());
                }
                FileUtils.deleteDir((File)file);
                if (!file.exists()) {
                    return null;
                }
                try {
                    Thread.sleep(i * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable t) {
            return t;
        }
    }

    static final class LowerCaseWhitespaceAnalyzer
    extends Analyzer {
        LowerCaseWhitespaceAnalyzer() {
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseWhitespaceTokenizer(reader);
        }

        public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            Object tokenizer = (Tokenizer)this.getPreviousTokenStream();
            if (tokenizer == null) {
                tokenizer = new LowerCaseWhitespaceTokenizer(reader);
                this.setPreviousTokenStream(tokenizer);
            } else {
                tokenizer.reset(reader);
            }
            return tokenizer;
        }
    }

    static final class LowerCaseWhitespaceTokenizer
    extends CharTokenizer {
        @Deprecated
        public LowerCaseWhitespaceTokenizer(Reader in) {
            super(in);
        }

        @Deprecated
        public LowerCaseWhitespaceTokenizer(AttributeSource source, Reader in) {
            super(source, in);
        }

        @Deprecated
        public LowerCaseWhitespaceTokenizer(AttributeSource.AttributeFactory factory, Reader in) {
            super(factory, in);
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }

        protected boolean isTokenChar(char c) {
            return !Character.isWhitespace(c);
        }

        protected boolean isTokenChar(int c) {
            return !Character.isWhitespace(c);
        }
    }

    protected static enum State {
        NONE,
        PROBLEM,
        READY,
        READ,
        WRITE;

    }
}

