/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.utils.datastructures.Pair;

public class IndexedRelationsMemorySearcher
extends IndexedRelationsSearcherBase {
    final IndexedRelationsSearcher backend;
    final GenericRelation r;
    TLongHashSet changed = new TLongHashSet();

    IndexedRelationsMemorySearcher(RequestProcessor session, IndexedRelationsSearcher backend, Resource relation, Resource input, GenericRelation r) throws DatabaseException {
        super(session, relation, input);
        this.backend = backend;
        this.r = r;
        this.setReady();
    }

    @Override
    String getDescriptor() {
        return "MEM: ";
    }

    @Override
    void insertIndex(IProgressMonitor monitor, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        for (Object[] o : documentsData) {
            Long resource = (Long)o[1];
            this.changed.add(resource.longValue());
        }
        super.insertIndex(monitor, r, boundLength, documentsData);
    }

    @Override
    boolean replaceIndex(IProgressMonitor monitor, String key, Collection<Object> keyValues, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        for (Object[] o : documentsData) {
            Long resource = (Long)o[1];
            this.changed.add(resource.longValue());
        }
        return super.replaceIndex(monitor, key, keyValues, r, boundLength, documentsData);
    }

    @Override
    void removeIndex(IProgressMonitor monitor, GenericRelation r, RequestProcessor processor, String key, Collection<Object> keyValues) throws DatabaseException, CorruptIndexException, IOException {
        for (Object o : keyValues) {
            Resource resource = (Resource)o;
            this.changed.add(resource.getResourceId());
        }
        super.removeIndex(monitor, r, processor, key, keyValues);
    }

    public List<Object[]> allDocs(IProgressMonitor monitor, Session session) throws ParseException, IOException, DatabaseException {
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        this.startAccess(null, session, false);
        TopDocs td = this.searcher.search((Query)query, Integer.MAX_VALUE);
        ScoreDoc[] scoreDocs = td.scoreDocs;
        ArrayList<Object[]> result = new ArrayList<Object[]>(scoreDocs.length);
        THashMap classMap = new THashMap();
        Pair[] pairArray = this.r.getFields();
        int n = pairArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pair field = pairArray[n2];
            classMap.put((String)field.first, (Class)field.second);
            ++n2;
        }
        pairArray = scoreDocs;
        n = scoreDocs.length;
        n2 = 0;
        while (n2 < n) {
            Pair scoreDoc = pairArray[n2];
            try {
                Document doc = this.reader.document(scoreDoc.doc);
                List fs = doc.getFields();
                Object[] o = new Object[fs.size()];
                int index = 0;
                for (Fieldable f : fs) {
                    Class clazz = (Class)classMap.get(f.name());
                    o[index++] = String.class.equals((Object)clazz) ? f.stringValue() : Long.valueOf(Long.parseLong(f.stringValue()));
                }
                result.add(o);
            }
            catch (CorruptIndexException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
            ++n2;
        }
        this.changeState(monitor, session, IndexedRelationsSearcherBase.State.READY);
        return result;
    }

    public void commit() {
        try {
            if (this.writer != null) {
                this.writer.commit();
            }
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    Directory getDirectory(Session session) throws IOException {
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        String path = this.indexPath.getAbsolutePath();
        return mem.getDirectory(path, (Analyzer)IndexedRelationsMemorySearcher.getAnalyzer());
    }

    @Override
    Throwable bestEffortClear(IProgressMonitor monitor, Session session) {
        this.setProblem(null);
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        this.changed.clear();
        String path = this.indexPath.getAbsolutePath();
        mem.remove(path);
        return null;
    }
}

