/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.queryParser.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.IndexPolicy;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.IndexException;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.datastructures.Pair;

public class IndexedRelationsImpl
implements IndexedRelations {
    Map<Object, RWLock> indexLocks = new WeakHashMap<Object, RWLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockHandle lock(RequestProcessor processor, Object lockIdentifier, boolean write) {
        RWLock rwlock = null;
        Map<Object, RWLock> map = this.indexLocks;
        synchronized (map) {
            rwlock = this.indexLocks.get(lockIdentifier);
            if (rwlock == null) {
                rwlock = new RWLock(lockIdentifier);
                this.indexLocks.put(lockIdentifier, rwlock);
            }
        }
        return rwlock.lock(processor, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockHandle tryLock(RequestProcessor processor, Object lockIdentifier, boolean write) {
        RWLock rwlock = null;
        Map<Object, RWLock> map = this.indexLocks;
        synchronized (map) {
            rwlock = this.indexLocks.get(lockIdentifier);
            if (rwlock == null) {
                rwlock = new RWLock(lockIdentifier);
                this.indexLocks.put(lockIdentifier, rwlock);
            }
        }
        return rwlock.tryLock(processor, write);
    }

    private IndexedRelationsSearcherBase makeSearcher(final RequestProcessor processor, final Resource relation, final Resource input) {
        try {
            return (IndexedRelationsSearcherBase)processor.syncRequest((Read)new UniqueRead<IndexedRelationsSearcherBase>(){

                public IndexedRelationsSearcherBase perform(ReadGraph graph) throws DatabaseException {
                    if (graph.isImmutable(input)) {
                        return MemoryIndexing.getInstance(processor.getSession()).getImmutable(processor, relation, input);
                    }
                    return MemoryIndexing.getInstance(processor.getSession()).get(processor, relation, input);
                }
            });
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    private LockHandle waitLoaded(SubMonitor progress, final IndexedRelationsSearcherBase searcher, RequestProcessor processor, LockHandle lock, final Object lockId, final Resource input) throws IndexException {
        if (searcher.isIndexAvailable()) {
            searcher.startAccess((IProgressMonitor)progress.newChild(50), processor.getSession(), false);
            if (searcher.hasAccess(false)) {
                return lock;
            }
            if (searcher.checkState(IndexedRelationsSearcherBase.State.PROBLEM)) {
                throw new IndexException("Searcher is in problematic state", searcher.getException());
            }
        }
        if (!searcher.checkState(IndexedRelationsSearcherBase.State.NONE)) {
            throw new IndexException("Illegal searcher state, contact application support.");
        }
        while (true) {
            if (processor instanceof ReadGraph) {
                try {
                    SerialisationSupport ss = (SerialisationSupport)processor.getService(SerialisationSupport.class);
                    searcher.initializeIndex((IProgressMonitor)progress.newChild(40), (ReadGraph)processor, new Object[]{ss.getRandomAccessId(input)}, true);
                    searcher.setReady();
                    searcher.startAccess((IProgressMonitor)progress.newChild(10), processor.getSession(), false);
                    if (!searcher.hasAccess(false)) continue;
                    return lock;
                }
                catch (IOException e) {
                    searcher.setProblem(e);
                    throw new IndexException((Throwable)e);
                }
                catch (DatabaseException e) {
                    searcher.setProblem(e);
                    throw new IndexException((Throwable)e);
                }
            }
            lock.unlock();
            boolean success = false;
            int tries = 0;
            while (!success && ++tries < 10) {
                try {
                    success = (Boolean)processor.sync((ReadInterface)new UniqueRead<Boolean>(){

                        public Boolean perform(ReadGraph graph) throws DatabaseException {
                            block10: {
                                LockHandle lock = IndexedRelationsImpl.this.tryLock((RequestProcessor)graph, lockId, true);
                                if (lock == null) {
                                    return false;
                                }
                                try {
                                    boolean loaded = false;
                                    if (searcher.isIndexAvailable()) {
                                        searcher.startAccess(null, graph.getSession(), false);
                                        if (searcher.hasAccess(false)) {
                                            loaded = true;
                                        }
                                        if (searcher.checkState(IndexedRelationsSearcherBase.State.PROBLEM)) {
                                            throw new DatabaseException("Searcher is in problematic state", searcher.getException());
                                        }
                                    }
                                    if (loaded) break block10;
                                    if (!searcher.checkState(IndexedRelationsSearcherBase.State.NONE)) {
                                        throw new DatabaseException("Illegal searcher state, contact application support.");
                                    }
                                    try {
                                        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                                        searcher.initializeIndex(null, graph, new Object[]{ss.getRandomAccessId(input)}, true);
                                        searcher.setReady();
                                    }
                                    catch (IOException e) {
                                        searcher.setProblem(e);
                                        throw new DatabaseException((Throwable)e);
                                    }
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (DatabaseException e) {
                    throw new IndexException((Throwable)e);
                }
            }
            if (!success) {
                throw new IndexException("Did not manage to load index. Contact application support.");
            }
            lock = this.lock(processor, lockId, true);
            if (searcher.isIndexAvailable()) break;
        }
        searcher.startAccess((IProgressMonitor)progress.newChild(50), processor.getSession(), false);
        if (searcher.hasAccess(false)) {
            return lock;
        }
        throw new IndexException("Illegal searcher state, contact application support.");
    }

    public List<Map<String, Object>> query(IProgressMonitor monitor, String search, RequestProcessor processor, Resource relation, Resource input, int maxResultCount) {
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (search == null) {
            throw new IllegalArgumentException("null search criterion");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = this.makeSearcher(processor, relation, input);
        Pair lockId = Pair.make((Object)relation, (Object)input);
        LockHandle lock = this.lock(processor, lockId, false);
        lock = this.waitLoaded(progress, searcher, processor, lock, lockId, input);
        try {
            List<Map<String, Object>> list = searcher.doSearch((IProgressMonitor)progress.newChild(50), processor, search, maxResultCount);
            return list;
        }
        catch (ParseException e) {
            e.printStackTrace();
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new IndexException((Throwable)e);
        }
        catch (DatabaseException e) {
            throw new IndexException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void insert(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, Collection<Object[]> documents) {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (documents == null) {
            throw new IllegalArgumentException("null documents");
        }
        if (documents.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = this.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return;
            }
            try {
                searcher.insertIndex((IProgressMonitor)progress.newChild(40), relation, 1, documents);
                DatabaseIndexing.markIndexChanged(searcher.getIndexPath());
            }
            catch (InvalidResourceReferenceException e) {
                throw new IndexException((ServiceException)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    public void remove(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, String key, Collection<Object> keyValues) {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = this.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return;
            }
            try {
                searcher.removeIndex((IProgressMonitor)progress.newChild(40), relation, processor, key, keyValues);
                DatabaseIndexing.markIndexChanged(searcher.getIndexPath());
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    public void removeAll(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input) {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        IndexedRelationsSearcherBase searcher = this.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            Throwable t = searcher.bestEffortClear(monitor, processor.getSession());
            if (t != null) {
                searcher.setProblem(t);
            } else {
                searcher.setNone();
            }
        }
        finally {
            handle.unlock();
        }
    }

    public boolean replace(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, String key, Collection<Object> keyValues, Collection<Object[]> documents) {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = this.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        boolean didChange = false;
        try {
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return true;
            }
            try {
                didChange = searcher.replaceIndex((IProgressMonitor)progress.newChild(40), key, keyValues, relation, 1, documents);
                if (didChange) {
                    DatabaseIndexing.markIndexChanged(searcher.getIndexPath());
                }
            }
            catch (InvalidResourceReferenceException e) {
                throw new IndexException((ServiceException)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
            catch (Throwable t) {
                throw new IndexException(t);
            }
        }
        finally {
            handle.unlock();
        }
        return didChange;
    }

    public void reset(IProgressMonitor monitor, RequestProcessor processor, Resource relationResource, Resource input) throws IndexException {
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            try {
                File path = DatabaseIndexing.getIndexLocation(Simantics.getSession(), relationResource, input);
                DatabaseIndexing.deleteIndex(path);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    static class LockHandle {
        public final Object id;
        public final Lock lock;

        public LockHandle(Object id, Lock lock) {
            this.id = id;
            this.lock = lock;
        }

        public void unlock() {
            if (IndexPolicy.TRACE_INDEX_LOCKING) {
                System.out.println("Unlocking index " + this.id);
            }
            this.lock.unlock();
        }
    }

    static class RWLock {
        public final Object id;
        public final ReentrantReadWriteLock lock;

        public RWLock(Object id) {
            this.id = id;
            this.lock = new ReentrantReadWriteLock(true);
        }

        LockHandle lock(RequestProcessor processor, boolean write) {
            Lock l;
            Lock lock = l = write ? this.lock.writeLock() : this.lock.readLock();
            if (processor instanceof ReadGraph) {
                ReadGraph graph = (ReadGraph)processor;
                while (!l.tryLock()) {
                    QueryControl qc = (QueryControl)processor.getService(QueryControl.class);
                    boolean executed = qc.resume((AsyncReadGraph)graph);
                    if (executed) continue;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else {
                l.lock();
            }
            if (IndexPolicy.TRACE_INDEX_LOCKING) {
                System.out.println("Locked index " + this.id);
            }
            return new LockHandle(this.id, l);
        }

        LockHandle tryLock(RequestProcessor processor, boolean write) {
            Lock l;
            Lock lock = l = write ? this.lock.writeLock() : this.lock.readLock();
            if (l.tryLock()) {
                return new LockHandle(this.id, l);
            }
            return null;
        }
    }
}

