/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

public class IndexUtils {
    public static Collection<Map<String, Object>> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        ArrayList<Map<String, Object>> indexResult = (ArrayList<Map<String, Object>>)graph.syncRequest((Read)new QueryIndex(index, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        ArrayList<Map<String, Object>> result = indexResult;
        for (Resource dep : linkedRoots) {
            Collection<Map<String, Object>> linkedIndexResults = IndexUtils.find(graph, dep, filter);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = new ArrayList<Map<String, Object>>(indexResult.size() + linkedIndexResults.size());
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        return result;
    }

    public static Collection<Resource> findByName(ReadGraph graph, Resource model, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> results = new HashSet<Resource>();
        String search = "Name:" + name;
        for (Map<String, Object> entry : IndexUtils.find(graph, model, search)) {
            Resource resource = (Resource)entry.get("Resource");
            if (!name.equals(graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING))) continue;
            results.add(resource);
        }
        return results;
    }

    public static Collection<Resource> findByType(ReadGraph graph, Resource model, Resource type) throws DatabaseException {
        HashSet<Resource> results = new HashSet<Resource>();
        String search = "Types:*" + NameUtils.getSafeName((ReadGraph)graph, (Resource)type);
        for (Map<String, Object> entry : IndexUtils.find(graph, model, search)) {
            Resource resource = (Resource)entry.get("Resource");
            if (!graph.isInstanceOf(resource, type)) continue;
            results.add(resource);
        }
        return results;
    }

    public static Collection<Resource> findByTypeAndName(ReadGraph graph, Resource model, Resource type, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> results = new HashSet<Resource>();
        String search = "Types:*" + type + " AND Name:" + name;
        for (Map<String, Object> entry : IndexUtils.find(graph, model, search)) {
            Resource resource = (Resource)entry.get("Resource");
            if (!graph.isInstanceOf(resource, type) || !name.equals(graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING))) continue;
            results.add(resource);
        }
        return results;
    }

    public static void flushIndexCaches(IProgressMonitor progress, Session session) throws Exception {
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        mem.flush(progress);
    }

    static class QueryIndex
    extends BinaryRead<Resource, String, Collection<Map<String, Object>>> {
        public QueryIndex(Resource index, String filter) {
            super((Object)index, (Object)filter);
        }

        public Collection<Map<String, Object>> perform(ReadGraph graph) throws DatabaseException {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            Function dependencies = (Function)graph.syncRequest((Read)new Adapter(L0X.Dependencies, Function.class), (Listener)TransientCacheListener.instance());
            Collection results = (Collection)dependencies.apply((Object)graph, this.parameter, this.parameter2);
            if (results == null || results.isEmpty()) {
                return Collections.emptyList();
            }
            return results;
        }
    }
}

