/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.Activator;
import org.simantics.db.indexing.IndexPolicy;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.layer0.util.Simantics;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.ServerInformation;
import org.simantics.utils.FileUtils;

public final class DatabaseIndexing {
    private static final boolean DEBUG = IndexPolicy.TRACE_INDEX_MANAGEMENT;

    public static File getIndexBaseLocation() {
        return Activator.getDefault().getIndexBaseFile();
    }

    public static File getIndexLocation(Session session, Resource relation, Resource input) {
        if (session == null) {
            throw new NullPointerException("null session");
        }
        if (relation == null) {
            throw new NullPointerException("null relation");
        }
        if (input == null) {
            throw new NullPointerException("null input");
        }
        String dir = String.valueOf(((ServerInformation)session.getService(ServerInformation.class)).getDatabaseId()) + "." + relation.getResourceId() + "." + input.getResourceId();
        return new File(DatabaseIndexing.getIndexBaseLocation(), dir);
    }

    private static File getAllDirtyFile() {
        return new File(DatabaseIndexing.getIndexBaseLocation(), ".dirty");
    }

    private static File getChangedFile(File indexPath) {
        return new File(indexPath, ".changed");
    }

    public static void markAllDirty() throws IOException {
        File indexBase = DatabaseIndexing.getIndexBaseLocation();
        if (!indexBase.exists() || !indexBase.isDirectory()) {
            return;
        }
        if (DEBUG) {
            System.out.println("Marking all indexes dirty");
        }
        DatabaseIndexing.getAllDirtyFile().createNewFile();
    }

    public static void clearAllDirty() throws IOException {
        File indexBase;
        if (DEBUG) {
            System.out.println("Clearing dirty state of all indexes");
        }
        if (!(indexBase = DatabaseIndexing.getIndexBaseLocation()).exists() || !indexBase.isDirectory()) {
            return;
        }
        DatabaseIndexing.delete(DatabaseIndexing.getAllDirtyFile());
        DatabaseIndexing.forEachIndexPath(new Procedure<File, IOException>(){

            @Override
            public void execute(File indexPath) throws IOException {
                DatabaseIndexing.delete(DatabaseIndexing.getChangedFile(indexPath));
            }
        });
    }

    static void markIndexChanged(File indexPath) {
        if (!indexPath.exists()) {
            throw new IllegalArgumentException("index path " + indexPath + " does not exist");
        }
        if (!indexPath.isDirectory()) {
            throw new IllegalArgumentException("index path " + indexPath + " is not a directory");
        }
        try {
            if (DEBUG) {
                System.out.println("Marking index dirty: " + indexPath);
            }
            DatabaseIndexing.getChangedFile(indexPath).createNewFile();
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public static void deleteAllIndexes() throws IOException {
        File indexBase = DatabaseIndexing.getIndexBaseLocation();
        DatabaseIndexing.delete(indexBase);
    }

    public static void deleteIndex(final Resource relation, final Resource modelPart) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource model = (Resource)graph.syncRequest((Read)new Model(modelPart));
                GenericRelationIndex index = (GenericRelationIndex)graph.adapt(relation, GenericRelationIndex.class);
                IndexedRelations ir = (IndexedRelations)graph.getService(IndexedRelations.class);
                ir.reset(null, (RequestProcessor)graph, relation, model);
                index.reset((RequestProcessor)graph, model);
            }
        });
    }

    public static void deleteIndex(File indexPath) throws IOException {
        if (DEBUG) {
            System.out.println("Deleting index " + indexPath);
        }
        DatabaseIndexing.delete(indexPath);
    }

    public static void validateIndexes() throws IOException {
        File indexBase = DatabaseIndexing.getIndexBaseLocation();
        if (DEBUG) {
            System.out.println("Validating indexes at " + indexBase);
        }
        if (!indexBase.exists()) {
            return;
        }
        if (!indexBase.isDirectory()) {
            if (DEBUG) {
                System.out.println(indexBase + " is not a directory! Removing it.");
            }
            DatabaseIndexing.delete(indexBase);
            indexBase.mkdirs();
            return;
        }
        File allDirtyFile = DatabaseIndexing.getAllDirtyFile();
        if (allDirtyFile.isFile()) {
            if (DEBUG) {
                System.out.println("All indexes marked dirty, removing them.");
            }
            DatabaseIndexing.delete(allDirtyFile);
            DatabaseIndexing.deleteAllIndexes();
        } else {
            DatabaseIndexing.forEachIndexPath(new Procedure<File, IOException>(){

                @Override
                public void execute(File indexPath) throws IOException {
                    File changed = DatabaseIndexing.getChangedFile(indexPath);
                    if (changed.isFile()) {
                        if (DEBUG) {
                            System.out.println("Index is dirty, removing: " + indexPath);
                        }
                        DatabaseIndexing.deleteIndex(indexPath);
                    }
                }
            });
        }
    }

    private static void delete(File fileOrDir) throws IOException {
        if (fileOrDir.exists()) {
            FileUtils.deleteAll((File)fileOrDir);
        }
    }

    private static <E extends Throwable> void forEachIndexPath(Procedure<File, E> callback) throws E {
        File[] fileArray = DatabaseIndexing.getIndexBaseLocation().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File indexPath = fileArray[n2];
            callback.execute(indexPath);
            ++n2;
        }
    }

    static interface Procedure<T, E extends Throwable> {
        public void execute(T var1) throws E;
    }
}

