/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodeRequest;
import org.simantics.document.server.request.NodeRequestUtils;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

class NodeRequestStatic
extends VariableRead<JSONObject> {
    public NodeRequestStatic(Variable node) {
        super(node);
    }

    public JSONObject perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2.getInstance((ReadGraph)graph);
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        String id = DocumentServerUtils.getId(graph, this.variable);
        Binding jsonBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(JSONObject.class);
        JSONObject object = new JSONObject(jsonBinding, id);
        Resource type = this.variable.getType(graph);
        Variable parentConnectionPoint = DocumentServerUtils.getParentConnectionPoint(graph, this.variable);
        if (parentConnectionPoint != null) {
            String parent = DocumentServerUtils.getId(graph, parentConnectionPoint.getParent(graph));
            Resource cp = parentConnectionPoint.getPossiblePredicateResource(graph);
            String i = (String)graph.getRelatedValue(cp, DOC.Document_ChildRelation_ordinal, (Binding)Bindings.STRING);
            object.addJSONField("parent", parent);
            object.addJSONField("parentOrd", i);
        } else {
            if (DOC.Components_Root.equals(type) || graph.isInheritedFrom(type, DOC.Components_Root)) {
                object.addJSONField("parent", "root");
                object.addJSONField("parentOrd", "0");
            }
            if (!graph.isInheritedFrom(type, DOC.Components_ParentlessComponent)) {
                object.addJSONField("parent", "");
                object.addJSONField("parentOrd", "0");
            }
        }
        object.addJSONField("id", id);
        object.addJSONField("type", graph.getRelatedValue(type, L0.HasName, (Binding)Bindings.STRING));
        for (Variable attrib : DocumentServerUtils.getStaticAttributes(graph, this.variable)) {
            String name = attrib.getName(graph);
            try {
                Object value = DocumentServerUtils.getValue(graph, attrib);
                object.addJSONField(name, value);
            }
            catch (Throwable t) {
                ArrayList<String> errorList = (ArrayList<String>)object.getJSONField(NodeRequest.ERRORS);
                if (errorList == null) {
                    errorList = new ArrayList<String>();
                }
                String errorMessage = NodeRequestUtils.formatErrorMessage(name, t);
                errorList.add(errorMessage);
                object.addJSONField(NodeRequest.ERRORS, errorList);
            }
        }
        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("NodeRequestStatic " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms." + (Object)((Object)object));
        }
        return object;
    }
}

