/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodeRequest;
import org.simantics.document.server.request.NodeRequestUtils;
import org.simantics.structural.stubs.StructuralResource2;

class NodeRequestDynamic
extends VariableRead<Map<String, Object>> {
    public NodeRequestDynamic(Variable node) {
        super(node);
    }

    public Map<String, Object> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        StructuralResource2.getInstance((ReadGraph)graph);
        Collection<Variable> attributes = DocumentServerUtils.getDynamicAttributes(graph, this.variable);
        if (attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Variable attrib : attributes) {
            String name = attrib.getName(graph);
            try {
                Object value = DocumentServerUtils.getValue(graph, attrib);
                result.put(name, value);
            }
            catch (Throwable t) {
                ArrayList<String> errorList = (ArrayList<String>)result.get(NodeRequest.ERRORS);
                if (errorList == null) {
                    errorList = new ArrayList<String>();
                }
                String errorMessage = NodeRequestUtils.formatErrorMessage(name, t);
                errorList.add(errorMessage);
                result.put(NodeRequest.ERRORS, errorList);
            }
        }
        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("NodeRequestDynamic " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms." + result);
        }
        return result;
    }
}

