/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodeRequestDynamic;
import org.simantics.document.server.request.NodeRequestStatic;

class NodeRequest
extends VariableRead<JSONObject> {
    public static String ERRORS = "Errors";

    public NodeRequest(Variable node) {
        super(node);
    }

    public JSONObject perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        JSONObject staticContent = (JSONObject)((Object)graph.syncRequest((Read)new NodeRequestStatic(this.variable)));
        Map dynamicContent = (Map)graph.syncRequest((Read)new NodeRequestDynamic(this.variable));
        if (dynamicContent.isEmpty()) {
            return staticContent;
        }
        JSONObject result = staticContent.clone();
        result.add(dynamicContent);
        if (dynamicContent.containsKey(ERRORS) || staticContent.getJSONField(ERRORS) != null) {
            ArrayList errorList = new ArrayList();
            if (dynamicContent.containsKey(ERRORS)) {
                errorList.addAll((List)dynamicContent.get(ERRORS));
            }
            if (staticContent.getJSONField(ERRORS) != null) {
                errorList.addAll((List)staticContent.getJSONField(ERRORS));
            }
            result.addJSONField(ERRORS, errorList);
        }
        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("NodeRequest " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms." + (Object)((Object)result));
        }
        return result;
    }
}

