/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.NodeRequest;
import org.simantics.document.server.request.NodesRequest;

public class DocumentRequest
extends VariableRead<Collection<JSONObject>> {
    public static boolean PROFILE = false;

    public DocumentRequest(Variable var) {
        super(var);
    }

    public Collection<JSONObject> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        Set nodes = (Set)graph.syncRequest((Read)new NodesRequest(this.variable));
        HashSet<JSONObject> rs = new HashSet<JSONObject>();
        if (nodes.isEmpty()) {
            rs.add(this.rootErrorEntry(0));
            return rs;
        }
        for (Variable node : nodes) {
            rs.add((JSONObject)((Object)graph.sync((ReadInterface)new NodeRequest(node))));
        }
        if (PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("DocumentRequest " + System.identityHashCode((Object)this) + " " + this.variable.getURI(graph) + " in " + 1.0E-6 * (double)dura + "ms.");
        }
        return rs;
    }

    private JSONObject rootErrorEntry(int foundRoots) {
        String id = "RootErrorLabel";
        String message = foundRoots == 0 ? "Error: Document should have one root element" : "Error: Document should have one root element. (found " + foundRoots + ")";
        JSONObject result = new JSONObject(id);
        result.addJSONField("parent", "root");
        result.addJSONField("parentOrd", "0");
        result.addJSONField("id", id);
        result.addJSONField("type", "Label");
        result.addJSONField("text", message);
        return result;
    }
}

