/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.HashMap;
import java.util.Map;
import org.cojen.classfile.TypeDesc;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.document.server.request.ReadComponentTypeInterfaceRequest;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.requests.SCLOsgiRequest;
import org.simantics.scl.compiler.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.codegen.types.TypeConstructor;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.EGetContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.BasicMacroRule;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.CompositeModule;
import org.simantics.scl.compiler.elaboration.modules.ContextModule;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ExpressionInterfaceDescription;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.top.SCLExpressionCompiler;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.structural2.scl.CompiledExpression;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;
import org.simantics.structural2.scl.StructuralComponent;

public abstract class CompileSCLValueRequest
extends BinaryRead<Resource, Resource, CompiledExpression> {
    private static SCLOsgi ENVIRONMENT = SCLOsgi.INSTANCE;
    private static final String CONTEXT_MODULE = "Flattening/Context";
    private static final String DB_MODULE = "Simantics/DB";
    public static final TCon STRUCTURAL_COMPONENT = Types.con((String)"Flattening/Context", (String)"StructuralComponent");
    public static final TCon RESOURCE = Types.con((String)"Flattening/Context", (String)"Resource");
    public static final TCon BINDING = Types.con((String)"Flattening/Context", (String)"Binding");
    public static final TCon READ_GRAPH_SCL = Types.con((String)"Flattening/Context", (String)"ReadGraph");
    public static final TVar VALUE = Types.var((Kind)Kinds.STAR);
    private static final TypeConstructor STRUCTURAL_COMPONENT_TYPE_CONSTRUCTOR = new StandardTypeConstructor(STRUCTURAL_COMPONENT, (Kind)Kinds.STAR, TypeDesc.forClass(StructuralComponent.class));
    private static final TypeConstructor READ_GRAPH_TYPE_CONSTRUCTOR = new StandardTypeConstructor(READ_GRAPH_SCL, (Kind)Kinds.STAR, TypeDesc.forClass(ReadGraph.class));
    private static final TypeConstructor RESOURCE_TYPE_CONSTRUCTOR = new StandardTypeConstructor(RESOURCE, (Kind)Kinds.STAR, TypeDesc.forClass(Resource.class));
    private static final TypeConstructor BINDING_TYPE_CONSTRUCTOR = new StandardTypeConstructor(BINDING, (Kind)Kinds.STAR, TypeDesc.forClass(Binding.class));
    private static SCLValue GET_METHOD = null;
    private static SCLValue FROM_DOUBLE = null;
    private static final TVar A = Types.var((Kind)Kinds.STAR);
    private static final ExpressionInterfaceDescription<CompiledExpression> INTERFACE_DESCRIPTION = new ExpressionInterfaceDescription(CompiledExpression.class, new TVar[]{A}, false, (Type)A, "evaluate", new Type[]{READ_GRAPH_SCL, STRUCTURAL_COMPONENT});

    public CompileSCLValueRequest(ReadGraph graph, Variable property) throws DatabaseException {
        super((Object)property.getRepresents(graph), (Object)CompileSCLValueRequest.type(graph, property));
    }

    private static Resource type(ReadGraph graph, Variable property) throws DatabaseException {
        Variable component = property.getParent(graph);
        if (component.getPossibleRepresents(graph) != null) {
            return (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(component.getRepresents(graph)));
        }
        if (component.getParent(graph) != null) {
            return component.getParent(graph).getType(graph);
        }
        return component.getType(graph);
    }

    public CompiledExpression perform(ReadGraph graph) throws DatabaseException {
        Resource mainModule;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource componentType = (Resource)this.parameter2;
        final Map<String, ComponentTypeProperty> propertyMap = this.getPropertyMap(graph, componentType);
        String expressionText = (String)graph.getRelatedValue((Resource)this.parameter, L0.SCLValue_expression, (Binding)Bindings.STRING);
        Object oldGraph = SCLContext.getCurrent().put((Object)"graph", (Object)graph);
        CompositeModule environmentModule = ENVIRONMENT.createEnvironmentModule();
        environmentModule.add(null, CONTEXT_MODULE);
        environmentModule.add(null, DB_MODULE);
        Resource model = null;
        if (componentType != null) {
            model = (Resource)graph.syncRequest((Read)new PossibleModel(componentType));
        } else {
            Resource owner = graph.getPossibleObject((Resource)this.parameter, L0.IsOwnedBy);
            if (owner != null) {
                model = (Resource)graph.syncRequest((Read)new PossibleModel(owner));
            }
        }
        if (model != null && (mainModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)model, (String)"SCLMain")) != null) {
            graph.getPossibleRelatedValue(mainModule, L0.SCLModule_definition, (Binding)Bindings.STRING);
            environmentModule.add("", graph.getURI(mainModule));
            graph.syncRequest((ExternalRead)SCLOsgiRequest.make());
        }
        if (GET_METHOD == null) {
            try {
                GET_METHOD = ENVIRONMENT.getValueCache().getValueRef("Flattening/Context/getValue");
            }
            catch (ValueNotFound e) {
                e.printStackTrace();
            }
        }
        if (FROM_DOUBLE == null) {
            try {
                FROM_DOUBLE = ENVIRONMENT.getValueCache().getValueRef("Prelude/fromDouble");
            }
            catch (ValueNotFound e) {
                e.printStackTrace();
            }
        }
        this.addEnvironmentModules(environmentModule);
        environmentModule.add("", (Module)new ContextModule("ExpressionContext"){

            protected Expression createValueExpression(String name) {
                ComponentTypeProperty property = (ComponentTypeProperty)propertyMap.get(name);
                if (property == null) {
                    return null;
                }
                Type type = property.type;
                Binding binding = CompileSCLValueRequest.this.findBinding(type);
                return new EApply(9223372034707292160L, (Expression)new EConstant(GET_METHOD, new Type[]{type}), new Expression[]{new EGetContext(1, (Type)STRUCTURAL_COMPONENT), new EGetContext(0, (Type)READ_GRAPH_SCL), new EExternalConstant((Object)property.relation, (Type)RESOURCE), new EExternalConstant((Object)binding, (Type)BINDING)});
            }

            protected SCLValue createValue(String name) {
                final SCLValue value = super.createValue(name);
                if (value != null && value.getType().equals((Object)Types.DOUBLE)) {
                    TVar A = Types.var((Kind)Kinds.STAR);
                    value.setType((Type)Types.forAll((TVar)A, (Type)Types.constrained((TPred)Types.pred((TCon)Types.REAL, (Type[])new Type[]{A}), (Type)A)));
                    value.setMacroRule((MacroRule)new BasicMacroRule(1){

                        public Expression apply(SimplificationContext context, Type[] typeParameters, Expression[] parameters) {
                            EApply result = new EApply(9223372034707292160L, (Expression)new EConstant(FROM_DOUBLE, new Type[]{typeParameters[0]}), new Expression[]{parameters[0], value.getExpression()});
                            return result;
                        }
                    });
                    value.setInlineInSimplification(false);
                }
                return value;
            }

            public TypeConstructor getTypeConstructor(TCon type) {
                if (type.name.equals("ReadGraph")) {
                    return READ_GRAPH_TYPE_CONSTRUCTOR;
                }
                if (type.name.equals("StructuralComponent")) {
                    return STRUCTURAL_COMPONENT_TYPE_CONSTRUCTOR;
                }
                if (type.name.equals("Resource")) {
                    return RESOURCE_TYPE_CONSTRUCTOR;
                }
                if (type.name.equals("Binding")) {
                    return BINDING_TYPE_CONSTRUCTOR;
                }
                return null;
            }
        });
        try {
            CompiledExpression compiledExpression = (CompiledExpression)SCLExpressionCompiler.compileExpression(INTERFACE_DESCRIPTION, (Type[])new Type[]{Types.metaVar((Kind)Kinds.STAR)}, (ClassLoader)ENVIRONMENT.getClassLoader(), (CompositeModule)environmentModule, (String)expressionText);
            return compiledExpression;
        }
        catch (SCLExpressionCompilationException e) {
            StringBuilder b = new StringBuilder();
            b.append("Couldn't compile '");
            b.append(expressionText);
            b.append("':\n");
            SCLError[] sCLErrorArray = e.getErrors();
            int n = sCLErrorArray.length;
            int n2 = 0;
            while (n2 < n) {
                SCLError error = sCLErrorArray[n2];
                b.append(error.description);
                b.append('\n');
                ++n2;
            }
            throw new DatabaseException(b.toString());
        }
        finally {
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
    }

    private Map<String, ComponentTypeProperty> getPropertyMap(ReadGraph graph, Resource componentType) throws DatabaseException {
        HashMap<String, ComponentTypeProperty> propertyMap;
        if (componentType != null) {
            propertyMap = (Map)graph.syncRequest((Read)this.getComponentTypeInterfaceRequest(componentType));
        } else {
            propertyMap = new HashMap();
            this.addComponentTypeProperties(graph, propertyMap);
        }
        return propertyMap;
    }

    protected abstract void addEnvironmentModules(CompositeModule var1);

    protected abstract void addComponentTypeProperties(ReadGraph var1, Map<String, ComponentTypeProperty> var2) throws DatabaseException;

    protected abstract Binding getBinding(Type var1);

    private Binding findBinding(Type type) {
        Binding binding = this.getBinding(type);
        if (binding == null) {
            binding = (Binding)ReadComponentTypeInterfaceRequest.bindingMap.get((Object)type);
        }
        return binding;
    }

    protected abstract ReadComponentTypeInterfaceRequest getComponentTypeInterfaceRequest(Resource var1);
}

