/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.VariableStructuralContext;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.bean.DataDefinition;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.handler.EventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.CommandResult;
import org.simantics.document.server.request.ServerSCLValueRequest;
import org.simantics.document.server.serverResponse.Error;
import org.simantics.document.server.serverResponse.ServerResponse;
import org.simantics.document.server.serverResponse.SuccessResponse;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.services.CaseInsensitiveComponentNamingStrategy2;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.project.IProject;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.procedure.Printer;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.scl.runtime.tuple.Tuple4;
import org.simantics.scl.runtime.tuple.Tuple5;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.structural2.scl.CompiledExpression;
import org.simantics.structural2.scl.StructuralComponent;
import org.simantics.structural2.variables.Connection;

public class Functions {
    @SCLValue(type="VariableMap")
    public static VariableMap inputSpaceChildren = new VariableMapImpl(){

        private Variable getProxy(ReadGraph graph, Variable context) throws DatabaseException {
            Variable root = Variables.getRootVariable((ReadGraph)graph);
            return new DocumentProxyChildVariable(context, context, root, "???");
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            if ("???".equals(name)) {
                return this.getProxy(graph, context);
            }
            return All.standardChildDomainChildren.getVariable(graph, context, name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            if ((map = All.standardChildDomainChildren.getVariables(graph, context, map)) == null) {
                map = new HashMap<String, Variable>();
            }
            map.put("???", this.getProxy(graph, context));
            return map;
        }
    };
    @SCLValue(type="ComponentNamingStrategy")
    public static ComponentNamingStrategy componentNamingStrategy = new CaseInsensitiveComponentNamingStrategy2();

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable input(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        try {
            Variable input;
            Variable child = context.getParent(graph);
            String s = (String)child.getPossiblePropertyValue(graph, "inputUri");
            if (s != null && !s.isEmpty() && (input = Variables.getVariable((ReadGraph)graph, (String)s)) != null) {
                return input;
            }
            Variable parent = child.getParent(graph);
            if (parent instanceof ProxyChildVariable) {
                Resource model;
                Variable var = ((ProxyChildVariable)parent).other();
                if (var.getParent(graph) == null && (model = Variables.getModel((ReadGraph)graph, (Variable)parent)) != null) {
                    var = Variables.getVariable((ReadGraph)graph, (Resource)model);
                }
                return var;
            }
            Variable input2 = (Variable)parent.getPossiblePropertyValue(graph, "input");
            if (input2 == null) {
                System.out.println("null input for: " + parent.getURI(graph));
            }
            return input2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable experiment(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        IExperiment exp;
        Variable var = Functions.input(graph, converter, context);
        SimulationResource SR = SimulationResource.getInstance((ReadGraph)graph);
        while (var != null && !graph.isInstanceOf(var.getRepresents(graph), SR.Run)) {
            var = var.getParent(graph);
        }
        if (var != null && (exp = Functions.getExperiment(graph, var)) == null) {
            return null;
        }
        return var;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable model(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable var = Functions.input(graph, converter, context);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        while (var != null && !graph.isInstanceOf(var.getRepresents(graph), MOD.StructuralModel)) {
            var = var.getParent(graph);
        }
        return var;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable self(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        try {
            Variable self = context.getParent(graph);
            return self;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> ReadGraph")
    public static ReadGraph graph(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return graph;
    }

    private static Collection<Variable> getBroadcasted(ReadGraph graph, Variable target) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Variable broadcasted = target.getPossibleProperty(graph, DOC.Relations_broadcasted);
        if (broadcasted != null) {
            result.add(broadcasted);
        }
        for (Variable child : DocumentServerUtils.getChildren(graph, target)) {
            result.addAll(Functions.getBroadcasted(graph, child));
        }
        return result;
    }

    private static ArrayList<Command> getCommands(ReadGraph graph, Collection<Variable> commandVariables, String trigger, CommandContext constants) throws DatabaseException {
        String t = trigger;
        ArrayList<Command> commands = new ArrayList<Command>();
        TreeMap<Integer, ArrayList<Command>> sequences = new TreeMap<Integer, ArrayList<Command>>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        for (Variable c : commandVariables) {
            String forbiddenKey;
            String requiredKey;
            Boolean enabled;
            Variable target;
            Connection conn;
            Variable targetConnectionPoint;
            if (t == null) {
                t = c.getName(graph);
            }
            if ((targetConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, c, conn = (Connection)c.getValue(graph))) == null || (target = targetConnectionPoint.getParent(graph)) == null || (enabled = (Boolean)target.getPossiblePropertyValue(graph, DOC.Properties_exists, (Binding)Bindings.BOOLEAN)) != null && !enabled.booleanValue()) continue;
            Integer ordinal = 1;
            try {
                String o = (String)c.getPossiblePropertyValue(graph, "ordinal");
                if (o != null) {
                    ordinal = Integer.parseInt(o);
                }
            }
            catch (NumberFormatException o) {
                // empty catch block
            }
            String constantKey = (String)target.getPossiblePropertyValue(graph, "constantKey");
            String constantValue = (String)target.getPossiblePropertyValue(graph, "constantValue");
            CommandContextMutable newConstants = (CommandContextMutable)constants;
            if (constantKey != null && constantValue != null && !constantKey.isEmpty()) {
                newConstants = new CommandContextImpl().merge(constants);
                newConstants.putString(constantKey, constantValue);
            }
            if ((requiredKey = (String)target.getPossiblePropertyValue(graph, "requiredKey")) != null && !requiredKey.isEmpty()) {
                if (newConstants == constants) {
                    newConstants = new CommandContextImpl().merge(constants);
                }
                newConstants.putRow("!!!requiredKeys", Collections.singletonList(requiredKey));
            }
            if ((forbiddenKey = (String)target.getPossiblePropertyValue(graph, "forbiddenKey")) != null && !forbiddenKey.isEmpty()) {
                if (newConstants == constants) {
                    newConstants = new CommandContextImpl().merge(constants);
                }
                newConstants.putRow("!!!forbiddenKeys", Collections.singletonList(forbiddenKey));
            }
            if (DOC.Relations_broadcast.equals(targetConnectionPoint.getPredicateResource(graph))) {
                ArrayList<Command> broadcastCommands = Functions.getCommands(graph, Functions.getBroadcasted(graph, target), t, (CommandContext)newConstants);
                sequences.put(ordinal, broadcastCommands);
                continue;
            }
            ArrayList<Command> sequenceCommands = Functions.getCommands(graph, DocumentServerUtils.getCommands(graph, target), t, (CommandContext)newConstants);
            if (sequenceCommands.size() == 0) {
                commands.add(new Command(ordinal, DocumentServerUtils.getId(graph, target), t, targetConnectionPoint.getName(graph), (CommandContext)newConstants));
                continue;
            }
            sequences.put(ordinal, sequenceCommands);
        }
        Collections.sort(commands, new Comparator<Command>(){

            @Override
            public int compare(Command o1, Command o2) {
                int y;
                int x = o1.getSequenceNumber();
                return x < (y = o2.getSequenceNumber()) ? -1 : (x == y ? 0 : 1);
            }
        });
        int spot = 0;
        for (Integer i : sequences.keySet()) {
            ArrayList sc = (ArrayList)sequences.get(i);
            while (spot < commands.size() && commands.get(spot).getSequenceNumber() < i) {
                ++spot;
            }
            int j = sc.size() - 1;
            while (j >= 0) {
                commands.add(spot, (Command)sc.get(j));
                --j;
            }
            spot += sc.size();
        }
        return commands;
    }

    public static List<Command> commandList(ReadGraph graph, Variable variable) throws DatabaseException {
        return Functions.getCommands(graph, DocumentServerUtils.getTriggerCommands(graph, variable.getParent(graph)), null, (CommandContext)new CommandContextImpl());
    }

    public static List<DataDefinition> dataDefinitions(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
        for (Variable dataDefinitionRelation : DocumentServerUtils.getDataDefinitions(graph, variable.getParent(graph))) {
            Connection dataDefinitionConnection;
            Collection<Variable> dataDefinitionProviders = DocumentServerUtils.getPossibleOtherConnectionPoints(graph, dataDefinitionRelation, dataDefinitionConnection = (Connection)dataDefinitionRelation.getValue(graph));
            if (dataDefinitionProviders == null) continue;
            for (Variable dataDefinitionProvider : dataDefinitionProviders) {
                Connection dataConnection;
                Variable dataRelation;
                Variable dataConnectionPoint;
                Collection<Variable> dataCollection;
                Variable dataDefinition = dataDefinitionProvider.getParent(graph);
                if (dataDefinition == null || (dataCollection = DocumentServerUtils.getDataRelations(graph, dataDefinition)).size() != 1 || (dataConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, dataRelation = dataCollection.iterator().next(), dataConnection = (Connection)dataRelation.getValue(graph))) == null) continue;
                Variable data = dataConnectionPoint.getParent(graph);
                String sourceProperty = (String)dataDefinition.getPropertyValue(graph, "source", (Binding)Bindings.STRING);
                String targetProperty = (String)dataDefinition.getPropertyValue(graph, "target", (Binding)Bindings.STRING);
                dataDefinitions.add(new DataDefinition(DocumentServerUtils.getId(graph, data), sourceProperty, targetProperty));
            }
        }
        return dataDefinitions;
    }

    public static AbstractEventHandler emptyOnClick(ReadGraph graph) throws DatabaseException {
        return new EventHandler(){

            @Override
            public ServerResponse handle(ReadGraph graph, CommandContext parameters) throws DatabaseException {
                return null;
            }
        };
    }

    public static AbstractEventHandler writeEventHandler(ReadGraph graph, final Variable variable, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            @Override
            public CommandResult handle(final CommandContext parameters) {
                final Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    String result = (String)session.sync((WriteInterface)new WriteResultRequest<String>(){

                        public String perform(WriteGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                            try {
                                FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                                    public String apply(String key) {
                                        return parameters.getString(key);
                                    }
                                };
                                String response = (String)fn.apply((Object)variable, (Object)pf);
                                if (response instanceof String) {
                                    String string = response;
                                    return string;
                                }
                                return null;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"printer", oldPrinter);
                            }
                            return null;
                        }
                    });
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler readEventHandler(ReadGraph graph, final Variable variable, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            @Override
            public CommandResult handle(final CommandContext parameters) {
                final Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    String result = (String)session.sync((ReadInterface)new UniqueRead<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                            try {
                                FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                                    public String apply(String key) {
                                        return parameters.getString(key);
                                    }
                                };
                                String response = (String)fn.apply((Object)variable, (Object)pf);
                                if (response instanceof String) {
                                    String string = response;
                                    return string;
                                }
                                return null;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"printer", oldPrinter);
                            }
                            return null;
                        }
                    });
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler readEventHandler2(ReadGraph graph, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            @Override
            public CommandResult handle(final CommandContext parameters) {
                final Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    CommandResult result = (CommandResult)session.sync((ReadInterface)new UniqueRead<CommandResult>(){

                        public CommandResult perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                            try {
                                Object response = fn.apply((Object)parameters);
                                if (response instanceof CommandResult) {
                                    CommandResult commandResult = (CommandResult)response;
                                    return commandResult;
                                }
                                return null;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"printer", oldPrinter);
                            }
                            return null;
                        }
                    });
                    return result;
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler writeEventHandler2(ReadGraph graph, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            @Override
            public CommandResult handle(final CommandContext parameters) {
                final Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    CommandResult result = (CommandResult)session.syncRequest((WriteResult)new WriteResultRequest<CommandResult>(){

                        public CommandResult perform(WriteGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                            try {
                                Object response = fn.apply((Object)parameters);
                                if (response instanceof CommandResult) {
                                    CommandResult commandResult = (CommandResult)response;
                                    return commandResult;
                                }
                                return null;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"printer", oldPrinter);
                            }
                            return null;
                        }
                    });
                    return result;
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler eventHandler2(ReadGraph graph, final Function fn) {
        return new AbstractEventHandler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public CommandResult handle(CommandContext parameters) {
                Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    SCLContext sclContext = SCLContext.getCurrent();
                    Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                    try {
                        Object response = fn.apply((Object)parameters);
                        if (!(response instanceof CommandResult)) return null;
                        CommandResult commandResult = (CommandResult)response;
                        return commandResult;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        return null;
                    }
                    finally {
                        sclContext.put((Object)"printer", oldPrinter);
                    }
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler eventHandler(ReadGraph graph, final Function fn) {
        return new AbstractEventHandler(){

            @Override
            public CommandResult handle(final CommandContext parameters) {
                Printer printer = (Printer)SCLContext.getCurrent().get((Object)"printer");
                try {
                    String result;
                    block8: {
                        result = "";
                        SCLContext sclContext = SCLContext.getCurrent();
                        Object oldPrinter = sclContext.put((Object)"printer", (Object)printer);
                        try {
                            try {
                                FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                                    public String apply(String key) {
                                        return parameters.getString(key);
                                    }
                                };
                                String response = (String)fn.apply((Object)pf);
                                if (response instanceof String) {
                                    result = response;
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                sclContext.put((Object)"printer", oldPrinter);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            sclContext.put((Object)"printer", oldPrinter);
                            throw throwable;
                        }
                        sclContext.put((Object)"printer", oldPrinter);
                    }
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object sclValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Object object;
        SCLContext sclContext = SCLContext.getCurrent();
        CompiledExpression exp = (CompiledExpression)graph.sync((ReadInterface)new ServerSCLValueRequest(graph, context));
        Object old = sclContext.put((Object)"graph", (Object)graph);
        try {
            object = exp.evaluate(graph, (StructuralComponent)new VariableStructuralContext(graph, context));
        }
        catch (Throwable throwable) {
            try {
                sclContext.put((Object)"graph", old);
                throw throwable;
            }
            catch (Throwable t) {
                System.err.println("Failed to compute " + context.getURI(graph));
                t.printStackTrace();
                return null;
            }
        }
        sclContext.put((Object)"graph", old);
        return object;
    }

    public static IExperiment getExperiment(ReadGraph graph, Variable variable) throws DatabaseException {
        IExperimentManager expMan;
        if (variable == null) {
            return null;
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Variable var = variable;
        Resource represents = var.getRepresents(graph);
        Resource activeRun = null;
        if (represents != null && graph.isInstanceOf(represents, SIMU.Run)) {
            activeRun = represents;
        }
        IProject project = Simantics.peekProject();
        if (activeRun != null && project != null && (expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER)) != null) {
            return expMan.getExperiment(NameUtils.getSafeName((ReadGraph)graph, (Resource)activeRun));
        }
        return null;
    }

    public static CommandContextMutable putTuple(CommandContextMutable context, String key, Object tuple) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tuple instanceof Tuple) {
            Collections.addAll(list, ((Tuple)tuple).toArray());
        } else {
            list.add(tuple);
        }
        context.putRow(key, list);
        return context;
    }

    public static List<Object> getTuples(CommandContext context, String key) {
        List rows = context.getRows(key);
        ArrayList<Object> tuples = new ArrayList<Object>();
        if (rows != null) {
            for (List row : rows) {
                switch (row.size()) {
                    case 0: {
                        tuples.add(Tuple0.INSTANCE);
                        break;
                    }
                    case 1: {
                        tuples.add(row.get(1));
                        break;
                    }
                    case 2: {
                        tuples.add(new Tuple2(row.get(0), row.get(1)));
                        break;
                    }
                    case 3: {
                        tuples.add(new Tuple3(row.get(0), row.get(1), row.get(2)));
                        break;
                    }
                    case 4: {
                        tuples.add(new Tuple4(row.get(0), row.get(1), row.get(2), row.get(3)));
                        break;
                    }
                    case 5: {
                        tuples.add(new Tuple5(row.get(0), row.get(1), row.get(2), row.get(3), row.get(4)));
                    }
                }
            }
        }
        return tuples;
    }

    public static String printContext(CommandContext context) {
        String str = context.toString();
        System.err.println(str);
        return str;
    }

    static class DocumentProxyChildVariable
    extends ProxyChildVariable {
        public DocumentProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
            super(base, parent, other, name);
        }

        public Variable create(Variable base, Variable parent, Variable other, String name) {
            return new DocumentProxyChildVariable(base, parent, other, name);
        }

        public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
            if ("???".equals(name)) {
                return new RootVariable(this, this.base.getRepresents(graph));
            }
            return super.getPossibleChild(graph, name);
        }

        public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
            Collection result = super.getChildren(graph);
            result.add(new RootVariable(this, this.base.getRepresents(graph)));
            return result;
        }
    }

    static class RootVariable
    extends StandardGraphChildVariable {
        public RootVariable(DocumentProxyChildVariable parent, Resource resource) {
            super((Variable)parent, null, resource);
        }

        public String getName(ReadGraph graph) throws DatabaseException {
            return "???";
        }

        public Variable getNameVariable(ReadGraph graph) throws DatabaseException {
            return new ConstantPropertyVariable((Variable)this, "HasName", (Object)"???", (Binding)Bindings.STRING);
        }
    }
}

