/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.Functions;
import org.simantics.structural2.variables.Connection;

public class DocumentServerUtils {
    public static Collection<Variable> getChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable property : variable.getProperties(graph)) {
            Connection conn;
            Variable childConnectionPoint;
            Collection classifications = (Collection)property.getPossiblePropertyValue(graph, "classifications");
            if (classifications == null || !classifications.contains("http://www.simantics.org/Documentation-1.2/Document/ChildRelation") || (childConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, property, conn = (Connection)property.getValue(graph))) == null) continue;
            result.add(childConnectionPoint.getParent(graph));
        }
        return result;
    }

    public static Collection<Variable> collectNodes(ReadGraph graph, Variable variable, Collection<Variable> nodes) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Resource type = variable.getPossibleType(graph);
        if (type == null) {
            return nodes;
        }
        if (!graph.isInheritedFrom(type, DOC.Components_Component)) {
            return nodes;
        }
        Boolean enabled = (Boolean)variable.getPossiblePropertyValue(graph, DOC.Properties_exists, (Binding)Bindings.BOOLEAN);
        if (enabled != null && !enabled.booleanValue()) {
            return nodes;
        }
        if (graph.isInheritedFrom(type, DOC.Components_PrimitiveComponent)) {
            nodes.add(variable);
        } else {
            for (Variable child : variable.getChildren(graph)) {
                DocumentServerUtils.collectNodes(graph, child, nodes);
            }
        }
        return nodes;
    }

    public static Variable getPossibleOtherConnectionPoint(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        Collection cpts = conn.getConnectionPoints(graph);
        if (cpts.size() != 2) {
            return null;
        }
        for (Variable cpt : cpts) {
            if (cpt.getURI(graph).equals(connectionPoint.getURI(graph))) continue;
            return cpt;
        }
        return null;
    }

    public static Collection<Variable> getPossibleOtherConnectionPoints(ReadGraph graph, Variable connectionPoint, Connection conn) throws DatabaseException {
        Collection cpts = conn.getConnectionPoints(graph);
        if (cpts.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable cpt : cpts) {
            if (cpt.getURI(graph).equals(connectionPoint.getURI(graph))) continue;
            result.add(cpt);
        }
        return result;
    }

    public static String getId(ReadGraph graph, Variable node) throws DatabaseException {
        if (node == null) {
            return "root";
        }
        String uri = node.getURI(graph);
        int l = uri.lastIndexOf("???");
        return uri.substring(l + 4);
    }

    public static Object getValue(ReadGraph graph, Variable attrib) throws DatabaseException {
        Datatype datatype = attrib.getPossibleDatatype(graph);
        if (datatype != null) {
            Binding binding = Bindings.getBeanBinding((Datatype)datatype);
            return attrib.getValue(graph, binding);
        }
        return attrib.getValue(graph);
    }

    public static Variable getParentConnectionPoint(ReadGraph graph, Variable component) throws DatabaseException {
        Variable connectionPoint = component.getPossibleProperty(graph, "parent");
        if (connectionPoint == null) {
            return null;
        }
        Connection conn = (Connection)connectionPoint.getValue(graph);
        return DocumentServerUtils.getPossibleOtherConnectionPoint(graph, connectionPoint, conn);
    }

    public static int getSequenceNumber(String seq) {
        try {
            return Integer.parseInt(seq);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static Collection<Variable> getChildConnections(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_ChildRelation);
    }

    public static Collection<Variable> getTriggerCommands(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        for (Variable var : variable.getProperties(graph, DOC.Document_CommandRelation)) {
            if (DOC.Relations_broadcasted.equals(var.getPredicateResource(graph))) continue;
            result.add(var);
        }
        return result;
    }

    public static Collection<Variable> getCommands(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_CommandRelation);
    }

    public static Collection<Variable> getDataDefinitions(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_DataDefinitionRelation);
    }

    public static Collection<Variable> getDataRelations(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_DataRelation);
    }

    public static Collection<Variable> getAttributes(ReadGraph graph, Variable variable) throws DatabaseException {
        return variable.getProperties(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_AttributeRelation);
    }

    public static Collection<Variable> getStaticAttributes(ReadGraph graph, Variable variable) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable property : DocumentServerUtils.getAttributes(graph, variable)) {
            Boolean dynamicProperty = (Boolean)property.getPossiblePropertyValue(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_AttributeRelation_dynamic);
            if (dynamicProperty != null && dynamicProperty.booleanValue()) continue;
            result.add(property);
        }
        return result;
    }

    public static Collection<Variable> getDynamicAttributes(ReadGraph graph, Variable variable) throws DatabaseException {
        return (Collection)graph.syncRequest((Read)new VariableRead<Collection<Variable>>(variable){

            public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Variable> result = new ArrayList<Variable>();
                for (Variable property : DocumentServerUtils.getAttributes(graph, this.variable)) {
                    Boolean dynamicProperty = (Boolean)property.getPossiblePropertyValue(graph, DocumentationResource.getInstance((ReadGraph)graph).Document_AttributeRelation_dynamic);
                    if (dynamicProperty == null || !dynamicProperty.booleanValue()) continue;
                    result.add(property);
                }
                return result;
            }
        });
    }

    public static Variable getPossibleDocumentRootVariable(ReadGraph graph, Variable documentPart) throws DatabaseException {
        if (documentPart instanceof Functions.RootVariable) {
            return documentPart;
        }
        Variable parent = documentPart.getParent(graph);
        if (parent == null) {
            return null;
        }
        return DocumentServerUtils.getPossibleDocumentRootVariable(graph, parent);
    }
}

